/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.data;

import com.google.gson.JsonObject;
import com.robocraft999.creategoggles.registry.CGRecipeTypes;
import dev.architectury.core.AbstractRecipeSerializer;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public record NBTCraftingRecipe(ShapedRecipe recipe) implements CraftingRecipe
{
    public boolean matches(@Nonnull CraftingContainer inv, @Nonnull Level worldIn) {
        return this.recipe().m_5818_(inv, worldIn);
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.recipe.m_7527_();
    }

    @Nonnull
    public ItemStack assemble(CraftingContainer inv) {
        HashMap allEnchants = new HashMap();
        ItemStack nbtItemResult = ItemStack.f_41583_;
        for (int slot = 0; slot < inv.m_6643_(); ++slot) {
            ItemStack nbtItem = inv.m_8020_(slot).m_41777_();
            if (nbtItem.m_41619_() || !nbtItem.m_41792_() && !nbtItem.m_41793_()) continue;
            if (nbtItem.m_41793_()) {
                allEnchants.putAll(EnchantmentHelper.m_44831_((ItemStack)nbtItem));
            }
            if (!nbtItemResult.m_41619_()) continue;
            nbtItemResult = new ItemStack((ItemLike)this.m_8043_().m_41720_());
        }
        if (!allEnchants.isEmpty() || !nbtItemResult.m_41619_()) {
            for (Map.Entry entry : allEnchants.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (enchantment.m_6589_() || EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)nbtItemResult) != 0) continue;
                nbtItemResult.m_41663_(enchantment, ((Integer)entry.getValue()).intValue());
            }
        }
        return nbtItemResult;
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.recipe().m_8043_();
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.recipe().m_6423_();
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)CGRecipeTypes.CRAFTING_NBT.get();
    }

    public boolean m_8004_(int width, int height) {
        return this.recipe().m_8004_(width, height);
    }

    public static class Serializer
    extends AbstractRecipeSerializer<NBTCraftingRecipe> {
        @Nonnull
        public NBTCraftingRecipe fromJson(@Nonnull ResourceLocation recipeId, @Nonnull JsonObject json) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_6729_(recipeId, json);
            return new NBTCraftingRecipe(recipe);
        }

        public NBTCraftingRecipe fromNetwork(@Nonnull ResourceLocation recipeId, @Nonnull FriendlyByteBuf buffer) {
            ShapedRecipe recipe = (ShapedRecipe)RecipeSerializer.f_44076_.m_8005_(recipeId, buffer);
            return new NBTCraftingRecipe(recipe);
        }

        public void toNetwork(@Nonnull FriendlyByteBuf buffer, NBTCraftingRecipe recipe) {
            RecipeSerializer.f_44076_.m_6178_(buffer, (Recipe)recipe.recipe());
        }
    }
}

