/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles;

import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class CGConfig {
    public static final ForgeConfigSpec commonSpec;
    public static final Common COMMON;
    public static final ForgeConfigSpec clientSpec;
    public static final Client CLIENT;

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Common::new);
        commonSpec = (ForgeConfigSpec)specPair.getRight();
        COMMON = (Common)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(Client::new);
        clientSpec = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (Client)specPair.getLeft();
    }

    public static class Common {
        public final ForgeConfigSpec.BooleanValue useCustomCurioGoggleSlot;
        public final ForgeConfigSpec.BooleanValue useCustomCurioBacktankSlot;
        public final ForgeConfigSpec.BooleanValue enableExperimentalFeatures;

        Common(ForgeConfigSpec.Builder builder) {
            builder.comment("General configuration settings").push("general");
            this.useCustomCurioGoggleSlot = builder.comment("Uses custom curio slot for goggles instead of the head slot").worldRestart().define("customCurioGoggleSlot", false);
            this.useCustomCurioBacktankSlot = builder.comment("Uses custom curio slot for backtank instead of the back slot").worldRestart().define("customCurioBacktankSlot", false);
            this.enableExperimentalFeatures = builder.comment("Enables experimental features").worldRestart().define("enableExperimentalFeatures", true);
            builder.pop();
        }
    }

    public static class Client {
        public final ForgeConfigSpec.BooleanValue moveGoggleToEyes;

        Client(ForgeConfigSpec.Builder builder) {
            builder.comment("Client configuration settings").push("general");
            this.moveGoggleToEyes = builder.comment("Display the goggles before the eyes and not on the forehead").define("moveGoggleToEyes", false);
        }
    }
}

