/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.crafting;

import com.google.gson.JsonObject;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.p3pp3rf1y.sophisticatedcore.Config;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;

public class ItemEnabledCondition
implements ICondition {
    private static final ResourceLocation NAME = SophisticatedCore.getRL("item_enabled");
    private final ResourceLocation itemRegistryName;

    public ItemEnabledCondition(Item item) {
        this(item.getRegistryName());
    }

    public ItemEnabledCondition(ResourceLocation itemRegistryName) {
        this.itemRegistryName = itemRegistryName;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test() {
        return Config.SERVER.enabledItems.isItemEnabled(this.itemRegistryName);
    }

    public static class Serializer
    implements IConditionSerializer<ItemEnabledCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ItemEnabledCondition value) {
            json.addProperty("itemRegistryName", value.itemRegistryName.toString());
        }

        public ItemEnabledCondition read(JsonObject json) {
            return new ItemEnabledCondition(new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"itemRegistryName")));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

