/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.forge.client.model;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.block.PackageBlock;
import agency.highlysuspect.packages.block.PackageBlockEntity;
import agency.highlysuspect.packages.client.PackageModelBakery;
import agency.highlysuspect.packages.junk.PackageStyle;
import agency.highlysuspect.packages.platform.forge.client.model.BakedQuadPackageModelBakery;
import agency.highlysuspect.packages.platform.forge.client.model.WeirdItemOverrideThing;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.client.model.data.ModelProperty;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForgePackageModel
implements IModelGeometry<ForgePackageModel> {
    protected static final ModelProperty<PackageStyle> STYLE_PROPERTY = new ModelProperty();
    protected static final ModelProperty<BlockAndTintGetter> BATG_PROPERTY = new ModelProperty();
    protected static final ModelProperty<BlockPos> BLOCKPOS_PROPERTY = new ModelProperty();
    protected final PackageModelBakery.Factory<List<BakedQuad>> modelBakeryFactory = new PackageModelBakery.Factory<List<BakedQuad>>(Packages.id("block/package")){

        @Override
        public PackageModelBakery<List<BakedQuad>> make(BakedModel baseModel, TextureAtlasSprite specialFrameSprite, TextureAtlasSprite specialInnerSprite) {
            return new BakedQuadPackageModelBakery(baseModel, specialFrameSprite, specialInnerSprite);
        }
    };

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        return this.modelBakeryFactory.getMaterials(modelGetter, missingTextureErrors);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        return new Baked(this.modelBakeryFactory.make(bakery, spriteGetter, modelTransform, modelLocation));
    }

    private static class Baked
    extends BakedModelWrapper<BakedModel> {
        private final PackageModelBakery<List<BakedQuad>> factory;
        private final WeirdItemOverrideThing itemOverrideThing;

        public Baked(PackageModelBakery<List<BakedQuad>> factory) {
            super(factory.getBaseModel());
            this.factory = factory;
            this.itemOverrideThing = new WeirdItemOverrideThing(factory){

                @Override
                @Nullable
                public BakedModel m_173464_(BakedModel originalModel, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity player, int idk) {
                    return (BakedModel)this.itemCache.bake(PackageStyle.fromItemStack(stack));
                }
            };
        }

        public BakedModel handlePerspective(ItemTransforms.TransformType cameraTransformType, PoseStack poseStack) {
            return super.handlePerspective(cameraTransformType, poseStack);
        }

        @NotNull
        public IModelData getModelData(@NotNull BlockAndTintGetter level, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull IModelData modelData) {
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof PackageBlockEntity) {
                PackageBlockEntity be = (PackageBlockEntity)blockEntity;
                return new ModelDataMap.Builder().withInitial(STYLE_PROPERTY, (Object)be.getStyle()).withInitial(BATG_PROPERTY, (Object)level).withInitial(BLOCKPOS_PROPERTY, (Object)pos).build();
            }
            return modelData;
        }

        @NotNull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull Random rand, @NotNull IModelData extraData) {
            PackageStyle style;
            PackageStyle packageStyle = style = extraData.hasProperty(STYLE_PROPERTY) ? (PackageStyle)extraData.getData(STYLE_PROPERTY) : PackageStyle.ERROR_LOL;
            if (style == null) {
                style = PackageStyle.ERROR_LOL;
            }
            return this.factory.bake(style);
        }

        public TextureAtlasSprite getParticleIcon(@NotNull IModelData data) {
            PackageStyle style = (PackageStyle)data.getData(STYLE_PROPERTY);
            BlockAndTintGetter batg = (BlockAndTintGetter)data.getData(BATG_PROPERTY);
            BlockPos pos = (BlockPos)data.getData(BLOCKPOS_PROPERTY);
            if (batg instanceof Level) {
                Level level = (Level)batg;
                if (pos != null && style != null && !(style.innerBlock() instanceof PackageBlock)) {
                    return Minecraft.m_91087_().m_91289_().m_110907_().getTexture(style.innerBlock().m_49966_(), level, pos);
                }
            }
            return super.getParticleIcon(data);
        }

        public ItemOverrides m_7343_() {
            return this.itemOverrideThing;
        }
    }

    public static class Loader
    implements IModelLoader<ForgePackageModel> {
        public static final ResourceLocation ID = Packages.id("forge_package_model_loader");

        public ForgePackageModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new ForgePackageModel();
        }

        public void m_6213_(ResourceManager mgr) {
        }
    }
}

