/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.platform.forge.client;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.net.ActionPacket;
import agency.highlysuspect.packages.platform.ClientPlatformConfig;
import agency.highlysuspect.packages.platform.ClientPlatformSupport;
import agency.highlysuspect.packages.platform.PlatformSupport;
import agency.highlysuspect.packages.platform.forge.ForgeInit;
import agency.highlysuspect.packages.platform.forge.client.ForgeClientPlatformConfig;
import agency.highlysuspect.packages.platform.forge.client.model.ForgePackageMakerModel;
import agency.highlysuspect.packages.platform.forge.client.model.ForgePackageModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class ForgeClientPlatformSupport
implements ClientPlatformSupport {
    private final List<MenuScreenEntry<?, ?>> menuScreensToRegister = new ArrayList();
    private final Map<ResourceLocation, List<ResourceLocation>> spritesToBake = new HashMap<ResourceLocation, List<ResourceLocation>>();
    private final List<BlockEntityRendererEntry<?>> blockEntityRenderersToRegister = new ArrayList();
    private final Map<PlatformSupport.RegistryHandle<? extends Block>, RenderType> renderTypesToRegister = new HashMap<PlatformSupport.RegistryHandle<? extends Block>, RenderType>();
    public final List<ClientPlatformSupport.EarlyClientsideLeftClickCallback> earlyLeftClickCallbacks = new ArrayList<ClientPlatformSupport.EarlyClientsideLeftClickCallback>();
    public final List<ClientPlatformSupport.ClientsideHoldLeftClickCallback> holdLeftClickCallbacksForCreativeMode = new ArrayList<ClientPlatformSupport.ClientsideHoldLeftClickCallback>();

    public ForgeClientPlatformSupport() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::actuallyRegisterMenuScreens);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::actuallyBakeSpritesOnto);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::actuallySetBlockEntityRenderers);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::actuallySetRenderTypes);
    }

    @Override
    public void setupCustomModelLoaders() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            ModelLoaderRegistry.registerLoader((ResourceLocation)ForgePackageModel.Loader.ID, (IModelLoader)new ForgePackageModel.Loader());
            ModelLoaderRegistry.registerLoader((ResourceLocation)ForgePackageMakerModel.Loader.ID, (IModelLoader)new ForgePackageMakerModel.Loader());
        });
        FMLJavaModLoadingContext.get().getModEventBus().addListener(e -> {
            ForgeModelBakery.addSpecialModel((ResourceLocation)Packages.id("block/package"));
            ForgeModelBakery.addSpecialModel((ResourceLocation)Packages.id("block/package_maker"));
        });
    }

    @Override
    public <T extends AbstractContainerMenu, U extends Screen> void registerMenuScreen(PlatformSupport.RegistryHandle<MenuType<T>> type, ClientPlatformSupport.MyScreenConstructor<T, U> cons) {
        this.menuScreensToRegister.add(new MenuScreenEntry<T, U>(type, cons));
    }

    private void actuallyRegisterMenuScreens(FMLClientSetupEvent e) {
        this.menuScreensToRegister.forEach(MenuScreenEntry::register);
    }

    @Override
    public void bakeSpritesOnto(ResourceLocation atlasTexture, ResourceLocation ... sprites) {
        this.spritesToBake.computeIfAbsent(atlasTexture, __ -> new ArrayList()).addAll(Arrays.asList(sprites));
    }

    private void actuallyBakeSpritesOnto(TextureStitchEvent.Pre event) {
        List<ResourceLocation> sprites = this.spritesToBake.get(event.getAtlas().m_118330_());
        if (sprites != null) {
            sprites.forEach(arg_0 -> ((TextureStitchEvent.Pre)event).addSprite(arg_0));
        }
    }

    @Override
    public <T extends BlockEntity> void setBlockEntityRenderer(PlatformSupport.RegistryHandle<? extends BlockEntityType<T>> type, BlockEntityRendererProvider<? super T> renderer) {
        this.blockEntityRenderersToRegister.add(new BlockEntityRendererEntry<T>(type, renderer));
    }

    private void actuallySetBlockEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        this.blockEntityRenderersToRegister.forEach(entry -> entry.register(event));
    }

    @Override
    public void setRenderType(PlatformSupport.RegistryHandle<? extends Block> block, RenderType type) {
        this.renderTypesToRegister.put(block, type);
    }

    private void actuallySetRenderTypes(ModelRegistryEvent e) {
        this.renderTypesToRegister.forEach((handle, layer) -> ItemBlockRenderTypes.setRenderLayer((Block)((Block)handle.get()), (RenderType)layer));
    }

    @Override
    public void installEarlyClientsideLeftClickCallback(ClientPlatformSupport.EarlyClientsideLeftClickCallback callback) {
        this.earlyLeftClickCallbacks.add(callback);
    }

    @Override
    public void installClientsideHoldLeftClickCallback(ClientPlatformSupport.ClientsideHoldLeftClickCallback callback) {
        this.holdLeftClickCallbacksForCreativeMode.add(callback);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.isCanceled() || event.getSide() != LogicalSide.CLIENT || event.getPlayer().m_5833_()) {
                return;
            }
            if (event.getPlayer().m_7500_()) {
                return;
            }
            InteractionResult r = callback.interact(event.getPlayer(), event.getWorld(), event.getHand(), event.getPos(), event.getFace());
            if (r.m_19077_()) {
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.CONSUME);
                event.setUseBlock(Event.Result.DENY);
                event.setUseItem(Event.Result.DENY);
            }
        });
    }

    @Override
    public void installClientsideUseBlockCallback(ClientPlatformSupport.ClientsideUseBlockCallback callback) {
        MinecraftForge.EVENT_BUS.addListener(event -> {
            if (event.isCanceled() || !event.isUseItem()) {
                return;
            }
            Minecraft minecraft = Minecraft.m_91087_();
            LocalPlayer player = minecraft.f_91074_;
            ClientLevel level = minecraft.f_91073_;
            HitResult hit = minecraft.f_91077_;
            if (player == null || level == null || !(hit instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult bhr = (BlockHitResult)hit;
            InteractionResult r = callback.interact((Player)player, (Level)level, InteractionHand.MAIN_HAND, bhr);
            if (r.m_19077_()) {
                event.setCanceled(true);
            }
        });
    }

    @Override
    public void sendActionPacket(ActionPacket packet) {
        ForgeInit.CHANNEL.sendToServer((Object)packet);
    }

    @Override
    public ClientPlatformConfig makeClientPlatformConfig() {
        return new ForgeClientPlatformConfig();
    }

    private record MenuScreenEntry<T extends AbstractContainerMenu, U extends Screen>(PlatformSupport.RegistryHandle<MenuType<T>> type, ClientPlatformSupport.MyScreenConstructor<T, U> cons) {
        void register() {
            MenuScreens.m_96206_((MenuType)((MenuType)this.type.get()), this.cons::create);
        }
    }

    private record BlockEntityRendererEntry<T extends BlockEntity>(PlatformSupport.RegistryHandle<? extends BlockEntityType<T>> type, BlockEntityRendererProvider<? super T> renderer) {
        void register(EntityRenderersEvent.RegisterRenderers e) {
            e.registerBlockEntityRenderer((BlockEntityType)this.type.get(), this.renderer);
        }
    }
}

