/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.junk;

import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.core.Direction;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;

public enum TwelveDirection implements StringRepresentable
{
    UP_NORTH(Direction.UP, Direction.NORTH),
    UP_SOUTH(Direction.UP, Direction.SOUTH),
    UP_EAST(Direction.UP, Direction.EAST),
    UP_WEST(Direction.UP, Direction.WEST),
    NORTH(Direction.NORTH, null),
    SOUTH(Direction.SOUTH, null),
    EAST(Direction.EAST, null),
    WEST(Direction.WEST, null),
    DOWN_NORTH(Direction.DOWN, Direction.NORTH),
    DOWN_SOUTH(Direction.DOWN, Direction.SOUTH),
    DOWN_EAST(Direction.DOWN, Direction.EAST),
    DOWN_WEST(Direction.DOWN, Direction.WEST);

    public final Direction primaryDirection;
    public final Direction secondaryDirection;
    public static final EnumMap<Direction, TwelveDirection> byPrimary;
    public static final EnumMap<Direction, TwelveDirection> ups;
    public static final EnumMap<Direction, TwelveDirection> downs;

    private TwelveDirection(Direction primaryDirection, Direction secondaryDirection) {
        this.primaryDirection = primaryDirection;
        this.secondaryDirection = secondaryDirection;
    }

    public String m_7912_() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public TwelveDirection withSecondary(Direction sec) {
        return switch (this.primaryDirection) {
            case Direction.UP -> ups.get(sec);
            case Direction.DOWN -> downs.get(sec);
            default -> this;
        };
    }

    public static TwelveDirection fromEntity(Entity ent) {
        Direction d = Direction.m_122382_((Entity)ent)[0];
        TwelveDirection td = byPrimary.get(d);
        if (d.m_122434_() != Direction.Axis.Y) {
            return td;
        }
        return td.withSecondary(ent.m_6350_().m_122424_());
    }

    public static TwelveDirection fromDirection(Direction dir) {
        return byPrimary.get(dir);
    }

    public TwelveDirection getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP_NORTH -> DOWN_SOUTH;
            case UP_EAST -> DOWN_WEST;
            case UP_SOUTH -> DOWN_NORTH;
            case UP_WEST -> DOWN_EAST;
            case NORTH -> SOUTH;
            case EAST -> WEST;
            case SOUTH -> NORTH;
            case WEST -> EAST;
            case DOWN_NORTH -> UP_SOUTH;
            case DOWN_EAST -> UP_WEST;
            case DOWN_SOUTH -> UP_NORTH;
            case DOWN_WEST -> UP_EAST;
        };
    }

    static {
        byPrimary = new EnumMap(Direction.class);
        ups = new EnumMap(Direction.class);
        downs = new EnumMap(Direction.class);
        byPrimary.put(Direction.UP, UP_NORTH);
        byPrimary.put(Direction.NORTH, NORTH);
        byPrimary.put(Direction.SOUTH, SOUTH);
        byPrimary.put(Direction.EAST, EAST);
        byPrimary.put(Direction.WEST, WEST);
        byPrimary.put(Direction.DOWN, DOWN_NORTH);
        ups.put(Direction.NORTH, UP_NORTH);
        ups.put(Direction.SOUTH, UP_SOUTH);
        ups.put(Direction.EAST, UP_EAST);
        ups.put(Direction.WEST, UP_WEST);
        downs.put(Direction.NORTH, DOWN_NORTH);
        downs.put(Direction.SOUTH, DOWN_SOUTH);
        downs.put(Direction.EAST, DOWN_EAST);
        downs.put(Direction.WEST, DOWN_WEST);
    }
}

