/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.item;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.junk.ILoveMojang;
import agency.highlysuspect.packages.junk.PackageContainer;
import agency.highlysuspect.packages.junk.PackageStyle;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public class PackageItem
extends BlockItem {
    private int nameReentrancy = 0;

    public PackageItem(Block block, Item.Properties settings) {
        super(block, settings);
    }

    public ItemStack createCustomizedStack(Block frame, Block inner, DyeColor color) {
        return new PackageContainer().writeToStackTag(new PackageStyle(frame, inner, color).writeToStackTag(new ItemStack((ItemLike)this)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Component m_7626_(ItemStack stack) {
        ItemStack contained;
        PackageContainer contents = PackageContainer.fromItemStack(stack);
        if (contents != null && !(contained = contents.getFilterStack()).m_41619_()) {
            try {
                ++this.nameReentrancy;
                MutableComponent contentsComponent = ILoveMojang.translatable("block.packages.package.nonempty.contents", contents.getCount(), contained.m_41786_());
                switch (this.nameReentrancy) {
                    case 1: {
                        MutableComponent mutableComponent = contentsComponent.m_130938_(s -> s.m_178520_(0xD0D0D0));
                        break;
                    }
                    case 2: {
                        MutableComponent mutableComponent = contentsComponent.m_130938_(s -> s.m_178520_(0xA0A0A0));
                        break;
                    }
                    case 3: {
                        MutableComponent mutableComponent = contentsComponent.m_130938_(s -> s.m_178520_(0x858585));
                        break;
                    }
                    default: {
                        MutableComponent mutableComponent = contentsComponent = contentsComponent.m_130938_(s -> s.m_178520_(0x666666));
                    }
                }
                if (this.nameReentrancy == 1) {
                    MutableComponent mutableComponent = ILoveMojang.translatable("block.packages.package.nonempty", super.m_7626_(stack), contentsComponent);
                    return mutableComponent;
                }
                MutableComponent mutableComponent = ILoveMojang.translatable("block.packages.package.nonempty.reentrant", contentsComponent);
                return mutableComponent;
            }
            finally {
                --this.nameReentrancy;
            }
        }
        return super.m_7626_(stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag mistake) {
        ItemStack root;
        PackageContainer contents = PackageContainer.fromItemStack(stack);
        if (contents != null && !(root = contents.computeRootContents()).m_41619_()) {
            int fullyMultipliedCount = contents.computeFullyMultipliedCount();
            if (contents.computeAmplificationStatus()) {
                tooltip.add((Component)ILoveMojang.translatable("packages.contents_tooltip.utimately", ILoveMojang.translatable("block.packages.package.nonempty.contents", fullyMultipliedCount, root.m_41786_()).m_130940_(ChatFormatting.DARK_RED)).m_130940_(ChatFormatting.DARK_GRAY));
            }
        }
        if (Packages.instance.proxy.hasShiftDownForTooltip()) {
            Block innerBlock;
            PackageStyle style = PackageStyle.fromItemStack(stack);
            Block frameBlock = style.frameBlock();
            if (frameBlock == (innerBlock = style.innerBlock())) {
                tooltip.add((Component)ILoveMojang.translatable("packages.style_tooltip.both", frameBlock.m_49954_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
            } else {
                tooltip.add((Component)ILoveMojang.translatable("packages.style_tooltip.frame", frameBlock.m_49954_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
                tooltip.add((Component)ILoveMojang.translatable("packages.style_tooltip.inner", innerBlock.m_49954_().m_130944_(new ChatFormatting[]{ChatFormatting.GRAY, ChatFormatting.ITALIC})));
            }
            DyeColor color = style.color();
            tooltip.add((Component)ILoveMojang.translatable("packages.style_tooltip.color", ILoveMojang.translatable("packages.style_tooltip.color." + color.m_7912_(), new Object[0]).m_130938_(s -> s.m_178520_((color == DyeColor.BLACK ? DyeColor.GRAY : color).m_41071_()).m_131155_(Boolean.valueOf(true)))));
        } else {
            tooltip.add((Component)ILoveMojang.translatable("packages.style_tooltip.hold_for_composition", ILoveMojang.translatable("packages.style_tooltip.shift", new Object[0]).m_130940_(ChatFormatting.GRAY)).m_130940_(ChatFormatting.DARK_GRAY));
        }
        super.m_7373_(stack, level, tooltip, mistake);
    }

    public boolean m_142522_(ItemStack stack) {
        if (stack.m_41613_() != 1) {
            return false;
        }
        PackageContainer container = PackageContainer.fromItemStack(stack);
        return container != null && !container.m_7983_();
    }

    public int m_142158_(ItemStack stack) {
        PackageContainer container = PackageContainer.fromItemStack(stack);
        if (container == null) {
            return 0;
        }
        return Math.min((int)(1.0f + 12.0f * container.fillPercentage()), 13);
    }

    public int m_142159_(ItemStack stack) {
        PackageContainer container = PackageContainer.fromItemStack(stack);
        if (container == null) {
            return 0xFF00FF;
        }
        if (container.isFull()) {
            return 13984618;
        }
        return 0x6666FF;
    }

    public boolean m_142207_(ItemStack me, Slot slot, ClickAction clickAction, Player player) {
        if (clickAction != ClickAction.SECONDARY || !Packages.instance.config.inventoryInteractions) {
            return super.m_142207_(me, slot, clickAction, player);
        }
        if (me.m_41613_() != 1) {
            return false;
        }
        ItemStack other = slot.m_7993_();
        if (ItemStack.m_150942_((ItemStack)me, (ItemStack)other)) {
            return false;
        }
        return PackageContainer.mutateItemStack(me, container -> {
            if (other.m_41619_() && !container.m_7983_()) {
                return this.dropIntoSlot(player, (PackageContainer)container, slot);
            }
            if (!other.m_41619_()) {
                int remainingSpaceInSlot;
                boolean absorbSuccess = this.absorbFromSlot(player, (PackageContainer)container, slot);
                if (absorbSuccess) {
                    return true;
                }
                if (container.matches(other) && container.isFull() && (remainingSpaceInSlot = Math.max(0, other.m_41741_() - other.m_41613_())) != 0) {
                    return this.dropIntoSlot(player, (PackageContainer)container, slot);
                }
            }
            return false;
        }, false);
    }

    public boolean m_142305_(ItemStack me, ItemStack other, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (clickAction != ClickAction.SECONDARY || !Packages.instance.config.inventoryInteractions) {
            return super.m_142305_(me, other, slot, clickAction, player, slotAccess);
        }
        if (me.m_41613_() != 1) {
            return false;
        }
        if (ItemStack.m_150942_((ItemStack)me, (ItemStack)other)) {
            return false;
        }
        return PackageContainer.mutateItemStack(me, container -> {
            ItemStack insertionLeftover;
            if (container.matches(other) && (insertionLeftover = container.insert(other, Integer.MAX_VALUE, false)).m_41613_() != other.m_41613_()) {
                other.m_41764_(insertionLeftover.m_41613_());
                player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
                return true;
            }
            return false;
        }, false);
    }

    private boolean absorbFromSlot(Player player, PackageContainer container, Slot slot) {
        if (slot.m_7993_().m_41619_()) {
            return false;
        }
        if (!container.matches(slot.m_7993_())) {
            return false;
        }
        if (!container.allowedInPackageAtAll(slot.m_7993_())) {
            return false;
        }
        int remainingSpaceInPackage = container.maxStackAmountAllowed(slot.m_7993_()) * 8 - container.getCount();
        ItemStack grabbedFromSlot = slot.m_150647_(remainingSpaceInPackage, remainingSpaceInPackage, player);
        if (grabbedFromSlot.m_41619_()) {
            return false;
        }
        ItemStack insertionLeftover = container.insert(grabbedFromSlot, Integer.MAX_VALUE, false);
        if (!insertionLeftover.m_41619_()) {
            Packages.LOGGER.warn("Non-empty stack (" + insertionLeftover + ") appeared in absorbFromSlot action from player " + player.m_6302_() + ". Can you file an issue about what caused this?");
        }
        player.m_5496_(SoundEvents.f_184215_, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
        return true;
    }

    private boolean dropIntoSlot(Player player, PackageContainer container, Slot slot) {
        if (!container.matches(slot.m_7993_())) {
            return false;
        }
        int remainingSpaceInSlot = Math.max(0, slot.m_6641_() - slot.m_7993_().m_41613_());
        if (remainingSpaceInSlot == 0) {
            return false;
        }
        int oneStackFromPackage = container.getFilterStack().m_41741_();
        int amountToDrop = Math.min(remainingSpaceInSlot, oneStackFromPackage);
        ItemStack toPlace = container.take(amountToDrop, true);
        if (slot.m_5857_(toPlace)) {
            toPlace = container.take(amountToDrop, false);
            ItemStack slotInsertionLeftover = slot.m_150659_(toPlace);
            if (!slotInsertionLeftover.m_41619_()) {
                Packages.LOGGER.warn("Non-empty stack (" + slotInsertionLeftover + ") appeared in dropIntoSlot action from player " + player.m_6302_() + ". Can you file an issue about what caused this? Thanks.");
            }
            player.m_5496_(SoundEvents.f_184216_, 0.8f, 0.8f + player.m_183503_().m_5822_().nextFloat() * 0.4f);
            return true;
        }
        return false;
    }
}

