/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.client;

import agency.highlysuspect.packages.client.PackageActionBinding;
import agency.highlysuspect.packages.net.PackageAction;
import agency.highlysuspect.packages.platform.ClientPlatformConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public class PackagesClientConfig {
    public PackageActionBinding insertOne = new PackageActionBinding.Builder(PackageAction.INSERT_ONE).use().build();
    public PackageActionBinding insertStack = new PackageActionBinding.Builder(PackageAction.INSERT_STACK).use().sneak().build();
    public PackageActionBinding insertAll = new PackageActionBinding.Builder(PackageAction.INSERT_ALL).use().ctrl().build();
    public PackageActionBinding takeOne = new PackageActionBinding.Builder(PackageAction.TAKE_ONE).punch().build();
    public PackageActionBinding takeStack = new PackageActionBinding.Builder(PackageAction.TAKE_STACK).punch().sneak().build();
    public PackageActionBinding takeAll = new PackageActionBinding.Builder(PackageAction.TAKE_ALL).punch().ctrl().build();
    public int punchRepeat = -1;
    public boolean cacheMeshes = false;
    public boolean swapRedAndBlue = false;
    public boolean frexSupport = true;
    public transient List<PackageActionBinding> sortedBindings = new ArrayList<PackageActionBinding>();

    public static PackagesClientConfig makeConfig(ClientPlatformConfig cfgSource) {
        PackagesClientConfig cfg = new PackagesClientConfig();
        cfg.insertOne = cfgSource.insertOneBinding();
        cfg.insertStack = cfgSource.insertStackBinding();
        cfg.insertAll = cfgSource.insertAllBinding();
        cfg.takeOne = cfgSource.takeOneBinding();
        cfg.takeStack = cfgSource.takeStackBinding();
        cfg.takeAll = cfgSource.takeAllBinding();
        cfg.punchRepeat = cfgSource.punchRepeat();
        cfg.cacheMeshes = cfgSource.cacheMeshes();
        cfg.swapRedAndBlue = cfgSource.swapRedAndBlue();
        cfg.frexSupport = cfgSource.frexSupport();
        cfg.finish();
        return cfg;
    }

    public void finish() {
        this.sortedBindings = new ArrayList<PackageActionBinding>();
        this.sortedBindings.addAll(Arrays.asList(this.insertOne, this.insertStack, this.insertAll, this.takeOne, this.takeStack, this.takeAll));
        this.sortedBindings.sort(Comparator.naturalOrder());
    }
}

