/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.client;

import agency.highlysuspect.packages.Packages;
import agency.highlysuspect.packages.client.PackagesClient;
import agency.highlysuspect.packages.junk.PUtil;
import agency.highlysuspect.packages.junk.PackageMakerStyle;
import agency.highlysuspect.packages.junk.PackageStyle;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public interface PackageModelBakery<T> {
    public BakedModel getBaseModel();

    public T bake(@Nullable Object var1, @Nullable DyeColor var2, @Nullable Block var3, @Nullable Block var4);

    default public T bake(@Nullable PackageStyle style) {
        if (style == null) {
            return this.bake(null, null, null, null);
        }
        return this.bake(style, style.color(), style.frameBlock(), style.innerBlock());
    }

    default public T bake(@Nullable PackageMakerStyle style) {
        if (style == null) {
            return this.bake(null, null, null, null);
        }
        return this.bake(style, style.color(), style.frameBlock(), style.innerBlock());
    }

    public static abstract class Factory<T> {
        private static final Material SPECIAL_FRAME = new Material(TextureAtlas.f_118259_, Packages.id("special/frame"));
        private static final Material SPECIAL_INNER = new Material(TextureAtlas.f_118259_, Packages.id("special/inner"));
        private final ResourceLocation blockModelId;

        public Factory(ResourceLocation blockModelId) {
            this.blockModelId = blockModelId;
        }

        public Collection<ResourceLocation> getDependencies() {
            return ImmutableList.of((Object)this.blockModelId);
        }

        public Collection<Material> getMaterials(Function<ResourceLocation, UnbakedModel> unbakedModelGetter, Set<Pair<String, String>> unresolvedTextureReferences) {
            return PUtil.concat(new Collection[]{unbakedModelGetter.apply(this.blockModelId).m_5500_(unbakedModelGetter, unresolvedTextureReferences), ImmutableList.of((Object)SPECIAL_FRAME, (Object)SPECIAL_INNER)});
        }

        public PackageModelBakery<T> make(ModelBakery loader, Function<Material, TextureAtlasSprite> textureGetter, ModelState rotationContainer, ResourceLocation modelId) {
            BakedModel baseModel = loader.m_119341_(this.blockModelId).m_7611_(loader, textureGetter, rotationContainer, modelId);
            TextureAtlasSprite specialFrameSprite = textureGetter.apply(SPECIAL_FRAME);
            TextureAtlasSprite specialInnerSprite = textureGetter.apply(SPECIAL_INNER);
            PackageModelBakery<T> bakery = this.make(baseModel, specialFrameSprite, specialInnerSprite);
            if (PackagesClient.instance.config.cacheMeshes) {
                bakery = new Caching<T>(bakery);
            }
            return bakery;
        }

        public abstract PackageModelBakery<T> make(BakedModel var1, TextureAtlasSprite var2, TextureAtlasSprite var3);
    }

    public static class Caching<T>
    implements PackageModelBakery<T> {
        private final PackageModelBakery<T> uncached;
        private final Map<Object, T> cache = new HashMap<Object, T>();
        private final Object UPDATE_LOCK = new Object();

        public Caching(PackageModelBakery<T> uncached) {
            this.uncached = uncached;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T bake(@Nullable Object cacheKey, @Nullable DyeColor faceColor, @Nullable Block frameBlock, @Nullable Block innerBlock) {
            T result = this.cache.get(cacheKey);
            if (result != null) {
                return result;
            }
            result = this.uncached.bake(cacheKey, faceColor, frameBlock, innerBlock);
            Object object = this.UPDATE_LOCK;
            synchronized (object) {
                this.cache.put(cacheKey, result);
            }
            return result;
        }

        @Override
        public BakedModel getBaseModel() {
            return this.uncached.getBaseModel();
        }
    }
}

