/*
 * Decompiled with CFR 0.152.
 */
package agency.highlysuspect.packages.block;

import agency.highlysuspect.packages.block.PBlockEntityTypes;
import agency.highlysuspect.packages.block.PackageBlockEntity;
import agency.highlysuspect.packages.item.PackageItem;
import agency.highlysuspect.packages.junk.PUtil;
import agency.highlysuspect.packages.junk.PackageContainer;
import agency.highlysuspect.packages.junk.TwelveDirection;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;

public class PackageBlock
extends Block
implements EntityBlock {
    public static final Property<TwelveDirection> FACING = EnumProperty.m_61587_((String)"facing", TwelveDirection.class);

    public PackageBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)TwelveDirection.NORTH)));
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        TwelveDirection facing = ctx.m_43723_() == null ? TwelveDirection.fromDirection(ctx.m_43719_()) : TwelveDirection.fromEntity((Entity)ctx.m_43723_()).getOpposite();
        return (BlockState)this.m_49966_().m_61124_(FACING, (Comparable)((Object)facing));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder.m_61104_(new Property[]{FACING}));
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)PBlockEntityTypes.PACKAGE.get()).m_155264_(pos, state);
    }

    public PushReaction m_5537_(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        CompoundTag blockEntityTag;
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof PackageBlockEntity)) {
            return;
        }
        PackageBlockEntity pkg = (PackageBlockEntity)blockEntity;
        if (stack.m_41788_()) {
            pkg.setCustomName(stack.m_41786_());
        }
        if (world.f_46443_ && (blockEntityTag = BlockItem.m_186336_((ItemStack)stack)) != null) {
            pkg.m_142466_(blockEntityTag);
        }
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level world, BlockPos pos) {
        return AbstractContainerMenu.m_38918_((BlockEntity)world.m_7702_(pos));
    }

    public void m_6861_(BlockState state, Level level, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean moved) {
        super.m_6861_(state, level, pos, fromBlock, fromPos, moved);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity pkg = (PackageBlockEntity)blockEntity;
            pkg.updateStickyStack();
        }
    }

    public void m_7100_(BlockState state, Level level, BlockPos pos, Random rand) {
        PackageBlockEntity pkg;
        BlockEntity blockEntity;
        Direction primaryFacing = ((TwelveDirection)((Object)state.m_61143_(PackageBlock.FACING))).primaryDirection;
        if (rand.nextInt(primaryFacing == Direction.UP ? 15 : 5) == 0 && (blockEntity = level.m_7702_(pos)) instanceof PackageBlockEntity && (pkg = (PackageBlockEntity)blockEntity).isSticky()) {
            float minX = (float)pos.m_123341_() - 0.003f;
            float minY = (float)pos.m_123342_() - 0.003f;
            float minZ = (float)pos.m_123343_() - 0.003f;
            float maxX = (float)pos.m_123341_() + 1.003f;
            float maxY = (float)pos.m_123342_() + 1.003f;
            float maxZ = (float)pos.m_123343_() + 1.003f;
            switch (primaryFacing) {
                case UP: {
                    minY = maxY;
                    break;
                }
                case DOWN: {
                    maxY = minY;
                    break;
                }
                case WEST: {
                    maxX = minX;
                    break;
                }
                case EAST: {
                    minX = maxX;
                    break;
                }
                case NORTH: {
                    maxZ = minZ;
                    break;
                }
                case SOUTH: {
                    minZ = maxZ;
                }
            }
            float x = PUtil.rangeRemap(rand.nextFloat(), 0.0f, 1.0f, minX, maxX);
            float y = PUtil.rangeRemap(rand.nextFloat(), 0.0f, 1.0f, minY, maxY);
            float z = PUtil.rangeRemap(rand.nextFloat(), 0.0f, 1.0f, minZ, maxZ);
            level.m_7106_((ParticleOptions)ParticleTypes.f_123780_, (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
        }
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        super.m_5707_(world, pos, state, player);
        if (!world.f_46443_ && player.m_7500_()) {
            PackageBlock.m_49869_((BlockState)state, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos)).forEach(s -> {
                ItemEntity ent = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, s);
                ent.m_32060_();
                ent.m_20334_(0.0, 0.0, 0.0);
                world.m_7967_((Entity)ent);
            });
        }
    }

    public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean moved) {
        if (world.m_7702_(pos) instanceof PackageBlockEntity) {
            world.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, world, pos, newState, moved);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(world, pos, state);
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof PackageBlockEntity) {
            PackageBlockEntity be = (PackageBlockEntity)blockEntity;
            be.getStyle().writeToStackTag(stack);
            new PackageContainer().writeToStackTag(stack);
        }
        return stack;
    }

    public void m_49811_(CreativeModeTab tab, NonNullList<ItemStack> stacks) {
        DyeColor[] COLORS_ORGANIZED;
        Item item = this.m_5456_();
        if (!(item instanceof PackageItem)) {
            return;
        }
        PackageItem p = (PackageItem)item;
        stacks.add((Object)p.createCustomizedStack(Blocks.f_49999_, Blocks.f_50705_, DyeColor.WHITE));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50010_, Blocks.f_50705_, DyeColor.WHITE));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50001_, Blocks.f_50742_, DyeColor.YELLOW));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50006_, Blocks.f_50742_, DyeColor.YELLOW));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50000_, Blocks.f_50741_, DyeColor.RED));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50005_, Blocks.f_50741_, DyeColor.RED));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50003_, Blocks.f_50744_, DyeColor.PINK));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50008_, Blocks.f_50744_, DyeColor.PINK));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50004_, Blocks.f_50745_, DyeColor.BROWN));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50009_, Blocks.f_50745_, DyeColor.BROWN));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50002_, Blocks.f_50743_, DyeColor.GREEN));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50007_, Blocks.f_50743_, DyeColor.GREEN));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50697_, Blocks.f_50655_, DyeColor.RED));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50698_, Blocks.f_50655_, DyeColor.RED));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50688_, Blocks.f_50656_, DyeColor.CYAN));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50689_, Blocks.f_50656_, DyeColor.CYAN));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50069_, Blocks.f_50652_, DyeColor.LIGHT_GRAY));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50387_, Blocks.f_50334_, DyeColor.LIGHT_GRAY));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50175_, Blocks.f_50122_, DyeColor.PINK));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50281_, Blocks.f_50228_, DyeColor.WHITE));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_152555_, Blocks.f_152551_, DyeColor.GRAY));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50734_, Blocks.f_50730_, DyeColor.BLACK));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50138_, Blocks.f_152597_, DyeColor.GRAY));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_152490_, Blocks.f_50492_, DyeColor.PURPLE));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50064_, Blocks.f_49992_, DyeColor.YELLOW));
        stacks.add((Object)p.createCustomizedStack(Blocks.f_50377_, Blocks.f_50379_, DyeColor.CYAN));
        for (DyeColor color : COLORS_ORGANIZED = new DyeColor[]{DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK, DyeColor.BROWN, DyeColor.BLACK, DyeColor.GRAY, DyeColor.LIGHT_GRAY, DyeColor.WHITE}) {
            Block concrete = (Block)Registry.f_122824_.m_7745_(new ResourceLocation("minecraft", color.m_7912_() + "_concrete"));
            Block powder = (Block)Registry.f_122824_.m_7745_(new ResourceLocation("minecraft", color.m_7912_() + "_concrete_powder"));
            if (concrete == Blocks.f_50016_ || powder == Blocks.f_50016_) continue;
            stacks.add((Object)p.createCustomizedStack(concrete, powder, color));
        }
        for (DyeColor color : COLORS_ORGANIZED) {
            Block terracotta = (Block)Registry.f_122824_.m_7745_(new ResourceLocation("minecraft", color.m_7912_() + "_terracotta"));
            if (terracotta == Blocks.f_50016_) continue;
            stacks.add((Object)p.createCustomizedStack(terracotta, terracotta, color));
        }
        Block copper = Blocks.f_152504_;
        Block copperCut = Blocks.f_152510_;
        do {
            stacks.add((Object)p.createCustomizedStack(copper, copperCut, DyeColor.WHITE));
            copper = WeatheringCopper.m_154904_((Block)copper).orElse(null);
            copperCut = WeatheringCopper.m_154904_((Block)copperCut).orElse(null);
        } while (copper != null && copperCut != null);
    }
}

