/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.registration.biomes;

import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import twilightforest.TwilightForestMod;

public class BiomeKeys {
    public static final DeferredRegister<Biome> BIOMES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BIOMES, (String)"twilightforest");
    public static final ResourceKey<Biome> FOREST = BiomeKeys.makeKey("forest");
    public static final ResourceKey<Biome> DENSE_FOREST = BiomeKeys.makeKey("dense_forest");
    public static final ResourceKey<Biome> FIREFLY_FOREST = BiomeKeys.makeKey("firefly_forest");
    public static final ResourceKey<Biome> CLEARING = BiomeKeys.makeKey("clearing");
    public static final ResourceKey<Biome> OAK_SAVANNAH = BiomeKeys.makeKey("oak_savannah");
    public static final ResourceKey<Biome> STREAM = BiomeKeys.makeKey("stream");
    public static final ResourceKey<Biome> LAKE = BiomeKeys.makeKey("lake");
    public static final ResourceKey<Biome> MUSHROOM_FOREST = BiomeKeys.makeKey("mushroom_forest");
    public static final ResourceKey<Biome> DENSE_MUSHROOM_FOREST = BiomeKeys.makeKey("dense_mushroom_forest");
    public static final ResourceKey<Biome> ENCHANTED_FOREST = BiomeKeys.makeKey("enchanted_forest");
    public static final ResourceKey<Biome> SPOOKY_FOREST = BiomeKeys.makeKey("spooky_forest");
    public static final ResourceKey<Biome> SWAMP = BiomeKeys.makeKey("swamp");
    public static final ResourceKey<Biome> FIRE_SWAMP = BiomeKeys.makeKey("fire_swamp");
    public static final ResourceKey<Biome> DARK_FOREST = BiomeKeys.makeKey("dark_forest");
    public static final ResourceKey<Biome> DARK_FOREST_CENTER = BiomeKeys.makeKey("dark_forest_center");
    public static final ResourceKey<Biome> SNOWY_FOREST = BiomeKeys.makeKey("snowy_forest");
    public static final ResourceKey<Biome> GLACIER = BiomeKeys.makeKey("glacier");
    public static final ResourceKey<Biome> HIGHLANDS = BiomeKeys.makeKey("highlands");
    public static final ResourceKey<Biome> THORNLANDS = BiomeKeys.makeKey("thornlands");
    public static final ResourceKey<Biome> FINAL_PLATEAU = BiomeKeys.makeKey("final_plateau");
    public static final BiomeDictionary.Type TWILIGHT = BiomeDictionary.Type.getType((String)"TWILIGHT", (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);

    private static ResourceKey<Biome> makeKey(String name) {
        BIOMES.register(name, () -> new Biome.BiomeBuilder().m_47597_(Biome.Precipitation.NONE).m_47595_(Biome.BiomeCategory.NONE).m_47611_(0.0f).m_47609_(0.0f).m_47603_(new BiomeSpecialEffects.Builder().m_48019_(0).m_48034_(0).m_48037_(0).m_48040_(0).m_48018_()).m_47601_(new BiomeGenerationSettings.Builder().m_47831_()).m_47605_(new MobSpawnSettings.Builder().m_48381_()).m_47599_(Biome.TemperatureModifier.NONE).m_47592_());
        return ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)TwilightForestMod.prefix(name));
    }

    public static void addBiomeTypes() {
        BiomeDictionary.addTypes(FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(DENSE_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes(FIREFLY_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST});
        BiomeDictionary.addTypes(CLEARING, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.PLAINS, BiomeDictionary.Type.SPARSE, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(OAK_SAVANNAH, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.addTypes(STREAM, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.RIVER});
        BiomeDictionary.addTypes(LAKE, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(MUSHROOM_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM});
        BiomeDictionary.addTypes(DENSE_MUSHROOM_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MUSHROOM, BiomeDictionary.Type.RARE, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes(ENCHANTED_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MAGICAL, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(SPOOKY_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.RARE});
        BiomeDictionary.addTypes(SWAMP, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WET});
        BiomeDictionary.addTypes(FIRE_SWAMP, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.SWAMP, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.HOT});
        BiomeDictionary.addTypes(DARK_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY});
        BiomeDictionary.addTypes(DARK_FOREST_CENTER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.DENSE, BiomeDictionary.Type.SPOOKY, BiomeDictionary.Type.MAGICAL});
        BiomeDictionary.addTypes(SNOWY_FOREST, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.CONIFEROUS, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes(GLACIER, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.SNOWY, BiomeDictionary.Type.COLD, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.SPARSE});
        BiomeDictionary.addTypes(HIGHLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.FOREST, BiomeDictionary.Type.MOUNTAIN, BiomeDictionary.Type.CONIFEROUS});
        BiomeDictionary.addTypes(THORNLANDS, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.HILLS, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.DENSE});
        BiomeDictionary.addTypes(FINAL_PLATEAU, (BiomeDictionary.Type[])new BiomeDictionary.Type[]{TWILIGHT, BiomeDictionary.Type.MESA, BiomeDictionary.Type.DEAD, BiomeDictionary.Type.DRY, BiomeDictionary.Type.WASTELAND, BiomeDictionary.Type.PLATEAU, BiomeDictionary.Type.SPARSE});
    }
}

