/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.minotaurmaze;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.NoiseEffect;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.TFConfig;
import twilightforest.block.TFBlocks;
import twilightforest.world.components.structures.TFMaze;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorIronFenceComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorRootsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeCorridorShroomsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndChestComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndFountainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndFountainLavaComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndPaintingComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndRootsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndShroomsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndTorchesComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndTrappedChestComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeDeadEndTripwireChestComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeMushRoomComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomBossComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomCollapseComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomExitComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomFountainComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomSpawnerChestsComponent;
import twilightforest.world.components.structures.minotaurmaze.MazeRoomVaultComponent;
import twilightforest.world.components.structures.minotaurmaze.MazestoneProcessor;
import twilightforest.world.components.structures.minotaurmaze.MinotaurMazePieces;
import twilightforest.world.registration.TFFeature;

public class MinotaurMazeComponent
extends TFStructureComponentOld {
    TFMaze maze;
    int[] rcoords;
    private final int level;

    public MinotaurMazeComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(MinotaurMazePieces.TFMMaze, nbt);
        this.level = nbt.m_128451_("mazeLevel");
        this.rcoords = nbt.m_128465_("roomCoords");
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        for (int i = 2; i < this.rcoords.length; ++i) {
            this.rcoords[i] = 0;
        }
        this.addRoomsToMaze(this.rcoords[0], this.rcoords[1], (this.rcoords.length + 1) / 2);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    public MinotaurMazeComponent(TFFeature feature, int index, int x, int y, int z, int entranceX, int entranceZ, int level) {
        super(MinotaurMazePieces.TFMMaze, feature, index, x, y, z);
        this.m_73519_(Direction.SOUTH);
        this.level = level;
        this.f_73383_ = feature.getComponentToAddBoundingBox(x, y, z, -this.getRadius(), 0, -this.getRadius(), this.getRadius() * 2 + 2, 5, this.getRadius() * 2 + 2, Direction.SOUTH);
        this.maze = new TFMaze(this.getMazeSize(), this.getMazeSize());
        this.setFixedMazeSeed();
        int nrooms = 7;
        this.rcoords = new int[nrooms * 2];
        this.addRoomsToMaze(entranceX, entranceZ, nrooms);
        this.maze.generateRecursiveBacktracker(0, 0);
    }

    private void addRoomsToMaze(int entranceX, int entranceZ, int nrooms) {
        this.rcoords[0] = entranceX;
        this.rcoords[1] = entranceZ;
        this.maze.carveRoom1(entranceX, entranceZ);
        for (int i = 1; i < nrooms; ++i) {
            int rz;
            int rx;
            while (this.isNearRoom(rx = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, rz = this.maze.rand.nextInt(this.getMazeSize() - 2) + 1, this.rcoords, i == 1 ? 7 : 4)) {
            }
            this.maze.carveRoom1(rx, rz);
            this.rcoords[i * 2] = rx;
            this.rcoords[i * 2 + 1] = rz;
        }
    }

    private void setFixedMazeSeed() {
        this.maze.setSeed((long)this.f_73383_.m_162395_() * 90342903L + (long)this.f_73383_.m_162396_() * 90342903L ^ (long)this.f_73383_.m_162398_());
    }

    public MinotaurMazeComponent(TFFeature feature, int index, int x, int y, int z, int level) {
        this(feature, index, x, y, z, 11, 11, level);
    }

    @Override
    protected void m_183620_(StructurePieceSerializationContext ctx, CompoundTag tagCompound) {
        super.m_183620_(ctx, tagCompound);
        tagCompound.m_128405_("mazeLevel", this.level);
        tagCompound.m_128385_("roomCoords", this.rcoords);
    }

    protected MazeRoomComponent makeRoom(Random random, int i, int dx, int dz) {
        int worldX = this.f_73383_.m_162395_() + dx * 5 - 4;
        int worldY = this.f_73383_.m_162396_();
        int worldZ = this.f_73383_.m_162398_() + dz * 5 - 4;
        MazeRoomComponent room = i == 0 ? new MazeRoomComponent(MinotaurMazePieces.TFMMR, this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : (i == 1 ? (this.level == 1 ? new MazeRoomExitComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeRoomBossComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 2 || i == 3 ? (this.level == 1 ? new MazeRoomCollapseComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeMushRoomComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : (i == 4 ? (this.level == 1 ? new MazeRoomFountainComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ) : new MazeRoomVaultComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ)) : new MazeRoomSpawnerChestsComponent(this.getFeatureType(), 3 + i, random, worldX, worldY, worldZ))));
        return room;
    }

    protected void decorateDeadEndsCorridors(Random random, StructurePieceAccessor list) {
        for (int x = 0; x < this.maze.width; ++x) {
            for (int z = 0; z < this.maze.depth; ++z) {
                TFStructureComponentOld component = null;
                if (!this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.EAST);
                }
                if (this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.WEST);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && !this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.SOUTH);
                }
                if (this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1)) {
                    component = this.makeDeadEnd(random, x, z, Direction.NORTH);
                }
                if (!this.maze.isWall(x, z, x - 1, z) && !this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z, x, z - 1) && this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x - 1, z, x - 1, z - 1) && this.maze.isWall(x - 1, z, x - 1, z + 1) && this.maze.isWall(x + 1, z, x + 1, z - 1) && this.maze.isWall(x + 1, z, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, Direction.WEST);
                }
                if (!this.maze.isWall(x, z, x, z - 1) && !this.maze.isWall(x, z, x, z + 1) && this.maze.isWall(x, z, x - 1, z) && this.maze.isWall(x, z, x + 1, z) && this.maze.isWall(x, z - 1, x - 1, z - 1) && this.maze.isWall(x, z - 1, x + 1, z - 1) && this.maze.isWall(x, z + 1, x - 1, z + 1) && this.maze.isWall(x, z + 1, x + 1, z + 1)) {
                    component = this.makeCorridor(random, x, z, Direction.SOUTH);
                }
                if (component == null) continue;
                list.m_142679_((StructurePiece)component);
                component.m_142537_(this, list, random);
            }
        }
    }

    protected MazeDeadEndComponent makeDeadEnd(Random random, int dx, int dz, Direction rotation) {
        int worldX = this.f_73383_.m_162395_() + dx * 5 + 1;
        int worldY = this.f_73383_.m_162396_();
        int worldZ = this.f_73383_.m_162398_() + dz * 5 + 1;
        int decorationType = random.nextInt(8);
        return switch (decorationType) {
            case 1 -> new MazeDeadEndChestComponent(MinotaurMazePieces.TFMMDEC, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 2 -> {
                if (random.nextBoolean()) {
                    yield new MazeDeadEndTripwireChestComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
                }
                yield new MazeDeadEndTrappedChestComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            case 3 -> new MazeDeadEndTorchesComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 4 -> new MazeDeadEndFountainComponent(MinotaurMazePieces.TFMMDEF, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 5 -> new MazeDeadEndFountainLavaComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 6 -> new MazeDeadEndPaintingComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 7 -> {
                if (this.level == 1) {
                    yield new MazeDeadEndRootsComponent(MinotaurMazePieces.TFMMDER, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
                }
                yield new MazeDeadEndShroomsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            default -> new MazeDeadEndComponent(MinotaurMazePieces.TFMMDE, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
        };
    }

    protected MazeCorridorComponent makeCorridor(Random random, int dx, int dz, Direction rotation) {
        int worldX = this.f_73383_.m_162395_() + dx * 5 + 1;
        int worldY = this.f_73383_.m_162396_();
        int worldZ = this.f_73383_.m_162398_() + dz * 5 + 1;
        int decorationType = random.nextInt(5);
        return switch (decorationType) {
            case 1 -> new MazeCorridorComponent(MinotaurMazePieces.TFMMC, this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 2 -> new MazeCorridorIronFenceComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            case 3 -> null;
            case 4 -> {
                if (this.level == 1) {
                    yield new MazeCorridorRootsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
                }
                yield new MazeCorridorShroomsComponent(this.getFeatureType(), 4, worldX, worldY, worldZ, rotation);
            }
            default -> null;
        };
    }

    public void m_142537_(StructurePiece structurecomponent, StructurePieceAccessor list, Random random) {
        super.m_142537_(structurecomponent, list, random);
        if (this.level == 1) {
            int centerX = this.f_73383_.m_162395_() + (this.f_73383_.m_162399_() - this.f_73383_.m_162395_()) / 2;
            int centerZ = this.f_73383_.m_162398_() + (this.f_73383_.m_162401_() - this.f_73383_.m_162398_()) / 2;
            MinotaurMazeComponent maze = new MinotaurMazeComponent(this.getFeatureType(), 1, centerX, this.f_73383_.m_162396_() - 10, centerZ, this.rcoords[2], this.rcoords[3], 2);
            list.m_142679_((StructurePiece)maze);
            maze.m_142537_(this, list, random);
        }
        for (int i = 0; i < this.rcoords.length / 2; ++i) {
            int dx = this.rcoords[i * 2];
            int dz = this.rcoords[i * 2 + 1];
            MazeRoomComponent room = this.makeRoom(random, i, dx, dz);
            list.m_142679_((StructurePiece)room);
            room.m_142537_(this, list, random);
        }
        this.decorateDeadEndsCorridors(random, list);
    }

    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState bedrock = Blocks.f_50752_.m_49966_();
        BlockState stone = Blocks.f_50069_.m_49966_();
        if (this.level == 2) {
            this.m_73441_(world, sbb, 0, -1, 0, this.getDiameter() + 2, 6, this.getDiameter() + 2, bedrock, AIR, false);
        }
        this.m_73535_(world, sbb, 1, 1, 1, this.getDiameter(), 4, this.getDiameter());
        boolean onlyReplaceCeiling = this.level == 1 && (Boolean)TFConfig.COMMON_CONFIG.DIMENSION.skylightForest.get() == false;
        this.m_73441_(world, sbb, 1, 5, 1, this.getDiameter(), 5, this.getDiameter(), ((Block)TFBlocks.MAZESTONE.get()).m_49966_(), stone, onlyReplaceCeiling);
        this.m_73441_(world, sbb, 1, 0, 1, this.getDiameter(), 0, this.getDiameter(), ((Block)TFBlocks.MAZESTONE_MOSAIC.get()).m_49966_(), stone, false);
        this.maze.headBlockState = ((Block)TFBlocks.DECORATIVE_MAZESTONE.get()).m_49966_();
        this.maze.wallBlockState = ((Block)TFBlocks.MAZESTONE_BRICK.get()).m_49966_();
        this.maze.rootBlockState = ((Block)TFBlocks.DECORATIVE_MAZESTONE.get()).m_49966_();
        this.maze.pillarBlockState = ((Block)TFBlocks.CUT_MAZESTONE.get()).m_49966_();
        this.maze.wallBlocks = new MazestoneProcessor();
        this.maze.torchRarity = 0.05f;
        this.maze.tall = 2;
        this.maze.head = 1;
        this.maze.roots = 1;
        this.maze.oddBias = 4;
        this.maze.copyToStructure(world, manager, generator, 1, 2, 1, this, sbb);
    }

    public int getMazeSize() {
        return 22;
    }

    public int getRadius() {
        return (int)((double)this.getMazeSize() * 2.5);
    }

    public int getDiameter() {
        return this.getMazeSize() * 5;
    }

    protected boolean isNearRoom(int dx, int dz, int[] rcoords, int range) {
        if (dx == 1 && dz == 1) {
            return true;
        }
        for (int i = 0; i < rcoords.length / 2; ++i) {
            int rx = rcoords[i * 2];
            int rz = rcoords[i * 2 + 1];
            if (rx == 0 && rz == 0 || Math.abs(dx - rx) >= range || Math.abs(dz - rz) >= range) continue;
            return true;
        }
        return false;
    }

    @Override
    public NoiseEffect m_142318_() {
        return NoiseEffect.BURY;
    }
}

