/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.lichtower;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceType;
import twilightforest.world.components.structures.lichtower.LichTowerPieces;
import twilightforest.world.components.structures.lichtower.TowerRoofComponent;
import twilightforest.world.components.structures.lichtower.TowerWingComponent;
import twilightforest.world.registration.TFFeature;

public class TowerRoofPointyComponent
extends TowerRoofComponent {
    public TowerRoofPointyComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(LichTowerPieces.TFLTRP, nbt);
    }

    public TowerRoofPointyComponent(StructurePieceType piece, CompoundTag nbt) {
        super(piece, nbt);
    }

    public TowerRoofPointyComponent(StructurePieceType piece, TFFeature feature, int i, TowerWingComponent wing, int x, int y, int z) {
        super(piece, feature, i, x, y, z);
        this.m_73519_(wing.m_73549_());
        this.height = this.size = wing.size;
        this.makeCapBB(wing);
    }

    @Override
    public void m_183269_(WorldGenLevel world, StructureFeatureManager manager, ChunkGenerator generator, Random rand, BoundingBox sbb, ChunkPos chunkPosIn, BlockPos blockPos) {
        BlockState birchSlab = Blocks.f_50400_.m_49966_();
        BlockState birchPlanks = Blocks.f_50742_.m_49966_();
        for (int y = 0; y <= this.height; ++y) {
            int max;
            int min;
            int slopeChange = this.slopeChangeForSize();
            if (y < slopeChange) {
                min = y;
                max = this.size - y - 1;
            } else {
                min = (y + slopeChange) / 2;
                max = this.size - (y + slopeChange) / 2 - 1;
            }
            int mid = min + (max - min) / 2;
            for (int x = min; x <= max; ++x) {
                for (int z = min; z <= max; ++z) {
                    this.m_73434_(world, birchPlanks, x, y, z, sbb);
                    if (x == min && (z == min || z == max) || x == max && (z == min || z == max)) {
                        this.m_73434_(world, birchSlab, x, y + 1, z, sbb);
                    }
                    if ((x != min && x != max || z != mid || x % 2 != 0) && (z != min && z != max || x != mid || z % 2 != 0) || mid == min + 1) continue;
                    this.m_73434_(world, birchSlab, x, y + 1, z, sbb);
                }
            }
        }
    }

    public int slopeChangeForSize() {
        if (this.size > 10) {
            return 3;
        }
        if (this.size > 6) {
            return 2;
        }
        return 1;
    }
}

