/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.structures.finalcastle;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.util.BoundingBoxUtils;
import twilightforest.world.components.structures.TFStructureComponentOld;
import twilightforest.world.components.structures.finalcastle.FinalCastleBridgeComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleEntranceBottomTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleEntranceSideTowerComponent;
import twilightforest.world.components.structures.finalcastle.FinalCastleFoundation13Component;
import twilightforest.world.components.structures.finalcastle.FinalCastleMazeTower13Component;
import twilightforest.world.components.structures.finalcastle.FinalCastlePieces;
import twilightforest.world.components.structures.finalcastle.FinalCastleRoof13PeakedComponent;
import twilightforest.world.registration.TFFeature;

public class FinalCastleEntranceTowerComponent
extends FinalCastleMazeTower13Component {
    public FinalCastleEntranceTowerComponent(StructurePieceSerializationContext ctx, CompoundTag nbt) {
        super(FinalCastlePieces.TFFCEnTo, nbt);
    }

    public FinalCastleEntranceTowerComponent(TFFeature feature, Random rand, int i, int x, int y, int z, Direction direction) {
        super(FinalCastlePieces.TFFCEnTo, feature, rand, i, x, y, z, 3, 2, ((Block)TFBlocks.PINK_CASTLE_RUNE_BRICK.get()).m_49966_(), direction);
    }

    @Override
    public void m_142537_(StructurePiece parent, StructurePieceAccessor list, Random rand) {
        if (parent != null && parent instanceof TFStructureComponentOld) {
            this.deco = ((TFStructureComponentOld)parent).deco;
        }
        FinalCastleFoundation13Component foundation = new FinalCastleFoundation13Component(FinalCastlePieces.TFFCToF13, this.getFeatureType(), rand, 4, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)foundation);
        foundation.m_142537_(this, list, rand);
        FinalCastleRoof13PeakedComponent roof = new FinalCastleRoof13PeakedComponent(this.getFeatureType(), rand, 4, this, this.m_142171_().m_123341_(), this.m_142171_().m_123342_(), this.m_142171_().m_123343_());
        list.m_142679_((StructurePiece)roof);
        roof.m_142537_(this, list, rand);
        int missingFloors = (this.f_73383_.m_162396_() - 127) / 8;
        int bottomFloors = missingFloors / 2;
        int middleFloors = missingFloors - bottomFloors;
        Direction facing = Rotation.CLOCKWISE_90.m_55954_(this.m_73549_());
        int howFar = 20;
        if (this.buildSideTower(list, rand, middleFloors + 1, facing, howFar) || this.buildSideTower(list, rand, middleFloors + 1, facing = Rotation.COUNTERCLOCKWISE_90.m_55954_(this.m_73549_()), howFar) || !this.buildSideTower(list, rand, middleFloors + 1, facing = Rotation.NONE.m_55954_(this.m_73549_()), howFar)) {
            // empty if block
        }
        FinalCastleEntranceBottomTowerComponent eTower = new FinalCastleEntranceBottomTowerComponent(this.getFeatureType(), rand, this.m_73548_() + 1, this.f_73383_.m_162395_() + 6, this.f_73383_.m_162396_() - middleFloors * 8, this.f_73383_.m_162398_() + 6, bottomFloors + 1, bottomFloors, facing.m_122424_());
        list.m_142679_((StructurePiece)eTower);
        eTower.m_142537_(this, list, rand);
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        opening = opening.m_6625_(middleFloors * 8);
        BlockPos bc = this.offsetTowerCCoords(opening.m_123341_(), opening.m_123342_(), opening.m_123343_(), 1, facing);
        FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.m_73548_() + 1, bc.m_123341_(), bc.m_123342_(), bc.m_123343_(), howFar - 7, facing);
        list.m_142679_((StructurePiece)bridge);
        bridge.m_142537_(this, list, rand);
    }

    private boolean buildSideTower(StructurePieceAccessor list, Random rand, int middleFloors, Direction facing, int howFar) {
        BlockPos opening = this.getValidOpeningCC(rand, facing);
        BlockPos tc = this.offsetTowerCCoords(opening.m_123341_(), opening.m_123342_(), opening.m_123343_(), howFar, facing);
        FinalCastleEntranceSideTowerComponent eTower = new FinalCastleEntranceSideTowerComponent(this.getFeatureType(), rand, this.m_73548_() + 1, tc.m_123341_(), tc.m_123342_(), tc.m_123343_(), middleFloors, middleFloors - 1, facing);
        BoundingBox largerBB = BoundingBoxUtils.cloneWithAdjustments(eTower.m_73547_(), -6, 0, -6, 6, 0, 6);
        StructurePiece intersect = list.m_141921_(largerBB);
        if (intersect == null) {
            list.m_142679_((StructurePiece)eTower);
            eTower.m_142537_(this, list, rand);
            BlockPos bc = this.offsetTowerCCoords(opening.m_123341_(), opening.m_123342_(), opening.m_123343_(), 1, facing);
            FinalCastleBridgeComponent bridge = new FinalCastleBridgeComponent(this.getFeatureType(), this.m_73548_() + 1, bc.m_123341_(), bc.m_123342_(), bc.m_123343_(), howFar - 7, facing);
            list.m_142679_((StructurePiece)bridge);
            bridge.m_142537_(this, list, rand);
            this.addOpening(opening.m_123341_(), opening.m_123342_() + 1, opening.m_123343_(), facing);
            return true;
        }
        TwilightForestMod.LOGGER.info("side entrance tower blocked");
        return false;
    }

    @Override
    public BlockPos getValidOpeningCC(Random rand, Direction facing) {
        BlockPos opening = super.getValidOpeningCC(rand, facing);
        return new BlockPos(opening.m_123341_(), 0, opening.m_123343_());
    }
}

