/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.layer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import twilightforest.world.components.biomesources.TFBiomeProvider;
import twilightforest.world.components.layer.vanillalegacy.context.Context;
import twilightforest.world.components.layer.vanillalegacy.traits.AreaTransformer0;
import twilightforest.world.registration.biomes.BiomeKeys;

public enum GenLayerTFBiomes implements AreaTransformer0
{
    INSTANCE;

    private static final int RARE_BIOME_CHANCE = 15;
    protected static final List<ResourceKey<Biome>> commonBiomes;
    protected static final List<ResourceKey<Biome>> rareBiomes;
    private Registry<Biome> registry;

    public GenLayerTFBiomes setup(Registry<Biome> registry) {
        this.registry = registry;
        return this;
    }

    @Override
    public int applyPixel(Context iNoiseRandom, int x, int y) {
        if (iNoiseRandom.nextRandom(15) == 0) {
            return this.getRandomBiome(iNoiseRandom, rareBiomes);
        }
        return this.getRandomBiome(iNoiseRandom, commonBiomes);
    }

    private int getRandomBiome(Context random, List<ResourceKey<Biome>> biomes) {
        return TFBiomeProvider.getBiomeId(biomes.get(random.nextRandom(biomes.size())), this.registry);
    }

    static {
        commonBiomes = ImmutableList.of(BiomeKeys.FOREST, BiomeKeys.DENSE_FOREST, BiomeKeys.MUSHROOM_FOREST, BiomeKeys.OAK_SAVANNAH, BiomeKeys.FIREFLY_FOREST);
        rareBiomes = ImmutableList.of(BiomeKeys.LAKE, BiomeKeys.DENSE_MUSHROOM_FOREST, BiomeKeys.ENCHANTED_FOREST, BiomeKeys.CLEARING, BiomeKeys.SPOOKY_FOREST);
    }
}

