/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.world.components.feature.trees.growers;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.OptionalInt;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.shapes.BitSetDiscreteVoxelShape;
import net.minecraft.world.phys.shapes.DiscreteVoxelShape;

public class SnowTreePlacer
extends Feature<TreeConfiguration> {
    public SnowTreePlacer(Codec<TreeConfiguration> p_67201_) {
        super(p_67201_);
    }

    public static boolean isFree(LevelSimulatedReader p_67263_, BlockPos p_67264_) {
        return SnowTreePlacer.validTreePos(p_67263_, p_67264_) || p_67263_.m_7433_(p_67264_, p_67281_ -> p_67281_.m_204336_(BlockTags.f_13106_));
    }

    private static boolean isVine(LevelSimulatedReader p_67278_, BlockPos p_67279_) {
        return p_67278_.m_7433_(p_67279_, p_67276_ -> p_67276_.m_60713_(Blocks.f_50191_));
    }

    private static boolean isBlockWater(LevelSimulatedReader p_67283_, BlockPos p_67284_) {
        return p_67283_.m_7433_(p_67284_, p_67271_ -> p_67271_.m_60713_(Blocks.f_49990_));
    }

    public static boolean isAirOrLeaves(LevelSimulatedReader p_67268_, BlockPos p_67269_) {
        return p_67268_.m_7433_(p_67269_, p_67266_ -> p_67266_.m_60795_() || p_67266_.m_204336_(BlockTags.f_13035_));
    }

    private static boolean isReplaceablePlant(LevelSimulatedReader p_67289_, BlockPos p_67290_) {
        return p_67289_.m_7433_(p_67290_, p_160551_ -> {
            Material material = p_160551_.m_60767_();
            return material == Material.f_76302_;
        });
    }

    public static boolean isBlockUnderValid(LevelSimulatedReader reader, BlockPos pos) {
        return reader.m_7433_(pos, state -> state.m_204336_(BlockTags.f_144279_)) || reader.m_7433_(pos, state -> state.m_204336_(BlockTags.f_144274_));
    }

    private static void setBlockKnownShape(LevelWriter p_67257_, BlockPos p_67258_, BlockState p_67259_) {
        p_67257_.m_7731_(p_67258_, p_67259_, 19);
    }

    public static boolean validTreePos(LevelSimulatedReader p_67273_, BlockPos p_67274_) {
        return SnowTreePlacer.isAirOrLeaves(p_67273_, p_67274_) || SnowTreePlacer.isReplaceablePlant(p_67273_, p_67274_) || SnowTreePlacer.isBlockWater(p_67273_, p_67274_);
    }

    private boolean doPlace(WorldGenLevel p_160511_, Random p_160512_, BlockPos p_160513_, BiConsumer<BlockPos, BlockState> p_160514_, BiConsumer<BlockPos, BlockState> p_160515_, TreeConfiguration p_160516_) {
        int i = p_160516_.f_68190_.m_70309_(p_160512_);
        int j = p_160516_.f_68189_.m_5969_(p_160512_, i, p_160516_);
        int k = i - j;
        int l = p_160516_.f_68189_.m_5937_(p_160512_, k);
        if (p_160513_.m_123342_() >= p_160511_.m_141937_() + 1 && p_160513_.m_123342_() + i + 1 <= p_160511_.m_151558_()) {
            if (!SnowTreePlacer.isBlockUnderValid((LevelSimulatedReader)p_160511_, p_160513_.m_7495_())) {
                return false;
            }
            OptionalInt optionalint = p_160516_.f_68191_.m_68295_();
            int i1 = this.getMaxFreeTreeHeight((LevelSimulatedReader)p_160511_, i, p_160513_, p_160516_);
            if (i1 >= i || optionalint.isPresent() && i1 >= optionalint.getAsInt()) {
                List list = p_160516_.f_68190_.m_142625_((LevelSimulatedReader)p_160511_, p_160514_, p_160512_, i1, p_160513_, p_160516_);
                list.forEach(p_160539_ -> p_160516_.f_68189_.m_161413_((LevelSimulatedReader)p_160511_, p_160515_, p_160512_, p_160516_, i1, p_160539_, j, l));
                return true;
            }
            return false;
        }
        return false;
    }

    private int getMaxFreeTreeHeight(LevelSimulatedReader p_67216_, int p_67217_, BlockPos p_67218_, TreeConfiguration p_67219_) {
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (int i = 0; i <= p_67217_ + 1; ++i) {
            int j = p_67219_.f_68191_.m_6133_(p_67217_, i);
            for (int k = -j; k <= j; ++k) {
                for (int l = -j; l <= j; ++l) {
                    blockpos$mutableblockpos.m_122154_((Vec3i)p_67218_, k, i, l);
                    if (SnowTreePlacer.isFree(p_67216_, (BlockPos)blockpos$mutableblockpos) && (p_67219_.f_68193_ || !SnowTreePlacer.isVine(p_67216_, (BlockPos)blockpos$mutableblockpos))) continue;
                    return i - 2;
                }
            }
        }
        return p_67217_;
    }

    protected void m_5974_(LevelWriter p_67221_, BlockPos p_67222_, BlockState p_67223_) {
        SnowTreePlacer.setBlockKnownShape(p_67221_, p_67222_, p_67223_);
    }

    public final boolean m_142674_(FeaturePlaceContext<TreeConfiguration> p_160530_) {
        WorldGenLevel worldgenlevel = p_160530_.m_159774_();
        Random random = p_160530_.m_159776_();
        BlockPos blockpos = p_160530_.m_159777_();
        TreeConfiguration treeconfiguration = (TreeConfiguration)p_160530_.m_159778_();
        HashSet set = Sets.newHashSet();
        HashSet set1 = Sets.newHashSet();
        HashSet set2 = Sets.newHashSet();
        BiConsumer<BlockPos, BlockState> biconsumer = (p_160555_, p_160556_) -> {
            set.add(p_160555_.m_7949_());
            worldgenlevel.m_7731_(p_160555_, p_160556_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer1 = (p_160548_, p_160549_) -> {
            set1.add(p_160548_.m_7949_());
            worldgenlevel.m_7731_(p_160548_, p_160549_, 19);
        };
        BiConsumer<BlockPos, BlockState> biconsumer2 = (p_160543_, p_160544_) -> {
            set2.add(p_160543_.m_7949_());
            worldgenlevel.m_7731_(p_160543_, p_160544_, 19);
        };
        boolean flag = this.doPlace(worldgenlevel, random, blockpos, biconsumer, biconsumer1, treeconfiguration);
        if (!(!flag || set.isEmpty() && set1.isEmpty())) {
            if (!treeconfiguration.f_68187_.isEmpty()) {
                ArrayList list = Lists.newArrayList((Iterable)set);
                ArrayList list1 = Lists.newArrayList((Iterable)set1);
                list.sort(Comparator.comparingInt(Vec3i::m_123342_));
                list1.sort(Comparator.comparingInt(Vec3i::m_123342_));
                treeconfiguration.f_68187_.forEach(p_160528_ -> p_160528_.m_142741_((LevelSimulatedReader)worldgenlevel, biconsumer2, random, list, list1));
            }
            return BoundingBox.m_162378_((Iterable)Iterables.concat((Iterable)set, (Iterable)set1, (Iterable)set2)).map(p_160521_ -> {
                DiscreteVoxelShape discretevoxelshape = SnowTreePlacer.updateLeaves((LevelAccessor)worldgenlevel, p_160521_, set, set2);
                StructureTemplate.m_74510_((LevelAccessor)worldgenlevel, (int)3, (DiscreteVoxelShape)discretevoxelshape, (int)p_160521_.m_162395_(), (int)p_160521_.m_162396_(), (int)p_160521_.m_162398_());
                return true;
            }).orElse(false);
        }
        return false;
    }

    private static DiscreteVoxelShape updateLeaves(LevelAccessor p_67203_, BoundingBox p_67204_, Set<BlockPos> p_67205_, Set<BlockPos> p_67206_) {
        ArrayList list = Lists.newArrayList();
        BitSetDiscreteVoxelShape discretevoxelshape = new BitSetDiscreteVoxelShape(p_67204_.m_71056_(), p_67204_.m_71057_(), p_67204_.m_71058_());
        int i = 6;
        for (int j = 0; j < 6; ++j) {
            list.add(Sets.newHashSet());
        }
        BlockPos.MutableBlockPos blockpos$mutableblockpos = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : Lists.newArrayList(p_67206_)) {
            if (!p_67204_.m_71051_((Vec3i)blockpos)) continue;
            discretevoxelshape.m_142703_(blockpos.m_123341_() - p_67204_.m_162395_(), blockpos.m_123342_() - p_67204_.m_162396_(), blockpos.m_123343_() - p_67204_.m_162398_());
        }
        for (BlockPos blockpos1 : Lists.newArrayList(p_67205_)) {
            if (p_67204_.m_71051_((Vec3i)blockpos1)) {
                discretevoxelshape.m_142703_(blockpos1.m_123341_() - p_67204_.m_162395_(), blockpos1.m_123342_() - p_67204_.m_162396_(), blockpos1.m_123343_() - p_67204_.m_162398_());
            }
            for (Direction direction : Direction.values()) {
                BlockState blockstate;
                blockpos$mutableblockpos.m_122159_((Vec3i)blockpos1, direction);
                if (p_67205_.contains(blockpos$mutableblockpos) || !(blockstate = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_)) continue;
                ((Set)list.get(0)).add(blockpos$mutableblockpos.m_7949_());
                SnowTreePlacer.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, (BlockState)blockstate.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(1)));
                if (!p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) continue;
                discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
            }
        }
        for (int l = 1; l < 6; ++l) {
            Set set = (Set)list.get(l - 1);
            Set set1 = (Set)list.get(l);
            for (BlockPos blockpos2 : set) {
                if (p_67204_.m_71051_((Vec3i)blockpos2)) {
                    discretevoxelshape.m_142703_(blockpos2.m_123341_() - p_67204_.m_162395_(), blockpos2.m_123342_() - p_67204_.m_162396_(), blockpos2.m_123343_() - p_67204_.m_162398_());
                }
                for (Direction direction1 : Direction.values()) {
                    int k;
                    BlockState blockstate1;
                    blockpos$mutableblockpos.m_122159_((Vec3i)blockpos2, direction1);
                    if (set.contains(blockpos$mutableblockpos) || set1.contains(blockpos$mutableblockpos) || !(blockstate1 = p_67203_.m_8055_((BlockPos)blockpos$mutableblockpos)).m_61138_((Property)BlockStateProperties.f_61414_) || (k = ((Integer)blockstate1.m_61143_((Property)BlockStateProperties.f_61414_)).intValue()) <= l + 1) continue;
                    BlockState blockstate2 = (BlockState)blockstate1.m_61124_((Property)BlockStateProperties.f_61414_, (Comparable)Integer.valueOf(l + 1));
                    SnowTreePlacer.setBlockKnownShape((LevelWriter)p_67203_, (BlockPos)blockpos$mutableblockpos, blockstate2);
                    if (p_67204_.m_71051_((Vec3i)blockpos$mutableblockpos)) {
                        discretevoxelshape.m_142703_(blockpos$mutableblockpos.m_123341_() - p_67204_.m_162395_(), blockpos$mutableblockpos.m_123342_() - p_67204_.m_162396_(), blockpos$mutableblockpos.m_123343_() - p_67204_.m_162398_());
                    }
                    set1.add(blockpos$mutableblockpos.m_7949_());
                }
            }
        }
        return discretevoxelshape;
    }
}

