/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.boss;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.advancements.TFAdvancements;
import twilightforest.block.TFBlocks;
import twilightforest.block.TwilightChest;
import twilightforest.entity.ai.GroundAttackGoal;
import twilightforest.entity.monster.Minotaur;
import twilightforest.item.TFItems;
import twilightforest.loot.TFTreasure;
import twilightforest.util.EntityUtil;
import twilightforest.world.registration.TFFeature;
import twilightforest.world.registration.TFGenerationSettings;

public class Minoshroom
extends Minotaur {
    private static final EntityDataAccessor<Boolean> GROUND_ATTACK = SynchedEntityData.m_135353_(Minoshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> GROUND_CHARGE = SynchedEntityData.m_135353_(Minoshroom.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private float prevClientSideChargeAnimation;
    private float clientSideChargeAnimation;
    private boolean groundSmashState = false;
    private final List<ServerPlayer> hurtBy = new ArrayList<ServerPlayer>();
    private final ServerBossEvent bossInfo = new ServerBossEvent(this.m_5446_(), BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);

    public Minoshroom(EntityType<? extends Minoshroom> type, Level level) {
        super(type, level);
        this.f_21364_ = 100;
        this.m_21409_(EquipmentSlot.MAINHAND, 0.0f);
    }

    @Override
    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new GroundAttackGoal(this));
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(GROUND_ATTACK, (Object)false);
        this.f_19804_.m_135372_(GROUND_CHARGE, (Object)0);
    }

    public boolean isGroundAttackCharge() {
        return (Boolean)this.f_19804_.m_135370_(GROUND_ATTACK);
    }

    public void setGroundAttackCharge(boolean flag) {
        this.f_19804_.m_135381_(GROUND_ATTACK, (Object)flag);
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Minotaur.registerAttributes().m_22268_(Attributes.f_22276_, 120.0);
    }

    public void m_6593_(@Nullable Component name) {
        super.m_6593_(name);
        this.bossInfo.m_6456_(this.m_5446_());
    }

    protected void m_8024_() {
        super.m_8024_();
        this.bossInfo.m_142711_(this.m_21223_() / this.m_21233_());
    }

    public void m_6457_(ServerPlayer player) {
        super.m_6457_(player);
        this.bossInfo.m_6543_(player);
    }

    public void m_6452_(ServerPlayer player) {
        super.m_6452_(player);
        this.bossInfo.m_6539_(player);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (this.m_8077_()) {
            this.bossInfo.m_6456_(this.m_5446_());
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.m_183503_().m_5776_()) {
            this.prevClientSideChargeAnimation = this.clientSideChargeAnimation;
            if (this.isGroundAttackCharge()) {
                this.clientSideChargeAnimation = Mth.m_14036_((float)(this.clientSideChargeAnimation + 1.0f / (float)((Integer)this.f_19804_.m_135370_(GROUND_CHARGE)).intValue() * 6.0f), (float)0.0f, (float)6.0f);
                this.groundSmashState = true;
            } else {
                this.clientSideChargeAnimation = Mth.m_14036_((float)(this.clientSideChargeAnimation - 1.0f), (float)0.0f, (float)6.0f);
                if (this.groundSmashState) {
                    BlockState block = this.m_183503_().m_8055_(this.m_142538_().m_7495_());
                    for (int i = 0; i < 80; ++i) {
                        double cx = (float)this.m_142538_().m_123341_() + this.m_183503_().m_5822_().nextFloat() * 10.0f - 5.0f;
                        double cy = this.m_142469_().f_82289_ + (double)0.1f + (double)(this.m_183503_().m_5822_().nextFloat() * 0.3f);
                        double cz = (float)this.m_142538_().m_123343_() + this.m_183503_().m_5822_().nextFloat() * 10.0f - 5.0f;
                        this.m_183503_().m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, block), cx, cy, cz, 0.0, 0.0, 0.0);
                    }
                    this.groundSmashState = false;
                }
            }
        }
    }

    @Override
    protected SoundEvent m_7515_() {
        return TFSounds.MINOSHROOM_AMBIENT;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource source) {
        return TFSounds.MINOSHROOM_HURT;
    }

    @Override
    protected SoundEvent m_5592_() {
        return TFSounds.MINOSHROOM_DEATH;
    }

    @Override
    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(TFSounds.MINOSHROOM_STEP, 0.15f, 0.8f);
    }

    @Override
    protected SoundEvent getChargeSound() {
        return TFSounds.MINOSHROOM_ATTACK;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float getChargeAnimationScale(float scale) {
        return (this.prevClientSideChargeAnimation + (this.clientSideChargeAnimation - this.prevClientSideChargeAnimation) * scale) / 6.0f;
    }

    public void setMaxCharge(int charge) {
        this.f_19804_.m_135381_(GROUND_CHARGE, (Object)charge);
    }

    @Override
    protected void m_6851_(DifficultyInstance difficulty) {
        super.m_6851_(difficulty);
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)TFItems.DIAMOND_MINOTAUR_AXE.get()));
    }

    public boolean m_6469_(DamageSource source, float amount) {
        ServerPlayer player;
        Entity entity = source.m_7639_();
        if (entity instanceof ServerPlayer && !this.hurtBy.contains(player = (ServerPlayer)entity)) {
            this.hurtBy.add(player);
        }
        return super.m_6469_(source, amount);
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
        if (!this.m_183503_().m_5776_()) {
            TFGenerationSettings.markStructureConquered(this.f_19853_, new BlockPos((Vec3i)this.m_142538_()), TFFeature.LABYRINTH);
            for (ServerPlayer player : this.hurtBy) {
                TFAdvancements.HURT_BOSS.trigger(player, (Entity)this);
            }
            TFTreasure.entityDropsIntoContainer((LivingEntity)this, this.m_7771_(true, cause).m_78975_(LootContextParamSets.f_81415_), ((TwilightChest)((Object)TFBlocks.MANGROVE_CHEST.get())).m_49966_(), EntityUtil.bossChestLocation((Mob)this));
        }
    }

    protected boolean m_6125_() {
        return false;
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    public void m_6043_() {
        if (this.m_183503_().m_46791_() == Difficulty.PEACEFUL) {
            if (this.m_21536_()) {
                this.m_183503_().m_46597_(this.m_21534_(), ((Block)TFBlocks.MINOSHROOM_BOSS_SPAWNER.get()).m_49966_());
            }
            this.m_146870_();
        } else {
            super.m_6043_();
        }
    }

    protected boolean m_7341_(Entity entity) {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    protected float m_6108_() {
        return 1.0f;
    }

    public boolean m_6072_() {
        return false;
    }
}

