/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat;

import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.item.tool.slingshot.AbstractSlingshotAmmoBehavior;
import quek.undergarden.item.tool.slingshot.SlingshotItem;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.client.model.TFModelLayers;
import twilightforest.client.model.entity.CicadaModel;
import twilightforest.client.model.entity.FireflyModel;
import twilightforest.client.model.entity.MoonwormModel;
import twilightforest.compat.TFCompat;
import twilightforest.compat.undergarden.BugProjectileRenderer;
import twilightforest.compat.undergarden.CicadaSlingshotProjectile;
import twilightforest.compat.undergarden.FireflySlingshotProjectile;
import twilightforest.compat.undergarden.MoonwormSlingshotProjectile;

public class UndergardenCompat
extends TFCompat {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"twilightforest");
    public static final RegistryObject<EntityType<CicadaSlingshotProjectile>> CICADA_SLINGSHOT = ENTITIES.register("cicada_slingshot", () -> EntityType.Builder.m_20704_(CicadaSlingshotProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_("twilightforest:cicada_slingshot"));
    public static final RegistryObject<EntityType<FireflySlingshotProjectile>> FIREFLY_SLINGSHOT = ENTITIES.register("firefly_slingshot", () -> EntityType.Builder.m_20704_(FireflySlingshotProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_("twilightforest:firefly_slingshot"));
    public static final RegistryObject<EntityType<MoonwormSlingshotProjectile>> MOONWORM_SLINGSHOT = ENTITIES.register("moonworm_slingshot", () -> EntityType.Builder.m_20704_(MoonwormSlingshotProjectile::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 0.5f).m_20712_("twilightforest:moonworm_slingshot"));

    protected UndergardenCompat() {
        super("The Undergarden");
    }

    @Override
    protected boolean preInit() {
        return true;
    }

    @Override
    protected void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            SlingshotItem.registerAmmo((ItemLike)((Block)TFBlocks.CICADA.get()).m_5456_(), (AbstractSlingshotAmmoBehavior)new AbstractSlingshotAmmoBehavior(){

                public SlingshotProjectile getProjectile(Level level, BlockPos blockPos, Player player, ItemStack itemStack) {
                    return new CicadaSlingshotProjectile(level, (LivingEntity)player);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)((Block)TFBlocks.FIREFLY.get()).m_5456_(), (AbstractSlingshotAmmoBehavior)new AbstractSlingshotAmmoBehavior(){

                public SlingshotProjectile getProjectile(Level level, BlockPos blockPos, Player player, ItemStack itemStack) {
                    return new FireflySlingshotProjectile(level, (LivingEntity)player);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)((Block)TFBlocks.MOONWORM.get()).m_5456_(), (AbstractSlingshotAmmoBehavior)new AbstractSlingshotAmmoBehavior(){

                public SlingshotProjectile getProjectile(Level level, BlockPos blockPos, Player player, ItemStack itemStack) {
                    return new MoonwormSlingshotProjectile(level, (LivingEntity)player);
                }
            });
        });
    }

    @Override
    protected void postInit() {
    }

    @Override
    protected void handleIMCs() {
    }

    @Override
    protected void initItems(RegistryEvent.Register<Item> evt) {
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerSlingshotRenders(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)CICADA_SLINGSHOT.get(), ctx -> new BugProjectileRenderer(ctx, new CicadaModel(ctx.m_174023_(TFModelLayers.CICADA)), TwilightForestMod.getModelTexture("cicada-model.png")));
        event.registerEntityRenderer((EntityType)FIREFLY_SLINGSHOT.get(), ctx -> new BugProjectileRenderer(ctx, new FireflyModel(ctx.m_174023_(TFModelLayers.FIREFLY)), TwilightForestMod.getModelTexture("firefly-tiny.png")));
        event.registerEntityRenderer((EntityType)MOONWORM_SLINGSHOT.get(), ctx -> new BugProjectileRenderer(ctx, new MoonwormModel(ctx.m_174023_(TFModelLayers.MOONWORM)), TwilightForestMod.getModelTexture("moonworm.png")));
    }
}

