/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.selene;

import java.util.List;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.selene.block_set.wood.WoodTypeRegistry;
import net.mehvahdjukaar.selene.builtincompat.CompatWoodTypes;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.map.MapDecorationRegistry;
import net.mehvahdjukaar.selene.misc.ModCriteriaTriggers;
import net.mehvahdjukaar.selene.network.ClientBoundSyncFluidsPacket;
import net.mehvahdjukaar.selene.network.ClientBoundSyncMapDecorationTypesPacket;
import net.mehvahdjukaar.selene.network.NetworkHandler;
import net.mehvahdjukaar.selene.villager_ai.VillagerAIManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.OnDatapackSyncEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="selene")
public class Selene {
    public static final String MOD_ID = "selene";
    public static final Logger LOGGER = LogManager.getLogger();

    public Selene() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        VillagerAIManager.SCHEDULES.register(bus);
        bus.addListener(Selene::init);
        MinecraftForge.EVENT_BUS.register((Object)this);
        BlockSetManager.registerBlockSetDefinition(new WoodTypeRegistry());
        BlockSetManager.registerBlockSetDefinition(new LeavesTypeRegistry());
        CompatWoodTypes.init();
    }

    public static ResourceLocation res(String replace) {
        return new ResourceLocation(MOD_ID, replace);
    }

    @SubscribeEvent
    public void addJsonListener(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)SoftFluidRegistry.INSTANCE);
        event.addListener((PreparableReloadListener)MapDecorationRegistry.DATA_DRIVEN_REGISTRY);
    }

    @SubscribeEvent
    public void onDataLoad(OnDatapackSyncEvent event) {
        if (ServerLifecycleHooks.getCurrentServer() != null) {
            List playerList = event.getPlayer() != null ? List.of(event.getPlayer()) : event.getPlayerList().m_11314_();
            playerList.forEach(serverPlayer -> {
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientBoundSyncFluidsPacket(SoftFluidRegistry.getRegisteredFluids()));
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new ClientBoundSyncMapDecorationTypesPacket(MapDecorationRegistry.DATA_DRIVEN_REGISTRY.getTypes()));
            });
        }
    }

    public static void init(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ModCriteriaTriggers.init();
            NetworkHandler.registerMessages();
            VillagerAIManager.init();
        });
    }
}

