/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xfacthd.framedblocks.api.block.IFramedBlock;
import xfacthd.framedblocks.api.type.IBlockType;
import xfacthd.framedblocks.common.crafting.FramingSawRecipe;

public final class FramingSawRecipeSerializer
extends ForgeRegistryEntry<RecipeSerializer<?>>
implements RecipeSerializer<FramingSawRecipe> {
    public FramingSawRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
        boolean disabled = GsonHelper.m_13855_((JsonObject)json, (String)"disabled", (boolean)false);
        int material = GsonHelper.m_13927_((JsonObject)json, (String)"material");
        if (material <= 0) {
            throw new JsonSyntaxException("Value of 'material' must be greater than 0");
        }
        Ingredient additive = null;
        int additiveCount = 0;
        if (json.has("additives")) {
            JsonArray additiveArr = GsonHelper.m_13933_((JsonObject)json, (String)"additives");
            if (additiveArr.size() > 1 && !disabled) {
                throw new JsonSyntaxException("More than 1 additive is currently not supported");
            }
            JsonObject firstAdditive = additiveArr.get(0).getAsJsonObject();
            additive = Ingredient.m_43917_((JsonElement)firstAdditive.get("ingredient"));
            additiveCount = GsonHelper.m_13927_((JsonObject)firstAdditive, (String)"count");
            if (additiveCount <= 0) {
                throw new JsonSyntaxException("Value of 'additive_count' must be greater than 0");
            }
        }
        JsonObject resultObj = GsonHelper.m_13930_((JsonObject)json, (String)"result");
        ItemStack result = CraftingHelper.getItemStack((JsonObject)resultObj, (boolean)false);
        IBlockType resultType = FramingSawRecipeSerializer.findResultType(result);
        return new FramingSawRecipe(recipeId, material, additive, additiveCount, result, resultType, disabled);
    }

    public FramingSawRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
        int material = buffer.readInt();
        Ingredient additive = null;
        int additiveCount = 0;
        if (buffer.readBoolean()) {
            additive = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            additiveCount = buffer.readInt();
        }
        ItemStack result = buffer.m_130267_();
        IBlockType resultType = FramingSawRecipeSerializer.findResultType(result);
        boolean disabled = buffer.readBoolean();
        return new FramingSawRecipe(recipeId, material, additive, additiveCount, result, resultType, disabled);
    }

    public void toNetwork(FriendlyByteBuf buffer, FramingSawRecipe recipe) {
        buffer.writeInt(recipe.getMaterialAmount());
        Ingredient additive = recipe.getAdditive();
        if (additive != null) {
            buffer.writeBoolean(true);
            additive.m_43923_(buffer);
            buffer.writeInt(recipe.getAdditiveCount());
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130055_(recipe.m_8043_());
        buffer.writeBoolean(recipe.isDisabled());
    }

    private static IBlockType findResultType(ItemStack result) {
        Item item = result.m_41720_();
        if (!(item instanceof BlockItem)) {
            throw new JsonSyntaxException("Result items must be BlockItems");
        }
        BlockItem item2 = (BlockItem)item;
        Block block = item2.m_40614_();
        if (!(block instanceof IFramedBlock)) {
            throw new JsonSyntaxException("Block of result items must be IFramedBlocks");
        }
        IFramedBlock block2 = (IFramedBlock)block;
        return block2.getBlockType();
    }
}

