/*
 * Decompiled with CFR 0.152.
 */
package xfacthd.framedblocks.common.block.interactive;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import xfacthd.framedblocks.api.util.Utils;
import xfacthd.framedblocks.common.block.interactive.FramedButtonBlock;
import xfacthd.framedblocks.common.data.BlockType;

public class FramedLargeButtonBlock
extends FramedButtonBlock {
    private static final VoxelShape SHAPE_BOTTOM = FramedLargeButtonBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final VoxelShape SHAPE_BOTTOM_PRESSED = FramedLargeButtonBlock.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP = FramedLargeButtonBlock.m_49796_((double)1.0, (double)14.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_TOP_PRESSED = FramedLargeButtonBlock.m_49796_((double)1.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape[] SHAPES_HORIZONTAL = FramedLargeButtonBlock.makeHorizontalShapes();

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return FramedLargeButtonBlock.getShape(state);
    }

    public float[] getBeaconColorMultiplier(BlockState state, LevelReader level, BlockPos pos, BlockPos beaconPos) {
        if (state.m_61143_((Property)f_53179_) != AttachFace.WALL) {
            return this.getCamoBeaconColorMultiplier(level, pos, beaconPos);
        }
        return null;
    }

    @Override
    public BlockType getBlockType() {
        return BlockType.FRAMED_LARGE_BUTTON;
    }

    public static VoxelShape getShape(BlockState state) {
        boolean pressed = (Boolean)state.m_61143_((Property)f_51045_);
        return switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            default -> throw new IncompatibleClassChangeError();
            case AttachFace.FLOOR -> {
                if (pressed) {
                    yield SHAPE_BOTTOM_PRESSED;
                }
                yield SHAPE_BOTTOM;
            }
            case AttachFace.CEILING -> {
                if (pressed) {
                    yield SHAPE_TOP_PRESSED;
                }
                yield SHAPE_TOP;
            }
            case AttachFace.WALL -> {
                int idx = ((Direction)state.m_61143_((Property)f_54117_)).m_122416_() + (pressed ? 4 : 0);
                yield SHAPES_HORIZONTAL[idx];
            }
        };
    }

    private static VoxelShape[] makeHorizontalShapes() {
        VoxelShape shape = FramedLargeButtonBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)2.0);
        VoxelShape shapePressed = FramedLargeButtonBlock.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)1.0);
        VoxelShape[] shapes = new VoxelShape[8];
        for (Direction dir : Direction.Plane.HORIZONTAL) {
            shapes[dir.m_122416_()] = Utils.rotateShape(Direction.SOUTH, dir, shape);
            shapes[dir.m_122416_() + 4] = Utils.rotateShape(Direction.SOUTH, dir, shapePressed);
        }
        return shapes;
    }
}

