/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.client.model;

import cofh.lib.client.renderer.model.BackfaceBakedQuad;
import cofh.lib.util.Constants;
import cofh.thermal.dynamics.client.renderer.model.DuctBakedModel;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockElement;
import net.minecraft.client.renderer.block.model.BlockElementFace;
import net.minecraft.client.renderer.block.model.BlockModel;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.client.model.IModelBuilder;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import net.minecraftforge.client.model.geometry.IModelGeometryPart;

public class DuctModel
implements IModelGeometry<DuctModel> {
    private final Map<String, Map<String, BlockElement>> parts;
    protected static List<DuctBakedModel> bakedModels = new ArrayList<DuctBakedModel>();
    private static final IModelGeometryPart INV = new IModelGeometryPart(){

        public String name() {
            return "inv";
        }

        public void addQuads(IModelConfiguration owner, IModelBuilder<?> modelBuilder, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ResourceLocation modelLocation) {
        }
    };

    public static void clearCaches() {
        for (DuctBakedModel model : bakedModels) {
            model.clearCache();
        }
    }

    public DuctModel(Map<String, Map<String, BlockElement>> parts) {
        this.parts = parts;
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        boolean isInventory = owner.getPartVisibility(INV, false);
        EnumMap<Direction, List<BakedQuad>> center = this.buildCenter(owner, spriteGetter, modelTransform, modelLocation);
        EnumMap<Direction, List<BakedQuad>> centerFill = this.buildCenterFill(owner, spriteGetter, modelTransform, modelLocation);
        EnumMap<Direction, List<BakedQuad>> ductSides = this.buildGroupParts("duct", owner, spriteGetter, modelTransform, modelLocation);
        EnumMap<Direction, List<BakedQuad>> ductFill = this.buildGroupParts("fill", owner, spriteGetter, modelTransform, modelLocation);
        EnumMap<Direction, List<BakedQuad>> connections = this.buildGroupParts("attach", owner, spriteGetter, modelTransform, modelLocation);
        DuctBakedModel model = new DuctBakedModel(owner, spriteGetter.apply(owner.resolveTexture("particle")), center, centerFill, ductSides, ductFill, connections, isInventory);
        bakedModels.add(model);
        return model;
    }

    public Collection<Material> getTextures(IModelConfiguration owner, Function<ResourceLocation, UnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        LinkedList<Material> materials = new LinkedList<Material>();
        for (Map<String, BlockElement> namedPart : this.parts.values()) {
            for (BlockElement part : namedPart.values()) {
                for (BlockElementFace face : part.f_111310_.values()) {
                    Material mat = owner.resolveTexture(face.f_111356_);
                    if (MissingTextureAtlasSprite.m_118071_().equals((Object)mat.m_119203_())) {
                        missingTextureErrors.add((Pair<String, String>)Pair.of((Object)face.f_111356_, (Object)owner.getModelName()));
                    }
                    materials.add(mat);
                }
            }
        }
        return materials;
    }

    private EnumMap<Direction, List<BakedQuad>> buildCenter(IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteFunc, ModelState transform, ResourceLocation modelLoc) {
        BlockElement back;
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        BlockElement front = this.getPart("center/duct", "frontface");
        if (front != null) {
            EnumMap<Direction, List<BakedQuad>> baked = this.bake(front, owner, spriteFunc, transform, modelLoc);
            DuctModel.merge(quads, baked);
        }
        if ((back = this.getPart("center/duct", "backface")) != null) {
            EnumMap<Direction, List<BakedQuad>> baked = this.bakeBack(back, owner, spriteFunc, transform, modelLoc);
            DuctModel.flip(baked);
            DuctModel.merge(quads, baked);
        }
        return quads;
    }

    private EnumMap<Direction, List<BakedQuad>> buildCenterFill(IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteFunc, ModelState transform, ResourceLocation modelLoc) {
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        BlockElement frontFill = this.getPart("center/fill", "frontface");
        if (frontFill != null) {
            EnumMap<Direction, List<BakedQuad>> baked = this.bake(frontFill, owner, spriteFunc, transform, modelLoc);
            DuctModel.merge(quads, baked);
        }
        return quads;
    }

    private EnumMap<Direction, List<BakedQuad>> buildGroupParts(String groupPart, IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteFunc, ModelState transform, ResourceLocation modelLoc) {
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        DuctModel.fill(quads, Arrays.asList(Constants.DIRECTIONS), LinkedList::new);
        for (Direction dir : Constants.DIRECTIONS) {
            String group = dir.m_122433_() + "/" + groupPart;
            Map<String, BlockElement> groupParts = this.parts.get(group);
            if (groupParts == null) continue;
            List<BakedQuad> list = quads.get(dir);
            for (BlockElement part : groupParts.values()) {
                EnumMap<Direction, List<BakedQuad>> baked = this.bake(part, owner, spriteFunc, transform, modelLoc);
                DuctModel.flatMerge(list, baked);
            }
        }
        return quads;
    }

    private EnumMap<Direction, List<BakedQuad>> bake(BlockElement part, IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteFunc, ModelState transform, ResourceLocation modelLoc) {
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        DuctModel.fill(quads, part.f_111310_.keySet(), LinkedList::new);
        for (Map.Entry entry : part.f_111310_.entrySet()) {
            Direction dir = (Direction)entry.getKey();
            BlockElementFace face = (BlockElementFace)entry.getValue();
            TextureAtlasSprite sprite = spriteFunc.apply(owner.resolveTexture(face.f_111356_));
            quads.get(dir).add(BlockModel.makeBakedQuad((BlockElement)part, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)dir, (ModelState)transform, (ResourceLocation)modelLoc));
        }
        return quads;
    }

    private EnumMap<Direction, List<BakedQuad>> bakeBack(BlockElement part, IModelConfiguration owner, Function<Material, TextureAtlasSprite> spriteFunc, ModelState transform, ResourceLocation modelLoc) {
        EnumMap<Direction, List<BakedQuad>> quads = new EnumMap<Direction, List<BakedQuad>>(Direction.class);
        DuctModel.fill(quads, part.f_111310_.keySet(), LinkedList::new);
        for (Map.Entry entry : part.f_111310_.entrySet()) {
            Direction dir = (Direction)entry.getKey();
            BlockElementFace face = (BlockElementFace)entry.getValue();
            TextureAtlasSprite sprite = spriteFunc.apply(owner.resolveTexture(face.f_111356_));
            quads.get(dir).add((BakedQuad)BackfaceBakedQuad.from((BakedQuad)BlockModel.makeBakedQuad((BlockElement)part, (BlockElementFace)face, (TextureAtlasSprite)sprite, (Direction)dir, (ModelState)transform, (ResourceLocation)modelLoc)));
        }
        return quads;
    }

    @Nullable
    private BlockElement getPart(String group, String name) {
        Map<String, BlockElement> namedParts = this.parts.get(group);
        if (namedParts == null) {
            return null;
        }
        return namedParts.get(name);
    }

    private static <K, V> void fill(Map<K, V> map, Iterable<K> keys, Supplier<V> sup) {
        for (K key : keys) {
            map.put(key, sup.get());
        }
    }

    private static <K, T> void merge(Map<K, List<T>> dest, Map<K, List<T>> src) {
        for (K k : src.keySet()) {
            List<T> destList = dest.get(k);
            List<T> srcList = src.get(k);
            if (destList == null) {
                dest.put(k, srcList);
                continue;
            }
            destList.addAll(srcList);
        }
    }

    private static <T> void flatMerge(List<T> dest, Map<?, List<T>> src) {
        for (List<T> value : src.values()) {
            dest.addAll(value);
        }
    }

    private static <T> void flip(EnumMap<Direction, T> map) {
        map.put(Direction.UP, map.put(Direction.DOWN, map.get(Direction.UP)));
        map.put(Direction.SOUTH, map.put(Direction.NORTH, map.get(Direction.SOUTH)));
        map.put(Direction.EAST, map.put(Direction.WEST, map.get(Direction.EAST)));
    }

    public static class Loader
    implements IModelLoader<DuctModel> {
        private Map<String, Map<String, BlockElement>> parseElements(JsonDeserializationContext ctx, JsonObject model) {
            HashMap<String, Map<String, BlockElement>> parts = new HashMap<String, Map<String, BlockElement>>();
            if (model.has("elements")) {
                for (JsonElement element : GsonHelper.m_13933_((JsonObject)model, (String)"elements")) {
                    JsonObject obj = element.getAsJsonObject();
                    BlockElement part = (BlockElement)ctx.deserialize((JsonElement)obj, BlockElement.class);
                    String group = GsonHelper.m_13851_((JsonObject)obj, (String)"group", null);
                    String name = GsonHelper.m_13906_((JsonObject)obj, (String)"name");
                    Map groupParts = parts.computeIfAbsent(group, e -> new HashMap());
                    groupParts.put(name, part);
                }
            }
            return parts;
        }

        public void m_6213_(ResourceManager resourceManager) {
        }

        public DuctModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            return new DuctModel(this.parseElements(deserializationContext, modelContents));
        }
    }
}

