/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.dynamics.block.entity;

import cofh.core.block.entity.SecurableBlockEntity;
import cofh.core.network.packet.server.TileConfigPacket;
import cofh.lib.api.IStorageCallback;
import cofh.lib.api.StorageGroup;
import cofh.lib.api.block.entity.IPacketHandlerTile;
import cofh.lib.api.inventory.IItemStackHolder;
import cofh.lib.inventory.IOItemInv;
import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.StackValidatedItemStorage;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.BlockStatePropertiesCoFH;
import cofh.thermal.core.config.ThermalCoreConfig;
import cofh.thermal.dynamics.init.TDynBlockEntities;
import cofh.thermal.dynamics.inventory.container.ItemBufferContainer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemBufferBlockEntity
extends SecurableBlockEntity
implements MenuProvider {
    protected IOItemInv inventory = new IOItemInv((IStorageCallback)this, "ItemInv");
    protected boolean latchMode = false;
    protected boolean checkNBT = true;
    protected boolean inputLock;
    protected boolean outputLock;
    protected LazyOptional<?> inputCap = LazyOptional.empty();
    protected LazyOptional<?> outputCap = LazyOptional.empty();

    public ItemBufferBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)TDynBlockEntities.ITEM_BUFFER_BLOCK_ENTITY.get(), pos, state);
        int i;
        StackValidatedItemStorage[] accessible = new StackValidatedItemStorage[9];
        ItemStorageCoFH[] internal = new ItemStorageCoFH[9];
        for (i = 0; i < 9; ++i) {
            internal[i] = new ItemStorageCoFH();
            accessible[i] = new StackValidatedItemStorage((IItemStackHolder)internal[i]).setCheckNBT(() -> this.checkNBT);
        }
        for (i = 0; i < 9; ++i) {
            this.inventory.addSlot((ItemStorageCoFH)accessible[i], StorageGroup.ACCESSIBLE);
        }
        for (i = 0; i < 9; ++i) {
            this.inventory.addSlot(internal[i], StorageGroup.INTERNAL);
        }
        this.inventory.initHandlers();
        this.inventory.setConditions(() -> !this.inputLock, () -> !this.outputLock);
    }

    public int invSize() {
        return this.inventory.getSlots();
    }

    public IOItemInv getItemInv() {
        return this.inventory;
    }

    public void m_142339_(Level level) {
        super.m_142339_(level);
        this.updateHandlers();
    }

    public void m_155250_(BlockState state) {
        super.m_155250_(state);
        this.updateHandlers();
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int i, Inventory inventory, Player player) {
        return new ItemBufferContainer(i, this.f_58857_, this.f_58858_, inventory, player);
    }

    public void setLatchMode(boolean latchMode) {
        boolean curLatch = this.latchMode;
        this.latchMode = latchMode;
        TileConfigPacket.sendToServer((IPacketHandlerTile)this);
        this.latchMode = curLatch;
    }

    public boolean getLatchMode() {
        return this.latchMode;
    }

    public void setCheckNBT(boolean checkNBT) {
        boolean curCheckNBT = this.checkNBT;
        this.checkNBT = checkNBT;
        TileConfigPacket.sendToServer((IPacketHandlerTile)this);
        this.checkNBT = curCheckNBT;
    }

    public boolean getCheckNBT() {
        return this.checkNBT;
    }

    public void onReplaced(BlockState state, Level worldIn, BlockPos pos, BlockState newState) {
        if (!((Boolean)ThermalCoreConfig.keepItems.get()).booleanValue()) {
            for (int i = 0; i < this.invSize() - 9; ++i) {
                Utils.dropItemStackIntoWorldWithRandomness((ItemStack)this.inventory.getStackInSlot(i), (Level)worldIn, (BlockPos)pos);
            }
        }
    }

    public FriendlyByteBuf getConfigPacket(FriendlyByteBuf buffer) {
        super.getConfigPacket(buffer);
        buffer.writeBoolean(this.latchMode);
        buffer.writeBoolean(this.checkNBT);
        return buffer;
    }

    public void handleConfigPacket(FriendlyByteBuf buffer) {
        super.handleConfigPacket(buffer);
        this.latchMode = buffer.readBoolean();
        this.checkNBT = buffer.readBoolean();
        if (this.latchMode) {
            if (this.inventory.isConfigEmpty() || this.inventory.isBufferEmpty()) {
                this.inputLock = false;
                this.outputLock = true;
            } else if (this.outputLock) {
                if (this.inventory.isBufferFull()) {
                    this.inputLock = true;
                    this.outputLock = false;
                } else if (this.inventory.isBufferEmpty()) {
                    this.inputLock = false;
                    this.outputLock = true;
                }
            }
        } else {
            this.outputLock = false;
            this.inputLock = false;
        }
        this.markChunkUnsaved();
    }

    public FriendlyByteBuf getGuiPacket(FriendlyByteBuf buffer) {
        super.getGuiPacket(buffer);
        buffer.writeBoolean(this.latchMode);
        buffer.writeBoolean(this.checkNBT);
        return buffer;
    }

    public void handleGuiPacket(FriendlyByteBuf buffer) {
        super.handleGuiPacket(buffer);
        this.latchMode = buffer.readBoolean();
        this.checkNBT = buffer.readBoolean();
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.read(nbt);
        this.latchMode = nbt.m_128471_("Mode");
        this.checkNBT = nbt.m_128471_("CheckNBT");
        this.updateHandlers();
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        this.inventory.write(nbt);
        nbt.m_128379_("Mode", this.latchMode);
        nbt.m_128379_("CheckNBT", this.checkNBT);
    }

    public Component m_5446_() {
        return new TranslatableComponent(this.m_58900_().m_60734_().m_7705_());
    }

    public void onInventoryChanged(int slot) {
        if (this.latchMode) {
            if (this.inventory.isConfigEmpty() || this.inventory.isBufferEmpty()) {
                this.inputLock = false;
                this.outputLock = true;
            } else if (this.outputLock) {
                if (this.inventory.isBufferFull()) {
                    this.inputLock = true;
                    this.outputLock = false;
                } else if (this.inventory.isBufferEmpty()) {
                    this.inputLock = false;
                    this.outputLock = true;
                }
            }
        }
    }

    protected void updateHandlers() {
        LazyOptional<?> prevInputCap = this.inputCap;
        LazyOptional<?> prevOutputCap = this.outputCap;
        IItemHandler inputHandler = this.inventory.getHandler(StorageGroup.INPUT);
        IItemHandler outputHandler = this.inventory.getHandler(StorageGroup.OUTPUT);
        this.inputCap = LazyOptional.of(() -> inputHandler);
        this.outputCap = LazyOptional.of(() -> outputHandler);
        prevInputCap.invalidate();
        prevOutputCap.invalidate();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandlerCapability(side);
        }
        return super.getCapability(cap, side);
    }

    protected <T> LazyOptional<T> getItemHandlerCapability(@Nullable Direction side) {
        if (side == this.m_58900_().m_61143_((Property)BlockStatePropertiesCoFH.FACING_ALL)) {
            return this.outputCap.cast();
        }
        return this.inputCap.cast();
    }
}

