/*
 * Decompiled with CFR 0.152.
 */
package cofh.requack.net.okhttp;

import cofh.requack.annotation.Requires;
import cofh.requack.util.MultiHasher;
import java.io.IOException;
import okio.Buffer;
import okio.ForwardingSource;
import okio.Source;

@Requires.RequiresList(value={@Requires(value="com.google.guava:guava"), @Requires(value="com.squareup.okhttp3:okhttp")})
public class HasherWrappedSource
extends ForwardingSource {
    private final MultiHasher hasher;

    public HasherWrappedSource(Source delegate, MultiHasher hasher) {
        super(delegate);
        this.hasher = hasher;
    }

    public long read(Buffer sink, long byteCount) throws IOException {
        long bytesRead = super.read(sink, byteCount);
        if (bytesRead != 1L) {
            this.hasher.update(sink.peek().readByteArray());
        }
        return bytesRead;
    }
}

