/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.util.commands;

import com.google.common.collect.Multimap;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.LongArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import flaxbeard.immersivepetroleum.api.reservoir.AxisAlignedIslandBB;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirType;
import flaxbeard.immersivepetroleum.common.ReservoirRegionDataStorage;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.commands.CommandUtils;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraftforge.fluids.FluidStack;

public class IslandCommand {
    private IslandCommand() {
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        LiteralArgumentBuilder main = (LiteralArgumentBuilder)Commands.m_82127_((String)"reservoir").requires(source -> source.m_6761_(4));
        main.then(Commands.m_82127_((String)"locate").executes(IslandCommand::locate));
        main.then(IslandCommand.setters());
        main.then((ArgumentBuilder)IslandCommand.positional(Commands.m_82127_((String)"get"), IslandCommand::get));
        return main;
    }

    private static int get(CommandContext<CommandSourceStack> context, @Nonnull ReservoirIsland island) {
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.get", island.getAmount(), Utils.fDecimal((double)island.getAmount() / (double)island.getCapacity() * 100.0), new FluidStack(island.getFluid(), 1).getDisplayName());
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int locate(CommandContext<CommandSourceStack> command) {
        int x;
        int z;
        AxisAlignedIslandBB IAABB;
        CommandSourceStack source = (CommandSourceStack)command.getSource();
        BlockPos srcPos = source.m_81373_().m_142538_();
        double dx = (double)srcPos.m_123341_() + 0.5;
        double dz = (double)srcPos.m_123343_() + 0.5;
        int range = 128;
        int rangeSqr = range * range;
        HashSet nearby = new HashSet();
        ReservoirRegionDataStorage storage = ReservoirRegionDataStorage.get();
        ReservoirRegionDataStorage.RegionData[] regions = new ReservoirRegionDataStorage.RegionData[]{storage.getRegionData(storage.toRegionCoords(srcPos.m_142082_(256, 0, -256))), storage.getRegionData(storage.toRegionCoords(srcPos.m_142082_(256, 0, 256))), storage.getRegionData(storage.toRegionCoords(srcPos.m_142082_(-256, 0, -256))), storage.getRegionData(storage.toRegionCoords(srcPos.m_142082_(-256, 0, 256)))};
        ResourceKey dimKey = source.m_81372_().m_46472_();
        for (int i = 0; i < regions.length; ++i) {
            Multimap<ResourceKey<Level>, ReservoirIsland> islands;
            ReservoirRegionDataStorage.RegionData rd = regions[i];
            if (rd == null) continue;
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = islands = rd.getReservoirIslandList();
            synchronized (multimap) {
                islands.get((Object)dimKey).forEach(island -> {
                    if (island.getBoundingBox().getCenter().m_203198_(dx, 0.0, dz) <= (double)rangeSqr) {
                        nearby.add(island);
                    }
                });
                continue;
            }
        }
        if (nearby.isEmpty()) {
            CommandUtils.sendTranslated(source, "chat.immersivepetroleum.command.reservoir.notfound", new Object[0]);
            return 1;
        }
        ReservoirIsland closestIsland = null;
        double smallestDistance = rangeSqr;
        ColumnPos p = null;
        for (ReservoirIsland island2 : nearby) {
            IAABB = island2.getBoundingBox();
            for (z = IAABB.minZ() + 1; z < IAABB.maxZ(); ++z) {
                for (x = IAABB.minX() + 1; x < IAABB.maxX(); ++x) {
                    double za;
                    double xa;
                    double dst;
                    if (!island2.contains(x, z) || !((dst = (xa = (double)x + 0.5 - dx) * xa + (za = (double)z + 0.5 - dz) * za) < smallestDistance)) continue;
                    p = new ColumnPos(x, z);
                    smallestDistance = dst;
                    closestIsland = island2;
                }
            }
        }
        if (closestIsland == null) {
            CommandUtils.sendStringError(source, "List should not be empty. Please report this bug. (Immersive Petroleum)");
            return 1;
        }
        double hPressure = 0.0;
        IAABB = closestIsland.getBoundingBox();
        for (z = IAABB.minZ() + 1; z < IAABB.maxZ(); ++z) {
            for (x = IAABB.minX() + 1; x < IAABB.maxX(); ++x) {
                double d;
                if (!closestIsland.contains(x, z)) continue;
                double cPressure = ReservoirHandler.getValueOf((Level)source.m_81372_(), x, z);
                if (!(d > hPressure)) continue;
                hPressure = cPressure;
                p = new ColumnPos(x, z);
            }
        }
        ClickEvent clickEvent = new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, "/tp @s " + p.f_140723_ + " ~ " + p.f_140724_);
        HoverEvent hoverEvent = new HoverEvent(HoverEvent.Action.f_130831_, (Object)new TranslatableComponent("chat.coordinates.tooltip"));
        source.m_81354_((Component)new TranslatableComponent("chat.immersivepetroleum.command.reservoir.locate", new Object[]{closestIsland.getType().name, ComponentUtils.m_130748_((Component)new TextComponent(p.f_140723_ + " " + p.f_140724_)).m_130938_(s -> s.m_131140_(ChatFormatting.GREEN).m_131155_(Boolean.valueOf(true)).m_131142_(clickEvent).m_131144_(hoverEvent))}), true);
        return 1;
    }

    private static LiteralArgumentBuilder<CommandSourceStack> setters() {
        LiteralArgumentBuilder set = (LiteralArgumentBuilder)Commands.m_82127_((String)"set").requires(source -> source.m_6761_(4));
        set.then(Commands.m_82127_((String)"amount").then((ArgumentBuilder)IslandCommand.positional(Commands.m_82129_((String)"amount", (ArgumentType)LongArgumentType.longArg((long)0L, (long)0xFFFFFFFFL)), IslandCommand::setReservoirAmount)));
        set.then(Commands.m_82127_((String)"capacity").then((ArgumentBuilder)IslandCommand.positional(Commands.m_82129_((String)"capacity", (ArgumentType)LongArgumentType.longArg((long)0L, (long)0xFFFFFFFFL)), IslandCommand::setReservoirCapacity)));
        set.then(Commands.m_82127_((String)"type").then((ArgumentBuilder)IslandCommand.positional(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.string()).suggests(IslandCommand::typeSuggestor), IslandCommand::setReservoirType)));
        return set;
    }

    private static CompletableFuture<Suggestions> typeSuggestor(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82981_(ReservoirType.map.values().stream().map(type -> type.name), (SuggestionsBuilder)builder);
    }

    private static int setReservoirAmount(CommandContext<CommandSourceStack> context, @Nonnull ReservoirIsland island) {
        long amount = (Long)context.getArgument("amount", Long.class);
        island.setAmount(amount);
        island.setDirty();
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.amount.success", island.getAmount());
        return 1;
    }

    private static int setReservoirCapacity(CommandContext<CommandSourceStack> context, @Nonnull ReservoirIsland island) {
        long capacity = (Long)context.getArgument("capacity", Long.class);
        island.setAmountAndCapacity(capacity, capacity);
        island.setDirty();
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.capacity.success", island.getCapacity());
        return 1;
    }

    private static int setReservoirType(CommandContext<CommandSourceStack> context, @Nonnull ReservoirIsland island) {
        String name = (String)context.getArgument("name", String.class);
        ReservoirType reservoir = null;
        for (ReservoirType res : ReservoirType.map.values()) {
            if (!res.name.equalsIgnoreCase(name)) continue;
            reservoir = res;
        }
        if (reservoir == null) {
            CommandUtils.sendTranslatedError((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.type.fail", name);
            return 1;
        }
        island.setReservoirType(reservoir);
        island.setDirty();
        CommandUtils.sendTranslated((CommandSourceStack)context.getSource(), "chat.immersivepetroleum.command.reservoir.set.type.success", reservoir.name);
        return 1;
    }

    static <T extends ArgumentBuilder<CommandSourceStack, T>> T positional(T builder, BiFunction<CommandContext<CommandSourceStack>, ReservoirIsland, Integer> function) {
        builder.executes(command -> {
            ColumnPos pos = new ColumnPos(new BlockPos(((CommandSourceStack)command.getSource()).m_81371_()));
            ReservoirIsland island = ReservoirHandler.getIsland((Level)((CommandSourceStack)command.getSource()).m_81372_(), pos);
            if (island == null) {
                CommandUtils.sendTranslated((CommandSourceStack)command.getSource(), "chat.immersivepetroleum.command.reservoir.notfound", new Object[0]);
                return 1;
            }
            return (Integer)function.apply(command, island);
        }).then(Commands.m_82129_((String)"location", (ArgumentType)ColumnPosArgument.m_118989_()).executes(command -> {
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)command, (String)"location");
            ReservoirIsland island = ReservoirHandler.getIsland((Level)((CommandSourceStack)command.getSource()).m_81372_(), pos);
            if (island == null) {
                CommandUtils.sendTranslated((CommandSourceStack)command.getSource(), "chat.immersivepetroleum.command.reservoir.notfound", new Object[0]);
                return 1;
            }
            return (Integer)function.apply(command, island);
        }));
        return builder;
    }
}

