/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.entity;

import flaxbeard.immersivepetroleum.common.IPContent;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class MolotovItemEntity
extends ThrowableItemProjectile {
    public static final EntityType<MolotovItemEntity> TYPE = MolotovItemEntity.createType();

    private static EntityType<MolotovItemEntity> createType() {
        EntityType ret = EntityType.Builder.m_20704_(MolotovItemEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.25f, 0.25f).m_20702_(4).m_20717_(10).m_20712_("immersivepetroleummolotov");
        ret.setRegistryName("immersivepetroleum", "molotov");
        return ret;
    }

    public MolotovItemEntity(Level world, LivingEntity living) {
        this(TYPE, world, living);
    }

    public MolotovItemEntity(Level world, LivingEntity living, double x, double y, double z) {
        this(TYPE, world, living);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    private MolotovItemEntity(EntityType<MolotovItemEntity> type, Level world) {
        super(type, world);
        this.f_19850_ = true;
    }

    private MolotovItemEntity(EntityType<MolotovItemEntity> type, Level world, LivingEntity living) {
        super(type, living, world);
        this.f_19850_ = true;
    }

    protected Item m_7881_() {
        return (Item)IPContent.Items.MOLOTOV_LIT.get();
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            double m = 0.125;
            double x = this.m_20185_() + (m - m * 2.0 * this.f_19796_.nextDouble());
            double y = this.m_20186_() + (m - m * 2.0 * this.f_19796_.nextDouble());
            double z = this.m_20189_() + (m - m * 2.0 * this.f_19796_.nextDouble());
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, x, y, z, 0.0, 0.0, 0.0);
        }
    }

    protected void m_6532_(HitResult pResult) {
        super.m_6532_(pResult);
        if (!this.f_19853_.f_46443_) {
            this.f_19853_.m_7605_((Entity)this, (byte)3);
            this.m_146870_();
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        super.m_5790_(pResult);
        if (!this.f_19853_.f_46443_) {
            this.fire(new BlockPos(pResult.m_82450_()));
        }
    }

    protected void m_8060_(BlockHitResult hitResult) {
        super.m_8060_(hitResult);
        if (!this.f_19853_.f_46443_) {
            this.fire(hitResult.m_82425_().m_142300_(hitResult.m_82434_()));
        }
    }

    private void fire(BlockPos pos) {
        if (this.f_19853_.m_8055_(pos).m_60767_().m_76332_()) {
            this.f_19853_.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.BLOCKS, 1.0f, this.f_19853_.m_5822_().nextFloat() * 0.4f + 0.8f);
            return;
        }
        this.f_19853_.m_5594_(null, pos, SoundEvents.f_11983_, SoundSource.BLOCKS, 0.3f, 0.7f);
        HashSet<BlockPos> hits = new HashSet<BlockPos>();
        this.scanArea(pos, pos, hits, 9);
        if (hits.isEmpty()) {
            return;
        }
        hits.forEach(this::placeFire);
        this.f_19853_.m_5594_(null, pos, SoundEvents.f_11769_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        AABB bounds = AABB.m_165882_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (double)6.5, (double)6.5, (double)6.5);
        List list = this.f_19853_.m_45976_(LivingEntity.class, bounds);
        if (list.isEmpty()) {
            return;
        }
        Entity entity = this.m_37282_();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            DamageSource src = DamageSource.m_19344_((Player)player);
            list.forEach(e -> e.m_6469_(src, 1.0f));
        }
        if ((entity = this.m_37282_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_21335_((Entity)list.get(list.size() - 1));
        }
    }

    private void scanArea(BlockPos start, BlockPos pos, Set<BlockPos> visited, int radiusSqr) {
        BlockPos dif = pos.m_141950_((Vec3i)start);
        int sqr = dif.m_123341_() * dif.m_123341_() + dif.m_123342_() * dif.m_123342_() + dif.m_123343_() * dif.m_123343_();
        if (sqr > radiusSqr) {
            return;
        }
        if (pos != start && !this.f_19853_.m_8055_(pos).m_60795_()) {
            return;
        }
        if (visited.contains(pos)) {
            return;
        }
        visited.add(pos);
        this.scanArea(start, pos.m_7494_(), visited, radiusSqr);
        this.scanArea(start, pos.m_7495_(), visited, radiusSqr);
        this.scanArea(start, pos.m_142127_(), visited, radiusSqr);
        this.scanArea(start, pos.m_142126_(), visited, radiusSqr);
        this.scanArea(start, pos.m_142128_(), visited, radiusSqr);
        this.scanArea(start, pos.m_142125_(), visited, radiusSqr);
    }

    private void placeFire(BlockPos pos) {
        if (!this.f_19853_.m_8055_(pos).m_60795_()) {
            return;
        }
        BlockState fire = Blocks.f_50083_.m_49966_();
        boolean up = false;
        boolean north = false;
        boolean east = false;
        boolean south = false;
        boolean west = false;
        if (this.f_19853_.m_8055_(pos.m_7495_()).m_60795_()) {
            BlockPos abovePos = pos.m_7494_();
            BlockPos northPos = pos.m_142127_();
            BlockPos eastPos = pos.m_142126_();
            BlockPos southPos = pos.m_142128_();
            BlockPos westPos = pos.m_142125_();
            up = this.f_19853_.m_8055_(abovePos).isFlammable((BlockGetter)this.f_19853_, abovePos, Direction.DOWN);
            north = this.f_19853_.m_8055_(northPos).isFlammable((BlockGetter)this.f_19853_, northPos, Direction.SOUTH);
            east = this.f_19853_.m_8055_(eastPos).isFlammable((BlockGetter)this.f_19853_, eastPos, Direction.WEST);
            south = this.f_19853_.m_8055_(southPos).isFlammable((BlockGetter)this.f_19853_, southPos, Direction.NORTH);
            west = this.f_19853_.m_8055_(westPos).isFlammable((BlockGetter)this.f_19853_, westPos, Direction.EAST);
            fire = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)fire.m_61124_((Property)FireBlock.f_53413_, (Comparable)Boolean.valueOf(up))).m_61124_((Property)FireBlock.f_53409_, (Comparable)Boolean.valueOf(north))).m_61124_((Property)FireBlock.f_53410_, (Comparable)Boolean.valueOf(east))).m_61124_((Property)FireBlock.f_53411_, (Comparable)Boolean.valueOf(south))).m_61124_((Property)FireBlock.f_53412_, (Comparable)Boolean.valueOf(west));
        }
        this.f_19853_.m_7731_(pos, fire, 3);
    }
}

