/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import flaxbeard.immersivepetroleum.api.reservoir.ReservoirHandler;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import flaxbeard.immersivepetroleum.client.ClientProxy;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.stone.WellPipeBlock;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.PumpjackTileEntity;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.WellPipeTileEntity;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class WellTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile {
    static final int PIPE_WORTH = 6;
    static final int DEFAULT_PIPELENGTH = 384;
    @Nonnull
    public List<ColumnPos> tappedIslands = new ArrayList<ColumnPos>();
    public final List<Integer> phyiscalPipesList = new ArrayList<Integer>();
    public int pipes = 0;
    public int wellPipeLength = 0;
    public int additionalPipes = 0;
    public boolean drillingCompleted;
    public boolean pastPhysicalPart;
    private boolean selfDestruct;
    private int selfDestructTimer;
    private Fluid spillFType = Fluids.f_76191_;
    private int spillHeight = -1;
    boolean spill = false;
    int clientFlow = 0;

    public WellTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.WELL.get(), pWorldPosition, pBlockState);
    }

    @Override
    protected void writeCustom(CompoundTag nbt) {
        ListTag list;
        nbt.m_128379_("spill", this.spill);
        nbt.m_128405_("flow", ReservoirHandler.getIsland(this.getWorldNonnull(), this.m_58899_()) == null ? 0 : ReservoirIsland.getFlow(ReservoirHandler.getIsland(this.getWorldNonnull(), this.m_58899_()).getPressure(this.getWorldNonnull(), this.m_58899_().m_123341_(), this.m_58899_().m_123343_())));
        nbt.m_128379_("drillingcompleted", this.drillingCompleted);
        nbt.m_128379_("pastphyiscalpart", this.pastPhysicalPart);
        nbt.m_128405_("pipes", this.pipes);
        nbt.m_128405_("wellpipelength", this.wellPipeLength);
        nbt.m_128405_("additionalpipes", this.additionalPipes);
        nbt.m_128379_("selfdestruct", this.selfDestruct);
        nbt.m_128405_("selfdestructtimer", this.selfDestructTimer);
        nbt.m_128359_("spillftype", this.spillFType.getRegistryName().toString());
        nbt.m_128405_("spillheight", this.spillHeight);
        if (!this.tappedIslands.isEmpty()) {
            list = new ListTag();
            this.tappedIslands.forEach(c -> {
                CompoundTag pos = new CompoundTag();
                pos.m_128405_("x", c.f_140723_);
                pos.m_128405_("z", c.f_140724_);
                list.add((Object)pos);
            });
            nbt.m_128365_("tappedislands", (Tag)list);
        }
        if (!this.phyiscalPipesList.isEmpty()) {
            list = new ListTag();
            this.phyiscalPipesList.forEach(i -> list.add((Object)IntTag.m_128679_((int)i)));
            nbt.m_128365_("pipeLoc", (Tag)list);
        }
    }

    @Override
    protected void readCustom(CompoundTag nbt) {
        ListTag list;
        this.spill = nbt.m_128471_("spill");
        this.clientFlow = nbt.m_128451_("flow");
        this.drillingCompleted = nbt.m_128471_("drillingcompleted");
        this.pastPhysicalPart = nbt.m_128471_("pastphyiscalpart");
        this.pipes = nbt.m_128451_("pipes");
        this.wellPipeLength = nbt.m_128451_("wellpipelength");
        this.additionalPipes = nbt.m_128451_("additionalpipes");
        this.selfDestruct = nbt.m_128471_("selfdestruct");
        this.selfDestructTimer = nbt.m_128451_("selfdestructtimer");
        try {
            this.spillFType = (Fluid)ForgeRegistries.FLUIDS.getValue(new ResourceLocation(nbt.m_128461_("spillftype")));
        }
        catch (ResourceLocationException rle) {
            this.spillFType = Fluids.f_76191_;
        }
        this.spillHeight = nbt.m_128451_("spillheight");
        if (nbt.m_128425_("tappedislands", 9)) {
            list = nbt.m_128437_("tappedislands", 10);
            ArrayList<ColumnPos> tmp = new ArrayList<ColumnPos>(list.size());
            list.forEach(n -> {
                CompoundTag pos = (CompoundTag)n;
                int x = pos.m_128451_("x");
                int z = pos.m_128451_("z");
                tmp.add(new ColumnPos(x, z));
            });
            this.tappedIslands = tmp;
        }
        if (nbt.m_128425_("pipeLoc", 9)) {
            list = nbt.m_128437_("pipeLoc", 3);
            ArrayList ints = new ArrayList(list.size());
            list.forEach(n -> ints.add(((IntTag)n).m_7047_()));
            this.phyiscalPipesList.clear();
            this.phyiscalPipesList.addAll(ints);
        }
    }

    @Override
    public void tickClient() {
        if (this.spill && this.spillFType != Fluids.f_76191_) {
            BlockPos pPos = this.spillHeight > -1 ? new BlockPos(this.f_58858_.m_123341_(), this.spillHeight, this.f_58858_.m_123343_()) : this.f_58858_.m_7494_();
            ClientProxy.spawnSpillParticles(this.f_58857_, pPos, this.spillFType, 10, -0.25f, this.clientFlow);
        }
    }

    @Override
    public void tickServer() {
        if (this.drillingCompleted) {
            if (this.tappedIslands.size() > 0) {
                ReservoirIsland island;
                for (ColumnPos cPos : this.tappedIslands) {
                    island = ReservoirHandler.getIsland(this.getWorldNonnull(), cPos);
                    if (island == null || !island.belowHydrostaticEquilibrium(this.getWorldNonnull())) continue;
                    island.equalizeHydrostaticPressure(this.getWorldNonnull());
                }
                if (this.getWorldNonnull().m_46467_() % 5L == 0L) {
                    boolean spill = false;
                    int height = -1;
                    Fluid fType = Fluids.f_76191_;
                    BlockEntity teHigh = this.getWorldNonnull().m_7702_(this.m_58899_().m_7494_());
                    if (teHigh instanceof WellPipeTileEntity) {
                        WellPipeTileEntity well = (WellPipeTileEntity)teHigh;
                        Pair<Boolean, BlockPos> result = well.hasValidConnection();
                        if (!((Boolean)result.getLeft()).booleanValue() || this.getWorldNonnull().m_7702_((BlockPos)result.getRight()) instanceof PumpjackTileEntity) {
                            for (ColumnPos cPos : this.tappedIslands) {
                                ReservoirIsland island2 = ReservoirHandler.getIsland(this.getWorldNonnull(), cPos);
                                if (island2 == null || !((double)island2.getPressure(this.getWorldNonnull(), cPos.f_140723_, cPos.f_140724_) > 0.0)) continue;
                                fType = island2.getFluid();
                                height = ((BlockPos)result.getRight()).m_123342_();
                                spill = true;
                                break;
                            }
                        }
                    } else {
                        ColumnPos cPos = this.tappedIslands.get(0);
                        ReservoirIsland island3 = ReservoirHandler.getIsland(this.getWorldNonnull(), cPos);
                        if (island3 != null && (double)island3.getPressure(this.getWorldNonnull(), cPos.f_140723_, cPos.f_140724_) > 0.0) {
                            spill = true;
                            fType = island3.getFluid();
                            height = this.f_58858_.m_123342_() + 1;
                        }
                    }
                    if (spill != this.spill) {
                        this.spill = spill;
                        if (this.spill) {
                            this.spillHeight = height;
                            this.spillFType = fType;
                        } else {
                            this.spillHeight = -1;
                            this.spillFType = Fluids.f_76191_;
                        }
                        this.m_6596_();
                    }
                }
                if (this.spill) {
                    for (ColumnPos cPos : this.tappedIslands) {
                        island = ReservoirHandler.getIsland(this.getWorldNonnull(), cPos);
                        if (island == null) continue;
                        island.extractWithPressure(this.getWorldNonnull(), cPos.f_140723_, cPos.f_140724_);
                    }
                }
            }
        } else if (this.selfDestruct && this.advanceTimer()) {
            if (!this.phyiscalPipesList.isEmpty()) {
                for (Integer integer : this.phyiscalPipesList) {
                    BlockPos pos = this.m_58899_();
                    pos = new BlockPos(pos.m_123341_(), integer.intValue(), pos.m_123343_());
                    BlockState state = this.getWorldNonnull().m_8055_(pos);
                    if (!(state.m_60734_() instanceof WellPipeBlock)) continue;
                    this.getWorldNonnull().m_46597_(pos, (BlockState)state.m_61124_((Property)WellPipeBlock.BROKEN, (Comparable)Boolean.valueOf(true)));
                }
            }
            this.getWorldNonnull().m_46597_(this.m_58899_(), Blocks.f_50752_.m_49966_());
        }
    }

    public void usePipe() {
        if (this.drillingCompleted) {
            return;
        }
        --this.pipes;
        ++this.wellPipeLength;
        if (this.wellPipeLength >= this.getMaxPipeLength()) {
            this.drillingCompleted = true;
        }
        this.m_6596_();
    }

    public int getMaxPipeLength() {
        return 384 + this.additionalPipes;
    }

    public void startSelfDestructSequence() {
        if (this.drillingCompleted) {
            return;
        }
        this.selfDestruct = true;
        this.selfDestructTimer = 100;
    }

    public void abortSelfDestructSequence() {
        if (this.selfDestruct) {
            this.selfDestruct = false;
        }
    }

    public boolean advanceTimer() {
        return this.selfDestruct && this.selfDestructTimer-- <= 0;
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }
}

