/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common.blocks.tileentities;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import flaxbeard.immersivepetroleum.api.crafting.FlarestackHandler;
import flaxbeard.immersivepetroleum.client.particle.IPParticleTypes;
import flaxbeard.immersivepetroleum.common.IPTileTypes;
import flaxbeard.immersivepetroleum.common.blocks.ticking.IPCommonTickableTile;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.IPTileEntityBase;
import flaxbeard.immersivepetroleum.common.util.Utils;
import flaxbeard.immersivepetroleum.common.util.sounds.IPSounds;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.goat.Goat;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;

public class FlarestackTileEntity
extends IPTileEntityBase
implements IPCommonTickableTile,
IEBlockInterfaces.ISoundBE {
    static final DamageSource FLARESTACK = new DamageSource("ipFlarestack").m_19380_().m_19383_();
    protected boolean isRedstoneInverted;
    protected boolean isActive;
    protected short drained;
    protected final FluidTank tank = new FluidTank(250, fstack -> fstack != FluidStack.EMPTY && FlarestackHandler.isBurnable(fstack));
    private LazyOptional<IFluidHandler> inputHandler;

    public FlarestackTileEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super((BlockEntityType)IPTileTypes.FLARE.get(), pWorldPosition, pBlockState);
    }

    public void invertRedstone() {
        this.isRedstoneInverted = !this.isRedstoneInverted;
        this.m_6596_();
    }

    public boolean isRedstoneInverted() {
        return this.isRedstoneInverted;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public short getFlow() {
        return this.drained;
    }

    @Override
    public void readCustom(CompoundTag nbt) {
        this.isRedstoneInverted = nbt.m_128471_("inverted");
        this.isActive = nbt.m_128471_("active");
        this.drained = nbt.m_128448_("drained");
        this.tank.readFromNBT(nbt.m_128469_("tank"));
    }

    @Override
    public void writeCustom(CompoundTag nbt) {
        nbt.m_128379_("inverted", this.isRedstoneInverted);
        nbt.m_128379_("active", this.isActive);
        nbt.m_128376_("drained", this.drained);
        CompoundTag tank = this.tank.writeToNBT(new CompoundTag());
        nbt.m_128365_("tank", (Tag)tank);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY && (side == null || side == Direction.DOWN)) {
            BlockEntity te = this.f_58857_.m_7702_(this.m_58899_());
            if (te instanceof FlarestackTileEntity) {
                FlarestackTileEntity flare = (FlarestackTileEntity)te;
                if (this.inputHandler == null) {
                    this.inputHandler = LazyOptional.of(() -> flare.tank);
                }
            } else {
                return LazyOptional.empty();
            }
            return this.inputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        if (this.inputHandler != null) {
            this.inputHandler.invalidate();
        }
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.inputHandler != null) {
            this.inputHandler.invalidate();
        }
    }

    public void m_6596_() {
        super.m_6596_();
        BlockState state = this.f_58857_.m_8055_(this.f_58858_);
        this.f_58857_.m_7260_(this.f_58858_, state, state, 3);
        this.f_58857_.m_46672_(this.f_58858_, state.m_60734_());
    }

    @OnlyIn(value=Dist.CLIENT)
    public AABB getRenderBoundingBox() {
        BlockPos pos = this.m_58899_();
        return new AABB(pos.m_142082_(-1, -1, -1), pos.m_142082_(1, 2, 1));
    }

    @Override
    public void tickClient() {
        ImmersiveEngineering.proxy.handleTileSound(IPSounds.FLARESTACK, (BlockEntity)this, this.isActive, 1.0f, 0.75f);
        if (this.isActive) {
            if (this.f_58857_.m_46467_() % 2L == 0L) {
                float xPos = (float)this.f_58858_.m_123341_() + 0.5f + (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 0.4375f;
                float zPos = (float)this.f_58858_.m_123343_() + 0.5f + (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 0.4375f;
                float yPos = (float)this.f_58858_.m_123342_() + 1.875f + 0.2f * this.f_58857_.f_46441_.nextFloat();
                this.f_58857_.m_7106_((ParticleOptions)IPParticleTypes.FLARE_FIRE, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)(0.0625f + (float)this.drained / (float)this.tank.getCapacity() * 0.125f), 0.0);
            }
        } else if (this.f_58857_.m_46467_() % 5L == 0L) {
            float xPos = (float)this.f_58858_.m_123341_() + 0.5f + (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 0.4375f;
            float zPos = (float)this.f_58858_.m_123343_() + 0.5f + (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 0.4375f;
            float yPos = (float)this.f_58858_.m_123342_() + 1.6f;
            float xa = (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 0.00625f;
            float ya = (this.f_58857_.f_46441_.nextFloat() - 0.5f) * 0.00625f;
            this.f_58857_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, (double)xPos, (double)yPos, (double)zPos, (double)xa, (double)0.025f, (double)ya);
        }
    }

    @Override
    public void tickServer() {
        List list;
        boolean lastActive = this.isActive;
        this.isActive = false;
        int redstone = this.f_58857_.m_46755_(this.f_58858_);
        if (this.isRedstoneInverted()) {
            redstone = 15 - redstone;
        }
        if (redstone > 0 && this.tank.getFluidAmount() > 0) {
            float signal = (float)redstone / 15.0f;
            FluidStack fs = this.tank.drain((int)((float)this.tank.getCapacity() * signal), IFluidHandler.FluidAction.SIMULATE);
            if (fs.getAmount() > 0) {
                this.tank.drain(fs.getAmount(), IFluidHandler.FluidAction.EXECUTE);
                this.drained = (short)fs.getAmount();
                this.isActive = true;
            }
        }
        if (this.isActive && this.f_58857_.m_46467_() % 10L == 0L && !(list = this.m_58904_().m_45976_(Entity.class, new AABB(this.f_58858_).m_82400_(1.0))).isEmpty()) {
            list.forEach(e -> {
                if (!e.m_5825_()) {
                    e.m_20254_(15);
                    e.m_6469_(FLARESTACK, 6.0f * ((float)this.drained / (float)this.tank.getCapacity()));
                }
            });
            List<Entity> goats = list.stream().filter(e -> e instanceof Goat).toList();
            if (!goats.isEmpty()) {
                List players = this.m_58904_().m_45976_(Player.class, new AABB(this.f_58858_).m_82400_(8.0));
                for (Entity g : goats) {
                    if (g.m_6084_()) continue;
                    players.forEach(p -> Utils.unlockIPAdvancement(p, "main/flarestack"));
                    break;
                }
            }
        }
        if (lastActive != this.isActive || !this.f_58857_.f_46443_ && this.isActive) {
            this.m_6596_();
        }
    }

    public boolean shouldPlaySound(@Nonnull String sound) {
        return true;
    }
}

