/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.common;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import flaxbeard.immersivepetroleum.api.reservoir.ReservoirIsland;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ReservoirRegionDataStorage
extends SavedData {
    private static final Logger log = LogManager.getLogger((String)"immersivepetroleum/RegionDataStorage");
    private static final String DATA_NAME = "ImmersivePetroleum-ReservoirRegions";
    private static ReservoirRegionDataStorage active_instance;
    final Map<ColumnPos, RegionData> regions = new HashMap<ColumnPos, RegionData>();
    final DimensionDataStorage dimData;

    public static ReservoirRegionDataStorage get() {
        return active_instance;
    }

    public static final void init(DimensionDataStorage dimData) {
        active_instance = (ReservoirRegionDataStorage)dimData.m_164861_(t -> new ReservoirRegionDataStorage(dimData, (CompoundTag)t), () -> {
            log.debug("Creating new ReservoirRegionDataStorage instance.");
            return new ReservoirRegionDataStorage(dimData);
        }, DATA_NAME);
    }

    public ReservoirRegionDataStorage(DimensionDataStorage dimData) {
        this.dimData = dimData;
    }

    public ReservoirRegionDataStorage(DimensionDataStorage dimData, CompoundTag nbt) {
        this.dimData = dimData;
        this.load(nbt);
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        ListTag list = new ListTag();
        this.regions.forEach((key, entry) -> {
            CompoundTag tag = new CompoundTag();
            tag.m_128405_("x", key.f_140723_);
            tag.m_128405_("z", key.f_140724_);
            list.add((Object)tag);
        });
        nbt.m_128365_("regions", (Tag)list);
        log.debug("Saved regions file.");
        return nbt;
    }

    private void load(CompoundTag nbt) {
        ListTag regions = nbt.m_128437_("regions", 10);
        for (int i = 0; i < regions.size(); ++i) {
            CompoundTag tag = regions.m_128728_(i);
            int x = tag.m_128451_("x");
            int z = tag.m_128451_("z");
            ColumnPos rPos = new ColumnPos(x, z);
            RegionData rData = this.getOrCreateRegionData(rPos);
            this.regions.put(rPos, rData);
        }
        log.debug("Loaded regions file.");
    }

    public void markAllDirty() {
        this.m_77762_();
        this.regions.values().forEach(SavedData::m_77762_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addIsland(ResourceKey<Level> dimensionKey, ReservoirIsland island) {
        ColumnPos regionPos = this.toRegionCoords(island.getBoundingBox().getCenter());
        RegionData regionData = this.getOrCreateRegionData(regionPos);
        Multimap<ResourceKey<Level>, ReservoirIsland> multimap = regionData.reservoirlist;
        synchronized (multimap) {
            if (!regionData.reservoirlist.containsEntry(dimensionKey, (Object)island)) {
                regionData.reservoirlist.put(dimensionKey, (Object)island);
                island.setRegion(regionData);
                regionData.m_77762_();
            }
        }
    }

    @Nullable
    public ReservoirIsland getIsland(Level world, BlockPos pos) {
        return this.getIsland(world, new ColumnPos(pos));
    }

    @Nullable
    public ReservoirIsland getIsland(Level world, ColumnPos pos) {
        if (world.f_46443_) {
            return null;
        }
        ResourceKey dimKey = world.m_46472_();
        ReservoirIsland ret = null;
        ret = this.getIsland((ResourceKey<Level>)dimKey, pos, 256, -256);
        if (ret == null && (ret = this.getIsland((ResourceKey<Level>)dimKey, pos, 256, 256)) == null && (ret = this.getIsland((ResourceKey<Level>)dimKey, pos, -256, -256)) == null) {
            ret = this.getIsland((ResourceKey<Level>)dimKey, pos, -256, 256);
        }
        return ret;
    }

    private ReservoirIsland getIsland(ResourceKey<Level> dimKey, ColumnPos pos, int xOff, int zOff) {
        RegionData regionData = this.getRegionData(this.toRegionCoords(this.offset(pos, xOff, zOff)));
        return regionData != null ? regionData.get(dimKey, pos) : null;
    }

    private RegionData getRegionData(ColumnPos pos, int xOff, int zOff) {
        return this.getRegionData(this.toRegionCoords(this.offset(pos, xOff, zOff)));
    }

    public boolean existsAt(ColumnPos pos) {
        RegionData topL = this.getRegionData(pos, 256, -256);
        RegionData topR = this.getRegionData(pos, 256, 256);
        RegionData bottomL = this.getRegionData(pos, -256, -256);
        RegionData bottomR = this.getRegionData(pos, -256, 256);
        boolean ret = false;
        ret = this.existsAt(topL, pos);
        if (!(ret || (ret = this.existsAt(topR, pos)) || (ret = this.existsAt(bottomL, pos)))) {
            ret = this.existsAt(bottomR, pos);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean existsAt(RegionData regionData, ColumnPos pos) {
        if (regionData != null) {
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = regionData.reservoirlist;
            synchronized (multimap) {
                return regionData.reservoirlist.values().stream().anyMatch(island -> island.contains(pos));
            }
        }
        return false;
    }

    private ColumnPos offset(ColumnPos in, int xOff, int zOff) {
        return new ColumnPos(in.f_140723_ + xOff, in.f_140724_ + zOff);
    }

    public ColumnPos toRegionCoords(BlockPos pos) {
        return new ColumnPos(pos.m_123341_() >> 9, pos.m_123343_() >> 9);
    }

    public ColumnPos toRegionCoords(ColumnPos pos) {
        return new ColumnPos(pos.f_140723_ >> 9, pos.f_140724_ >> 9);
    }

    @Nullable
    public RegionData getRegionData(BlockPos pos) {
        return this.getRegionData(this.toRegionCoords(pos));
    }

    @Nullable
    public RegionData getRegionData(ColumnPos regionPos) {
        RegionData ret = this.regions.getOrDefault(regionPos, null);
        return ret;
    }

    private RegionData getOrCreateRegionData(ColumnPos regionPos) {
        RegionData ret = this.regions.computeIfAbsent(regionPos, p -> {
            String fn = this.getRegionFileName((ColumnPos)p);
            RegionData data = (RegionData)this.dimData.m_164861_(t -> new RegionData((ColumnPos)p, (CompoundTag)t), () -> new RegionData((ColumnPos)p), fn);
            this.m_77762_();
            log.debug("Created RegionData[{}, {}]", (Object)regionPos.f_140723_, (Object)regionPos.f_140724_);
            return data;
        });
        return ret;
    }

    private String getRegionFileName(ColumnPos regionPos) {
        return DATA_NAME + File.separatorChar + regionPos.f_140723_ + "_" + regionPos.f_140724_;
    }

    public static class RegionData
    extends SavedData {
        final ColumnPos regionPos;
        final Multimap<ResourceKey<Level>, ReservoirIsland> reservoirlist = ArrayListMultimap.create();

        RegionData(ColumnPos regionPos) {
            this.regionPos = regionPos;
        }

        RegionData(ColumnPos regionPos, CompoundTag nbt) {
            this.regionPos = regionPos;
            this.load(nbt);
        }

        public void m_77757_(File pFile) {
            if (!pFile.getParentFile().exists()) {
                pFile.getParentFile().mkdirs();
            }
            super.m_77757_(pFile);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CompoundTag m_7176_(CompoundTag nbt) {
            ListTag reservoirs = new ListTag();
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
            synchronized (multimap) {
                for (ResourceKey dimension : this.reservoirlist.keySet()) {
                    CompoundTag dim = new CompoundTag();
                    dim.m_128359_("dimension", dimension.m_135782_().toString());
                    ListTag islands = new ListTag();
                    for (ReservoirIsland island : this.reservoirlist.get((Object)dimension)) {
                        islands.add((Object)island.writeToNBT());
                    }
                    dim.m_128365_("islands", (Tag)islands);
                    reservoirs.add((Object)dim);
                }
            }
            nbt.m_128365_("reservoirs", (Tag)reservoirs);
            log.debug("{} Saved.", (Object)this);
            return nbt;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void load(CompoundTag nbt) {
            ListTag reservoirs = nbt.m_128437_("reservoirs", 10);
            if (!reservoirs.isEmpty()) {
                Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
                synchronized (multimap) {
                    for (int i = 0; i < reservoirs.size(); ++i) {
                        CompoundTag dim = reservoirs.m_128728_(i);
                        ResourceLocation rl = new ResourceLocation(dim.m_128461_("dimension"));
                        ResourceKey dimType = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)rl);
                        ListTag islands = dim.m_128437_("islands", 10);
                        List<ReservoirIsland> list = islands.stream().map(inbt -> ReservoirIsland.readFromNBT((CompoundTag)inbt)).filter(o -> o != null).collect(Collectors.toList());
                        list.forEach(island -> island.setRegion(this));
                        this.reservoirlist.putAll((Object)dimType, list);
                    }
                }
                log.debug("{} Loaded.", (Object)this);
            }
        }

        public ColumnPos position() {
            return this.regionPos;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public ReservoirIsland get(ResourceKey<Level> dimension, ColumnPos pos) {
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
            synchronized (multimap) {
                for (ReservoirIsland island : this.reservoirlist.get(dimension)) {
                    if (!island.contains(pos)) continue;
                    return island;
                }
                return null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Multimap<ResourceKey<Level>, ReservoirIsland> getReservoirIslandList() {
            Multimap<ResourceKey<Level>, ReservoirIsland> multimap = this.reservoirlist;
            synchronized (multimap) {
                return ImmutableMultimap.copyOf(this.reservoirlist);
            }
        }

        public int hashCode() {
            return Objects.hash(this.regionPos);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof RegionData)) {
                return false;
            }
            RegionData other = (RegionData)((Object)obj);
            return Objects.equals(this.regionPos, other.regionPos);
        }

        public String toString() {
            return String.format("RegionData[%d, %d]", this.regionPos.f_140723_, this.regionPos.f_140724_);
        }
    }
}

