/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.SeismicSurveyTileEntity;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class SeismicSurveyBarrelRenderer
implements BlockEntityRenderer<SeismicSurveyTileEntity> {
    static final ResourceLocation BARREL = ResourceUtils.ip("block/dyn/seismic_survey_tool_barrel");
    static final Function<ResourceLocation, BakedModel> f = rl -> MCUtil.getBlockRenderer().m_110907_().m_110881_().getModel(rl);

    public static void init() {
        ForgeModelBakery.addSpecialModel((ResourceLocation)BARREL);
    }

    public boolean shouldRenderOffScreen(@Nonnull SeismicSurveyTileEntity pBlockEntity) {
        return true;
    }

    public void render(SeismicSurveyTileEntity te, float partialTicks, @Nonnull PoseStack matrix, @Nonnull MultiBufferSource buffer, int light, int overlay) {
        if (te.isSlave || !te.m_58904_().m_46805_(te.m_58899_())) {
            return;
        }
        matrix.m_85836_();
        double d = (double)te.timer / 10.0;
        matrix.m_85837_(0.0, -0.125 * (1.0 - d), 0.0);
        List quads = f.apply(BARREL).getQuads(null, null, null, (IModelData)EmptyModelData.INSTANCE);
        PoseStack.Pose last = matrix.m_85850_();
        VertexConsumer solid = buffer.m_6299_(RenderType.m_110451_());
        for (BakedQuad quad : quads) {
            solid.m_85987_(last, quad, 1.0f, 1.0f, 1.0f, light, overlay);
        }
        matrix.m_85849_();
    }
}

