/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.model;

import flaxbeard.immersivepetroleum.ImmersivePetroleum;
import flaxbeard.immersivepetroleum.client.model.IPModel;
import flaxbeard.immersivepetroleum.client.model.ModelLubricantPipes;
import flaxbeard.immersivepetroleum.client.model.ModelPumpjack;
import flaxbeard.immersivepetroleum.client.render.DerrickRenderer;
import flaxbeard.immersivepetroleum.client.render.SeismicSurveyBarrelRenderer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;

@Mod.EventBusSubscriber(modid="immersivepetroleum", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class IPModels {
    private static final Map<String, IPModel> MODELS = new HashMap<String, IPModel>();

    @SubscribeEvent
    public static void registerModelLoaders(ModelRegistryEvent event) {
        DerrickRenderer.init();
        SeismicSurveyBarrelRenderer.init();
    }

    @SubscribeEvent
    public static void init(FMLConstructModEvent event) {
        IPModels.add("pumpjackarm", new ModelPumpjack());
        IPModels.add("crusher_lubepipes", new ModelLubricantPipes.Crusher());
        IPModels.add("excavator_lubepipes_normal", new ModelLubricantPipes.Excavator(false));
        IPModels.add("excavator_lubepipes_mirrored", new ModelLubricantPipes.Excavator(true));
        IPModels.add("pumpjack_lubepipes_normal", new ModelLubricantPipes.Pumpjack(false));
        IPModels.add("pumpjack_lubepipes_mirrored", new ModelLubricantPipes.Pumpjack(true));
    }

    public static void add(String id, IPModel model) {
        if (MODELS.containsKey(id)) {
            ImmersivePetroleum.log.error("Duplicate ID, \"{}\" already used by {}. Skipping.", (Object)id, ((Object)((Object)MODELS.get(id))).getClass());
        } else {
            model.init();
            MODELS.put(id, model);
        }
    }

    public static Supplier<IPModel> getSupplier(String id) {
        return () -> MODELS.get(id);
    }

    public static Collection<IPModel> getModels() {
        return Collections.unmodifiableCollection(MODELS.values());
    }
}

