/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.client.gui.elements;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import flaxbeard.immersivepetroleum.client.utils.MCUtil;
import flaxbeard.immersivepetroleum.common.blocks.tileentities.DerrickTileEntity;
import flaxbeard.immersivepetroleum.common.cfg.IPClientConfig;
import flaxbeard.immersivepetroleum.common.util.ResourceUtils;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.material.MaterialColor;

public class PipeConfig
extends Button {
    static final Button.OnPress NO_ACTION = b -> {};
    public static final int EMPTY = 0;
    public static final int PIPE_NORMAL = 1;
    public static final int PIPE_PERFORATED = 2;
    public static final int PIPE_PERFORATED_FIXED = 3;
    private final int dynTextureWidth;
    private final int dynTextureHeight;
    private final DynamicTexture gridTexture;
    private final RenderType gridTextureRenderType;
    private final ResourceLocation dynTextureRL;
    private final int pipeNormalColor;
    private final int pipePerforatedColor;
    private final int pipePerforatedFixedColor;
    protected Grid grid;
    protected ColumnPos tilePos;
    protected int gridWidthScaled;
    protected int gridHeightScaled;
    protected int gridScale;
    int[] pipeCountArray = new int[4];

    public PipeConfig(DerrickTileEntity tile, int x, int y, int width, int height, int gridWidth, int gridHeight, int gridScale) {
        super(x, y, width, height, TextComponent.f_131282_, NO_ACTION);
        this.tilePos = new ColumnPos(tile.m_58899_());
        this.grid = new Grid(gridWidth, gridHeight);
        this.copyGridFrom(tile.gridStorage);
        this.gridWidthScaled = gridWidth * gridScale;
        this.gridHeightScaled = gridHeight * gridScale;
        this.gridScale = Mth.m_14045_((int)gridScale, (int)1, (int)Integer.MAX_VALUE);
        this.dynTextureWidth = gridWidth;
        this.dynTextureHeight = gridHeight;
        this.gridTexture = new DynamicTexture(this.dynTextureWidth, this.dynTextureHeight, true);
        this.dynTextureRL = ResourceUtils.ip("pipegrid/" + ((Object)((Object)this)).hashCode());
        MCUtil.getTextureManager().m_118495_(this.dynTextureRL, (AbstractTexture)this.gridTexture);
        this.gridTextureRenderType = RenderType.m_110497_((ResourceLocation)this.dynTextureRL);
        this.pipeNormalColor = Integer.valueOf((String)IPClientConfig.GRID_COLORS.pipe_normal_color.get(), 16);
        this.pipePerforatedColor = Integer.valueOf((String)IPClientConfig.GRID_COLORS.pipe_perforated_color.get(), 16);
        this.pipePerforatedFixedColor = Integer.valueOf((String)IPClientConfig.GRID_COLORS.pipe_perforated_fixed_color.get(), 16);
        this.updateTexture();
    }

    public void reset(DerrickTileEntity tile) {
        this.copyGridFrom(tile.gridStorage);
        this.updateTexture();
    }

    private void copyGridFrom(Grid grid) {
        if (grid != null && grid.width == this.grid.width && grid.height == this.grid.height) {
            System.arraycopy(grid.array, 0, this.grid.array, 0, this.grid.array.length);
            this.grid.changed = true;
        }
    }

    public Grid getGrid() {
        return this.grid;
    }

    public void dispose() {
        this.gridTexture.close();
        MCUtil.getTextureManager().m_118513_(this.dynTextureRL);
    }

    public void updateTexture() {
        NativeImage image = this.gridTexture.m_117991_();
        int texCenterX = this.grid.width / this.gridScale;
        int texCenterY = this.grid.height / this.gridScale;
        ClientLevel world = MCUtil.getLevel();
        for (int gy = 0; gy < this.grid.getHeight(); ++gy) {
            for (int gx = 0; gx < this.grid.getWidth(); ++gx) {
                int color = 0;
                switch (this.grid.get(gx, gy)) {
                    case 0: {
                        BlockPos p;
                        BlockState state;
                        if (gx >= texCenterX - 2 && gx <= texCenterX + 2 && gy >= texCenterY - 2 && gy <= texCenterY + 2) {
                            color = 0;
                            break;
                        }
                        int px = gx - this.grid.getWidth() / 2;
                        int py = gy - this.grid.getHeight() / 2;
                        ColumnPos c = new ColumnPos(this.tilePos.f_140723_ + px, this.tilePos.f_140724_ + py);
                        int y = world.m_5452_(Heightmap.Types.WORLD_SURFACE, new BlockPos(c.f_140723_, 0, c.f_140724_)).m_123342_();
                        while ((state = world.m_8055_(p = new BlockPos(c.f_140723_, --y, c.f_140724_))).m_60780_((BlockGetter)world, p) == MaterialColor.f_76398_ && y > 0) {
                        }
                        int tmp = world.m_8055_((BlockPos)p).m_60780_((BlockGetter)world, (BlockPos)p).f_76396_;
                        float f = 0.5f;
                        int r = (int)((float)(tmp >> 16 & 0xFF) * f);
                        int g = (int)((float)(tmp >> 8 & 0xFF) * f);
                        int b = (int)((float)(tmp >> 0 & 0xFF) * f);
                        color = r << 16 | g << 8 | b;
                        break;
                    }
                    case 1: {
                        color = this.pipeNormalColor;
                        break;
                    }
                    case 2: {
                        color = this.pipePerforatedColor;
                        break;
                    }
                    case 3: {
                        color = this.pipePerforatedFixedColor;
                    }
                }
                image.m_84988_(gx, gy, PipeConfig.toABGR(color));
            }
        }
        this.gridTexture.m_117985_();
    }

    public void m_6305_(PoseStack matrix, int mx, int my, float partialTicks) {
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        VertexConsumer builder = buffer.m_6299_(this.gridTextureRenderType);
        matrix.m_85836_();
        matrix.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        Matrix4f mat = matrix.m_85850_().m_85861_();
        int x = this.grid.width * this.gridScale;
        int y = this.grid.height * this.gridScale;
        builder.m_85982_(mat, 0.0f, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(mat, (float)x, (float)y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(mat, (float)x, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_85982_(mat, 0.0f, 0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        matrix.m_85849_();
        buffer.m_109911_();
        ArrayList<TextComponent> tooltip = new ArrayList<TextComponent>();
        if (mx >= this.f_93620_ && mx < this.f_93620_ + this.f_93618_ && my >= this.f_93621_ && my < this.f_93621_ + this.f_93619_) {
            x = (mx - this.f_93620_) / this.gridScale;
            y = (my - this.f_93621_) / this.gridScale;
            int px = x - this.grid.getWidth() / 2;
            int py = y - this.grid.getHeight() / 2;
            if (px >= -2 && px <= 2 && py >= -2 && py <= 2) {
                tooltip.add(new TextComponent("Center (Derrick)"));
            } else {
                Object dir = "";
                if (py < 0) {
                    dir = (String)dir + "North";
                } else if (py > 0) {
                    dir = (String)dir + "South";
                }
                if (px != 0) {
                    if (((String)dir).length() > 0) {
                        dir = (String)dir + "-";
                    }
                    if (px < 0) {
                        dir = (String)dir + "West";
                    } else if (px > 0) {
                        dir = (String)dir + "East";
                    }
                }
                tooltip.add(new TextComponent("\u00c2\u00a7n" + (String)dir));
            }
            tooltip.add(new TextComponent(String.format(Locale.ENGLISH, "X: %d \u00c2\u00a77(%d)", this.tilePos.f_140723_ + px, px)));
            tooltip.add(new TextComponent(String.format(Locale.ENGLISH, "Z: %d \u00c2\u00a77(%d)", this.tilePos.f_140724_ + py, py)));
            int i = this.grid.get(x, y);
            if (i > 0) {
                if (i == 1) {
                    tooltip.add(new TextComponent("Normal Pipe"));
                } else if (i == 2) {
                    tooltip.add(new TextComponent("Perforated Pipe"));
                } else if (i == 3) {
                    tooltip.add(new TextComponent("Perforated Pipe \u00c2\u00a7c(Fixed)\u00c2\u00a7r"));
                }
            }
            int xa = this.f_93620_ + x * this.gridScale;
            int n = this.f_93621_ + y * this.gridScale;
            GuiComponent.m_93172_((PoseStack)matrix, (int)xa, (int)n, (int)(xa + this.gridScale), (int)(n + this.gridScale), (int)Integer.MAX_VALUE);
        }
        if (!tooltip.isEmpty()) {
            Font font = MCUtil.getFont();
            Objects.requireNonNull(font);
            int lHeight = 9 + 2;
            int margin = 3;
            int width = 0;
            int height = lHeight * tooltip.size();
            for (Component component : tooltip) {
                int sw = font.m_92852_((FormattedText)component);
                if (sw <= width) continue;
                width = sw;
            }
            int x2 = (mx += 12) - margin;
            int n = (my -= height) - margin;
            int w = mx + width + margin;
            int h = my + height;
            int fill = -16777216;
            int border = -12632065;
            matrix.m_85836_();
            GuiComponent.m_93172_((PoseStack)matrix, (int)x2, (int)n, (int)w, (int)h, (int)fill);
            GuiComponent.m_93172_((PoseStack)matrix, (int)x2, (int)n, (int)(x2 + 1), (int)h, (int)border);
            GuiComponent.m_93172_((PoseStack)matrix, (int)x2, (int)n, (int)w, (int)(n + 1), (int)border);
            GuiComponent.m_93172_((PoseStack)matrix, (int)(w - 1), (int)n, (int)w, (int)h, (int)border);
            GuiComponent.m_93172_((PoseStack)matrix, (int)x2, (int)(h - 1), (int)w, (int)h, (int)border);
            for (int i = 0; i < tooltip.size(); ++i) {
                GuiComponent.m_93243_((PoseStack)matrix, (Font)font, (Component)((Component)tooltip.get(i)), (int)mx, (int)(my + lHeight * i), (int)-1);
            }
            matrix.m_85849_();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        boolean flag;
        if (this.m_7972_(button) && (flag = this.m_93680_(mouseX, mouseY))) {
            this.m_7435_(Minecraft.m_91087_().m_91106_());
            this.onGridClick((int)(mouseX - (double)this.f_93620_) / this.gridScale, (int)(mouseY - (double)this.f_93621_) / this.gridScale, button);
            return true;
        }
        return false;
    }

    protected void onGridClick(int x, int y, int button) {
        int type = this.grid.get(x, y);
        if ((type == 1 || type == 2) && type != 3) {
            int[] array = this.getPipeCount();
            if (type == 1 && array[2] < 2) {
                this.grid.set(x, y, 2);
            } else {
                this.grid.set(x, y, 1);
            }
        } else {
            this.grid.clearGrid();
            this.grid.drawLine(this.grid.getWidth() / 2, this.grid.getHeight() / 2, x, y, 1);
            this.grid.set(this.grid.getWidth() / 2, this.grid.getHeight() / 2, 3);
            this.grid.set(Mth.m_14045_((int)x, (int)0, (int)(this.grid.getWidth() - 1)), Mth.m_14045_((int)y, (int)0, (int)(this.grid.getHeight() - 1)), 3);
        }
        this.updateTexture();
    }

    private int[] getPipeCount() {
        if (this.grid.changed) {
            this.pipeCountArray = new int[4];
            for (int i = 0; i < this.grid.size(); ++i) {
                int type;
                int n = type = this.grid.get(i);
                this.pipeCountArray[n] = this.pipeCountArray[n] + 1;
            }
            this.grid.changed = false;
        }
        return this.pipeCountArray;
    }

    protected boolean m_7972_(int button) {
        return button == 0;
    }

    public PipeConfig copyDataFrom(PipeConfig other) {
        if (other != null) {
            this.gridScale = other.gridScale;
            this.grid = other.grid;
            this.updateTexture();
        }
        return this;
    }

    private static int toABGR(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return 0xFF000000 | b << 16 | g << 8 | r;
    }

    public static class Grid {
        private boolean changed;
        private int width;
        private int height;
        private byte[] array;

        public Grid(int width, int height) {
            this.width = width;
            this.height = height;
            this.array = new byte[width * height];
        }

        Grid() {
        }

        public int getWidth() {
            return this.width;
        }

        public int getHeight() {
            return this.height;
        }

        public int size() {
            return this.array.length;
        }

        public void set(int x, int y, int value) {
            this.set(this.index(x, y), value);
        }

        public void set(int index, int value) {
            if (index >= 0 && index < this.array.length && this.array[index] != value) {
                this.array[index] = (byte)(value & 0xFF);
                this.changed = true;
            }
        }

        public int get(int x, int y) {
            return this.get(this.index(x, y));
        }

        public int get(int index) {
            if (index >= 0 && index < this.array.length) {
                return this.array[index] & 0xFF;
            }
            return 0;
        }

        public void clearGrid() {
            for (int i = 0; i < this.size(); ++i) {
                this.array[i] = 0;
            }
        }

        public void drawLine(int xa, int ya, int xb, int yb, int value) {
            xa = Mth.m_14045_((int)xa, (int)0, (int)(this.width - 1));
            xb = Mth.m_14045_((int)xb, (int)0, (int)(this.width - 1));
            ya = Mth.m_14045_((int)ya, (int)0, (int)(this.height - 1));
            yb = Mth.m_14045_((int)yb, (int)0, (int)(this.height - 1));
            int dx = xb - xa;
            int dy = yb - ya;
            int length = Math.max(Math.abs(dx), Math.abs(dy));
            float tx = (float)dx / (float)length;
            float ty = (float)dy / (float)length;
            float x = xa;
            float y = ya;
            int lx = -1;
            int ly = -1;
            for (int i = 1; i <= length; ++i) {
                int cx = Math.round(x);
                int cy = Math.round(y);
                if (lx != cx || ly != cy) {
                    this.set(cx, cy, value);
                    lx = cx;
                    ly = cy;
                }
                x += tx;
                y += ty;
            }
        }

        int index(int x, int y) {
            return this.width * y + x;
        }

        public CompoundTag toCompound() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128405_("width", this.width);
            nbt.m_128405_("height", this.height);
            nbt.m_128382_("grid", this.array);
            return nbt;
        }

        public static Grid fromCompound(CompoundTag nbt) {
            Grid grid = new Grid();
            grid.width = nbt.m_128451_("width");
            grid.height = nbt.m_128451_("height");
            grid.array = nbt.m_128463_("grid");
            if (grid.array.length != grid.width * grid.height) {
                throw new IllegalStateException("Grid width and height don't match array.");
            }
            return grid;
        }
    }
}

