/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.crafting.FluidTagInput;
import blusunrize.immersiveengineering.api.crafting.IERecipeSerializer;
import flaxbeard.immersivepetroleum.api.crafting.IPMultiblockRecipe;
import flaxbeard.immersivepetroleum.api.crafting.IPRecipeTypes;
import flaxbeard.immersivepetroleum.common.cfg.IPServerConfig;
import flaxbeard.immersivepetroleum.common.crafting.Serializers;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.fluids.FluidStack;

public class HighPressureRefineryRecipe
extends IPMultiblockRecipe {
    public static Map<ResourceLocation, HighPressureRefineryRecipe> recipes = new HashMap<ResourceLocation, HighPressureRefineryRecipe>();
    public final ItemStack outputItem;
    public final double chance;
    public final FluidStack output;
    public final FluidTagInput inputFluid;
    @Nullable
    public final FluidTagInput inputFluidSecondary;

    public static HighPressureRefineryRecipe findRecipe(@Nonnull FluidStack input, @Nonnull FluidStack secondary) {
        Objects.requireNonNull(input);
        Objects.requireNonNull(secondary);
        for (HighPressureRefineryRecipe recipe : recipes.values()) {
            if (!(secondary.isEmpty() ? recipe.inputFluidSecondary == null && recipe.inputFluid != null && recipe.inputFluid.test(input) : recipe.inputFluid != null && recipe.inputFluid.test(input) && recipe.inputFluidSecondary != null && recipe.inputFluidSecondary.test(secondary))) continue;
            return recipe;
        }
        return null;
    }

    public static boolean hasRecipeWithInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (HighPressureRefineryRecipe recipe : recipes.values()) {
                if (recipe.inputFluid == null || (ignoreAmount || !recipe.inputFluid.test(fluid)) && (!ignoreAmount || !recipe.inputFluid.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasRecipeWithSecondaryInput(@Nonnull FluidStack fluid, boolean ignoreAmount) {
        Objects.requireNonNull(fluid);
        if (!fluid.isEmpty()) {
            for (HighPressureRefineryRecipe recipe : recipes.values()) {
                if (recipe.inputFluidSecondary == null || (ignoreAmount || !recipe.inputFluidSecondary.test(fluid)) && (!ignoreAmount || !recipe.inputFluidSecondary.testIgnoringAmount(fluid))) continue;
                return true;
            }
        }
        return false;
    }

    public HighPressureRefineryRecipe(ResourceLocation id, FluidStack output, ItemStack outputItem, FluidTagInput inputFluid, @Nullable FluidTagInput inputFluidSecondary, double chance, int energy, int time) {
        super(ItemStack.f_41583_, (Supplier<? extends RecipeType<?>>)IPRecipeTypes.HYDROTREATER, id);
        FluidTagInput[] fluidTagInputArray;
        this.output = output;
        this.outputItem = outputItem;
        this.inputFluid = inputFluid;
        this.inputFluidSecondary = inputFluidSecondary;
        this.chance = chance;
        this.fluidOutputList = Collections.singletonList(output);
        if (inputFluidSecondary != null) {
            FluidTagInput[] fluidTagInputArray2 = new FluidTagInput[2];
            fluidTagInputArray2[0] = inputFluid;
            fluidTagInputArray = fluidTagInputArray2;
            fluidTagInputArray2[1] = inputFluidSecondary;
        } else {
            FluidTagInput[] fluidTagInputArray3 = new FluidTagInput[1];
            fluidTagInputArray = fluidTagInputArray3;
            fluidTagInputArray3[0] = inputFluid;
        }
        this.fluidInputList = Arrays.asList(fluidTagInputArray);
        this.timeAndEnergy(time, energy);
        this.modifyTimeAndEnergy(() -> IPServerConfig.REFINING.hydrotreater_timeModifier.get(), () -> IPServerConfig.REFINING.hydrotreater_energyModifier.get());
    }

    public boolean hasSecondaryItem() {
        return this.outputItem != null && !this.outputItem.m_41619_();
    }

    public int getMultipleProcessTicks() {
        return 0;
    }

    public FluidTagInput getInputFluid() {
        return this.inputFluid;
    }

    @Nullable
    public FluidTagInput getSecondaryInputFluid() {
        return this.inputFluidSecondary;
    }

    public NonNullList<ItemStack> getActualItemOutputs(BlockEntity tile) {
        NonNullList list = NonNullList.m_122779_();
        Level level = tile.m_58904_();
        if ((double)level.f_46441_.nextFloat() <= this.chance) {
            list.add((Object)this.outputItem);
        }
        return list;
    }

    protected IERecipeSerializer<HighPressureRefineryRecipe> getIESerializer() {
        return (IERecipeSerializer)Serializers.HYDROTREATER_SERIALIZER.get();
    }
}

