/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.server;

import dev.architectury.platform.Platform;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicateJS;
import dev.latvian.mods.kubejs.recipe.ModifyRecipeResultCallback;
import dev.latvian.mods.kubejs.recipe.RecipeEventJS;
import dev.latvian.mods.kubejs.recipe.RecipePlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipeTypeJS;
import dev.latvian.mods.kubejs.recipe.RecipeTypeRegistryEventJS;
import dev.latvian.mods.kubejs.recipe.RegisterRecipeHandlersEvent;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.script.ScriptFile;
import dev.latvian.mods.kubejs.script.ScriptFileInfo;
import dev.latvian.mods.kubejs.script.ScriptManager;
import dev.latvian.mods.kubejs.script.ScriptPack;
import dev.latvian.mods.kubejs.script.ScriptPackInfo;
import dev.latvian.mods.kubejs.script.ScriptSource;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.DataPackEventJS;
import dev.latvian.mods.kubejs.script.data.VirtualKubeJSDataPack;
import dev.latvian.mods.kubejs.server.KubeJSReloadListener;
import dev.latvian.mods.kubejs.server.KubeJSServerResourcePack;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.ReloadableServerResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.CloseableResourceManager;
import net.minecraft.server.packs.resources.MultiPackResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;

public class ServerScriptManager {
    public static ServerScriptManager instance;
    public final ScriptManager scriptManager = new ScriptManager(ScriptType.SERVER, KubeJSPaths.SERVER_SCRIPTS, "/data/kubejs/example_server_script.js");

    public ServerScriptManager() {
        try {
            if (Files.notExists(KubeJSPaths.DATA, new LinkOption[0])) {
                Files.createDirectories(KubeJSPaths.DATA, new FileAttribute[0]);
            }
        }
        catch (Throwable ex) {
            throw new RuntimeException("KubeJS failed to register it's script loader!", ex);
        }
    }

    public void updateResources(ReloadableServerResources serverResources) {
        KubeJSReloadListener.resources = serverResources;
        KubeJSReloadListener.recipeContext = RecipePlatformHelper.get().createRecipeContext(serverResources);
    }

    public void reloadScriptManager(ResourceManager resourceManager) {
        this.scriptManager.unload();
        this.scriptManager.loadFromDirectory();
        HashMap<String, List> packs = new HashMap<String, List>();
        for (ResourceLocation resourceLocation : resourceManager.m_6540_("kubejs", s -> s.endsWith(".js"))) {
            packs.computeIfAbsent(resourceLocation.m_135827_(), s -> new ArrayList()).add(resourceLocation);
        }
        for (Map.Entry entry : packs.entrySet()) {
            ScriptPack pack = new ScriptPack(this.scriptManager, new ScriptPackInfo((String)entry.getKey(), "kubejs/"));
            for (ResourceLocation id : (List)entry.getValue()) {
                pack.info.scripts.add(new ScriptFileInfo(pack.info, id.m_135815_().substring(7)));
            }
            for (ScriptFileInfo fileInfo : pack.info.scripts) {
                ScriptSource.FromResource scriptSource = info -> resourceManager.m_142591_(info.id);
                Throwable error = fileInfo.preload(scriptSource);
                if (fileInfo.isIgnored()) continue;
                if (error == null) {
                    pack.scripts.add(new ScriptFile(pack, fileInfo, scriptSource));
                    continue;
                }
                KubeJS.LOGGER.error("Failed to pre-load script file " + fileInfo.location + ": " + error);
            }
            pack.scripts.sort(null);
            this.scriptManager.packs.put(pack.info.namespace, pack);
        }
        this.scriptManager.load();
    }

    public MultiPackResourceManager wrapResourceManager(CloseableResourceManager original) {
        List list;
        VirtualKubeJSDataPack virtualDataPackLow = new VirtualKubeJSDataPack(false);
        VirtualKubeJSDataPack virtualDataPackHigh = new VirtualKubeJSDataPack(true);
        if (original instanceof MultiPackResourceManager) {
            MultiPackResourceManager mp = (MultiPackResourceManager)original;
            list = mp.f_203795_;
        } else {
            list = original.m_7536_().toList();
        }
        LinkedList list2 = new LinkedList(list);
        list2.addFirst(virtualDataPackLow);
        list2.addLast(new KubeJSServerResourcePack());
        list2.addLast(virtualDataPackHigh);
        MultiPackResourceManager wrappedResourceManager = new MultiPackResourceManager(PackType.SERVER_DATA, list2);
        this.reloadScriptManager((ResourceManager)wrappedResourceManager);
        ConsoleJS.SERVER.setLineNumber(true);
        new DataPackEventJS(virtualDataPackLow, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.last");
        new DataPackEventJS(virtualDataPackLow, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.low_priority");
        new DataPackEventJS(virtualDataPackHigh, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.first");
        new DataPackEventJS(virtualDataPackHigh, wrappedResourceManager).post(ScriptType.SERVER, "server.datapack.high_priority");
        ConsoleJS.SERVER.setLineNumber(false);
        ConsoleJS.SERVER.info("Scripts loaded");
        HashMap<ResourceLocation, RecipeTypeJS> typeMap = new HashMap<ResourceLocation, RecipeTypeJS>();
        RegisterRecipeHandlersEvent modEvent = new RegisterRecipeHandlersEvent(typeMap);
        KubeJSPlugins.forEachPlugin(plugin -> plugin.addRecipes(modEvent));
        new RecipeTypeRegistryEventJS(typeMap).post(ScriptType.SERVER, "recipes.type_registry");
        if (Platform.isForge()) {
            RecipeEventJS.customIngredientMap = new HashMap<UUID, IngredientWithCustomPredicateJS>();
        }
        RecipeEventJS.modifyResultCallbackMap = new HashMap<UUID, ModifyRecipeResultCallback>();
        CustomIngredientAction.MAP.clear();
        RecipeEventJS.instance = new RecipeEventJS(typeMap);
        return wrappedResourceManager;
    }
}

