/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.fluid;

import dev.architectury.core.item.ArchitecturyBucketItem;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.latvian.mods.kubejs.fluid.FluidBuilder;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.item.ItemBuilder;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.world.item.BucketItem;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluidBucketItemBuilder
extends ItemBuilder {
    public final FluidBuilder fluidBuilder;

    public FluidBucketItemBuilder(FluidBuilder b) {
        super(b.newID("", "_bucket"));
        this.fluidBuilder = b;
        this.maxStackSize(1);
    }

    @Override
    public BucketItem createObject() {
        return new ArchitecturyBucketItem((Supplier)this.fluidBuilder, this.createItemProperties());
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        generator.itemModel(this.id, m -> m.parent("kubejs:item/generated_bucket"));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientRegistry(Supplier<Minecraft> minecraft) {
        if (this.fluidBuilder.bucketColor != -1) {
            ColorHandlerRegistry.registerItemColors((stack, index) -> index == 1 ? this.fluidBuilder.bucketColor : -1, (Supplier[])new Supplier[]{this});
        }
    }
}

