/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.entity;

import dev.latvian.mods.kubejs.entity.EntityJS;
import dev.latvian.mods.kubejs.entity.EntityPotionEffectsJS;
import dev.latvian.mods.kubejs.entity.RayTraceResultJS;
import dev.latvian.mods.kubejs.item.ItemStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.level.LevelPlatformHelper;
import dev.latvian.mods.kubejs.util.ConsoleJS;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class LivingEntityJS
extends EntityJS {
    public static final UUID PLAYER_CUSTOM_SPEED = UUID.fromString("6715D9C6-1DA0-4B78-971A-5C32F5709F66");
    public static final String PLAYER_CUSTOM_SPEED_NAME = "kubejs.player.speed.modifier";
    public final LivingEntity minecraftLivingEntity;

    public LivingEntityJS(LivingEntity e) {
        super((Entity)e);
        this.minecraftLivingEntity = e;
    }

    @Override
    public boolean isLiving() {
        return true;
    }

    public boolean isChild() {
        return this.minecraftLivingEntity.m_6162_();
    }

    public float getHealth() {
        return this.minecraftLivingEntity.m_21223_();
    }

    public void setHealth(float hp) {
        this.minecraftLivingEntity.m_21153_(hp);
    }

    public void heal(float hp) {
        this.minecraftLivingEntity.m_5634_(hp);
    }

    public float getMaxHealth() {
        return this.minecraftLivingEntity.m_21233_();
    }

    public void setMaxHealth(float hp) {
        this.minecraftLivingEntity.m_21051_(Attributes.f_22276_).m_22100_((double)hp);
    }

    public boolean isUndead() {
        return this.minecraftLivingEntity.m_21222_();
    }

    public boolean isOnLadder() {
        return this.minecraftLivingEntity.m_6147_();
    }

    public boolean isSleeping() {
        return this.minecraftLivingEntity.m_5803_();
    }

    public boolean isElytraFlying() {
        return this.minecraftLivingEntity.m_21255_();
    }

    @Nullable
    public LivingEntityJS getRevengeTarget() {
        return this.getLevel().getLivingEntity((Entity)this.minecraftLivingEntity.m_142581_());
    }

    public int getRevengeTimer() {
        return this.minecraftLivingEntity.m_21213_();
    }

    public void setRevengeTarget(@Nullable LivingEntityJS target) {
        this.minecraftLivingEntity.m_6703_(target == null ? null : target.minecraftLivingEntity);
    }

    @Nullable
    public LivingEntityJS getLastAttackedEntity() {
        return this.getLevel().getLivingEntity((Entity)this.minecraftLivingEntity.m_21214_());
    }

    public int getLastAttackedEntityTime() {
        return this.minecraftLivingEntity.m_21215_();
    }

    public int getIdleTime() {
        return this.minecraftLivingEntity.m_21216_();
    }

    public EntityPotionEffectsJS getPotionEffects() {
        return new EntityPotionEffectsJS(this.minecraftLivingEntity);
    }

    @Nullable
    public DamageSource getLastDamageSource() {
        return this.minecraftLivingEntity.m_21225_();
    }

    @Nullable
    public LivingEntityJS getAttackingEntity() {
        return this.getLevel().getLivingEntity((Entity)this.minecraftLivingEntity.m_21232_());
    }

    public void swingArm(InteractionHand hand) {
        this.minecraftLivingEntity.m_21011_(hand, true);
    }

    public ItemStackJS getEquipment(EquipmentSlot slot) {
        return ItemStackJS.of(this.minecraftLivingEntity.m_6844_(slot));
    }

    public void setEquipment(EquipmentSlot slot, ItemStackJS item) {
        this.minecraftLivingEntity.m_8061_(slot, item.getItemStack());
    }

    public ItemStackJS getHeldItem(InteractionHand hand) {
        return ItemStackJS.of(this.minecraftLivingEntity.m_21120_(hand));
    }

    public void setHeldItem(InteractionHand hand, ItemStackJS item) {
        this.minecraftLivingEntity.m_21008_(hand, item.getItemStack());
    }

    public ItemStackJS getMainHandItem() {
        return this.getEquipment(EquipmentSlot.MAINHAND);
    }

    public void setMainHandItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.MAINHAND, item);
    }

    public ItemStackJS getOffHandItem() {
        return this.getEquipment(EquipmentSlot.OFFHAND);
    }

    public void setOffHandItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.OFFHAND, item);
    }

    public ItemStackJS getHeadArmorItem() {
        return this.getEquipment(EquipmentSlot.HEAD);
    }

    public void setHeadArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.HEAD, item);
    }

    public ItemStackJS getChestArmorItem() {
        return this.getEquipment(EquipmentSlot.CHEST);
    }

    public void setChestArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.CHEST, item);
    }

    public ItemStackJS getLegsArmorItem() {
        return this.getEquipment(EquipmentSlot.LEGS);
    }

    public void setLegsArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.LEGS, item);
    }

    public ItemStackJS getFeetArmorItem() {
        return this.getEquipment(EquipmentSlot.FEET);
    }

    public void setFeetArmorItem(ItemStackJS item) {
        this.setEquipment(EquipmentSlot.FEET, item);
    }

    public void damageEquipment(EquipmentSlot slot, int amount, Consumer<ItemStackJS> onBroken) {
        ItemStack stack = this.minecraftLivingEntity.m_6844_(slot);
        if (!stack.m_41619_()) {
            stack.m_41622_(amount, this.minecraftLivingEntity, livingEntity -> onBroken.accept(ItemStackJS.of(stack)));
            if (stack.m_41619_()) {
                this.minecraftLivingEntity.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public void damageEquipment(EquipmentSlot slot, int amount) {
        this.damageEquipment(slot, amount, stack -> {});
    }

    public void damageEquipment(EquipmentSlot slot) {
        this.damageEquipment(slot, 1);
    }

    public void damageHeldItem(InteractionHand hand, int amount, Consumer<ItemStackJS> onBroken) {
        this.damageEquipment(hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND, amount, onBroken);
    }

    public void damageHeldItem(InteractionHand hand, int amount) {
        this.damageHeldItem(hand, amount, stack -> {});
    }

    public void damageHeldItem() {
        this.damageHeldItem(InteractionHand.MAIN_HAND, 1);
    }

    public boolean isHoldingInAnyHand(Object ingredient) {
        IngredientJS i = IngredientJS.of(ingredient);
        return i.testVanilla(this.minecraftLivingEntity.m_21120_(InteractionHand.MAIN_HAND)) || i.testVanilla(this.minecraftLivingEntity.m_21120_(InteractionHand.OFF_HAND));
    }

    public float getMovementSpeed() {
        ConsoleJS.SERVER.warn("'getMovementSpeed' is deprecated. Use 'getDefaultMovementSpeed' or 'getTotalMovementSpeed'");
        return this.minecraftLivingEntity.m_6113_();
    }

    @Deprecated
    public void setMovementSpeed(float speed) {
        ConsoleJS.SERVER.warn("'setMovementSpeed' is deprecated. Use 'setDefaultMovementSpeed', 'setMovementSpeedAddition', 'setDefaultMovementSpeedMultiplier' or 'setTotalMovementSpeedMultiplier'.");
        this.minecraftLivingEntity.m_7910_(speed);
    }

    public double getTotalMovementSpeed() {
        return this.minecraftLivingEntity.m_21133_(Attributes.f_22279_);
    }

    public double getDefaultMovementSpeed() {
        return this.minecraftLivingEntity.m_21172_(Attributes.f_22279_);
    }

    public void setDefaultMovementSpeed(double speed) {
        this.minecraftLivingEntity.m_21051_(Attributes.f_22279_).m_22100_(speed);
    }

    public void setMovementSpeedAddition(double speed) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(Attributes.f_22279_);
        if (instance != null) {
            instance.m_22120_(PLAYER_CUSTOM_SPEED);
            instance.m_22118_(this.createSpeedModifier(speed, AttributeModifier.Operation.ADDITION));
        }
    }

    public void setDefaultMovementSpeedMultiplier(double speed) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(Attributes.f_22279_);
        if (instance != null) {
            instance.m_22120_(PLAYER_CUSTOM_SPEED);
            instance.m_22118_(this.createSpeedModifier(speed, AttributeModifier.Operation.MULTIPLY_BASE));
        }
    }

    public void setTotalMovementSpeedMultiplier(double speed) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(Attributes.f_22279_);
        if (instance != null) {
            instance.m_22120_(PLAYER_CUSTOM_SPEED);
            instance.m_22118_(this.createSpeedModifier(speed, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
    }

    public boolean canEntityBeSeen(LivingEntityJS entity) {
        return BehaviorUtils.m_22667_((LivingEntity)this.minecraftLivingEntity, (LivingEntity)entity.minecraftLivingEntity);
    }

    public float getAbsorptionAmount() {
        return this.minecraftLivingEntity.m_6103_();
    }

    public void setAbsorptionAmount(float amount) {
        this.minecraftLivingEntity.m_7911_(amount);
    }

    public double getReachDistance() {
        return LevelPlatformHelper.get().getReachDistance(this.minecraftLivingEntity);
    }

    public RayTraceResultJS rayTrace() {
        return this.rayTrace(this.getReachDistance());
    }

    public double getAttributeTotalValue(Attribute attribute) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(attribute);
        if (instance != null) {
            return instance.m_22135_();
        }
        return 0.0;
    }

    public double getAttributeBaseValue(Attribute attribute) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(attribute);
        if (instance != null) {
            return instance.m_22115_();
        }
        return 0.0;
    }

    public void setAttributeBaseValue(Attribute attribute, double value) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22100_(value);
        }
    }

    public void modifyAttribute(Attribute attribute, String identifier, double d, AttributeModifier.Operation operation) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(attribute);
        if (instance != null) {
            UUID uuid = new UUID(identifier.hashCode(), identifier.hashCode());
            instance.m_22120_(uuid);
            instance.m_22118_(new AttributeModifier(uuid, identifier, d, operation));
        }
    }

    public void removeAttribute(Attribute attribute, String identifier) {
        AttributeInstance instance = this.minecraftLivingEntity.m_21051_(attribute);
        if (instance != null) {
            instance.m_22120_(new UUID(identifier.hashCode(), identifier.hashCode()));
        }
    }

    private AttributeModifier createSpeedModifier(double speed, AttributeModifier.Operation operation) {
        return new AttributeModifier(PLAYER_CUSTOM_SPEED, PLAYER_CUSTOM_SPEED_NAME, speed, operation);
    }
}

