/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.block;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.architectury.registry.client.rendering.RenderTypeRegistry;
import dev.latvian.mods.kubejs.BuilderBase;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.RegistryObjectBuilderTypes;
import dev.latvian.mods.kubejs.block.BlockItemBuilder;
import dev.latvian.mods.kubejs.block.BlockStateModifyCallbackJS;
import dev.latvian.mods.kubejs.block.BlockStateModifyPlacementCallbackJS;
import dev.latvian.mods.kubejs.block.MaterialJS;
import dev.latvian.mods.kubejs.block.MaterialListJS;
import dev.latvian.mods.kubejs.block.RandomTickCallbackJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.generator.DataJsonGenerator;
import dev.latvian.mods.kubejs.loot.LootBuilder;
import dev.latvian.mods.rhino.mod.util.color.Color;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public abstract class BlockBuilder
extends BuilderBase<Block> {
    public transient MaterialJS material;
    public transient float hardness;
    public transient float resistance;
    public transient float lightLevel;
    public transient boolean opaque;
    public transient boolean fullBlock;
    public transient boolean requiresTool;
    public transient String renderType;
    public transient Int2IntOpenHashMap color;
    public final transient JsonObject textures;
    public transient String model;
    public transient BlockItemBuilder itemBuilder;
    public transient List<AABB> customShape;
    public transient boolean noCollision;
    public transient boolean notSolid;
    public transient float slipperiness = 0.6f;
    public transient float speedFactor = 1.0f;
    public transient float jumpFactor = 1.0f;
    public Consumer<RandomTickCallbackJS> randomTickCallback;
    public Consumer<LootBuilder> lootTable;
    public JsonObject blockstateJson;
    public JsonObject modelJson;
    public transient boolean noValidSpawns;
    public transient boolean suffocating;
    public transient boolean viewBlocking;
    public transient boolean redstoneConductor;
    public transient boolean transparent;
    public transient Set<Property<?>> blockStateProperties;
    public transient Consumer<BlockStateModifyCallbackJS> defaultStateModification;
    public transient Consumer<BlockStateModifyPlacementCallbackJS> placementStateModification;

    public BlockBuilder(ResourceLocation i) {
        super(i);
        this.material = MaterialListJS.INSTANCE.map.get("wood");
        this.hardness = 1.5f;
        this.resistance = 3.0f;
        this.lightLevel = 0.0f;
        this.opaque = true;
        this.fullBlock = false;
        this.requiresTool = false;
        this.renderType = "solid";
        this.color = new Int2IntOpenHashMap();
        this.color.defaultReturnValue(-1);
        this.textures = new JsonObject();
        this.textureAll(this.id.m_135827_() + ":block/" + this.id.m_135815_());
        this.model = "";
        this.itemBuilder = this.getOrCreateItemBuilder();
        this.itemBuilder.blockBuilder = this;
        this.customShape = new ArrayList<AABB>();
        this.noCollision = false;
        this.notSolid = false;
        this.randomTickCallback = null;
        this.lootTable = loot -> loot.addPool(pool -> {
            pool.survivesExplosion();
            pool.addItem(new ItemStack((ItemLike)this.get()));
        });
        this.blockstateJson = null;
        this.modelJson = null;
        this.noValidSpawns = false;
        this.suffocating = true;
        this.viewBlocking = true;
        this.redstoneConductor = true;
        this.transparent = false;
        this.blockStateProperties = new HashSet();
        this.defaultStateModification = null;
        this.placementStateModification = null;
    }

    @Override
    public final RegistryObjectBuilderTypes<Block> getRegistryType() {
        return RegistryObjectBuilderTypes.BLOCK;
    }

    @Override
    public Block transformObject(Block obj) {
        obj.setBlockBuilderKJS(this);
        return obj;
    }

    @Override
    public void createAdditionalObjects() {
        if (this.itemBuilder != null) {
            RegistryObjectBuilderTypes.ITEM.addBuilder(this.itemBuilder);
        }
    }

    @Override
    public BuilderBase<Block> displayName(String name) {
        if (this.itemBuilder != null) {
            this.itemBuilder.displayName(name);
        }
        return super.displayName(name);
    }

    @Override
    public void generateDataJsons(DataJsonGenerator generator) {
        if (this.lootTable != null) {
            LootBuilder lootBuilder = new LootBuilder(null);
            lootBuilder.type = "minecraft:block";
            this.lootTable.accept(lootBuilder);
            generator.json(this.newID("loot_tables/blocks/", ""), (JsonElement)lootBuilder.toJson());
        }
    }

    @Override
    public void generateAssetJsons(AssetJsonGenerator generator) {
        if (this.blockstateJson != null) {
            generator.json(this.newID("blockstates/", ""), (JsonElement)this.blockstateJson);
        } else {
            generator.blockState(this.id, bs -> bs.variant("", (String)(this.model.isEmpty() ? this.id.m_135827_() + ":block/" + this.id.m_135815_() : this.model)));
        }
        if (this.modelJson != null) {
            generator.json(this.newID("models/block/", ""), (JsonElement)this.modelJson);
        } else {
            generator.blockModel(this.id, m -> {
                String particle = this.textures.get("particle").getAsString();
                if (this.areAllTexturesEqual(this.textures, particle)) {
                    m.parent("minecraft:block/cube_all");
                    m.texture("all", particle);
                } else {
                    m.parent("block/cube");
                    m.textures(this.textures);
                }
                if (!this.color.isEmpty() || !this.customShape.isEmpty()) {
                    ArrayList<AABB> boxes = new ArrayList<AABB>(this.customShape);
                    if (boxes.isEmpty()) {
                        boxes.add(new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0));
                    }
                    for (AABB box : boxes) {
                        m.element(e -> {
                            e.box(box);
                            for (Direction direction : Direction.values()) {
                                e.face(direction, face -> {
                                    face.tex("#" + direction.m_7912_());
                                    face.cull();
                                    if (!this.color.isEmpty()) {
                                        face.tintindex(0);
                                    }
                                });
                            }
                        });
                    }
                }
            });
        }
        if (this.itemBuilder != null) {
            generator.itemModel(this.itemBuilder.id, m -> {
                if (!this.model.isEmpty()) {
                    m.parent(this.model);
                } else {
                    m.parent(this.newID("block/", "").toString());
                }
            });
        }
    }

    public Map<ResourceLocation, JsonObject> generateBlockModels(BlockBuilder builder) {
        HashMap<ResourceLocation, JsonObject> map = new HashMap<ResourceLocation, JsonObject>();
        if (builder.modelJson != null) {
            map.put(builder.newID("models/block/", ""), builder.modelJson);
        } else {
            JsonObject modelJson = new JsonObject();
            String particle = builder.textures.get("particle").getAsString();
            if (this.areAllTexturesEqual(builder.textures, particle)) {
                modelJson.addProperty("parent", "block/cube_all");
                JsonObject textures = new JsonObject();
                textures.addProperty("all", particle);
                modelJson.add("textures", (JsonElement)textures);
            } else {
                modelJson.addProperty("parent", "block/cube");
                modelJson.add("textures", (JsonElement)builder.textures);
            }
            if (!builder.color.isEmpty()) {
                JsonObject cube = new JsonObject();
                JsonArray from = new JsonArray();
                from.add((Number)0);
                from.add((Number)0);
                from.add((Number)0);
                cube.add("from", (JsonElement)from);
                JsonArray to = new JsonArray();
                to.add((Number)16);
                to.add((Number)16);
                to.add((Number)16);
                cube.add("to", (JsonElement)to);
                JsonObject faces = new JsonObject();
                for (Direction direction : Direction.values()) {
                    JsonObject f = new JsonObject();
                    f.addProperty("texture", "#" + direction.m_7912_());
                    f.addProperty("cullface", direction.m_7912_());
                    f.addProperty("tintindex", (Number)0);
                    faces.add(direction.m_7912_(), (JsonElement)f);
                }
                cube.add("faces", (JsonElement)faces);
                JsonArray elements = new JsonArray();
                elements.add((JsonElement)cube);
                modelJson.add("elements", (JsonElement)elements);
            }
            map.put(builder.newID("models/block/", ""), modelJson);
        }
        return map;
    }

    private boolean areAllTexturesEqual(JsonObject tex, String t) {
        for (Direction direction : Direction.values()) {
            if (tex.get(direction.m_7912_()).getAsString().equals(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientRegistry(Supplier<Minecraft> minecraft) {
        switch (this.renderType) {
            case "cutout": {
                RenderTypeRegistry.register((RenderType)RenderType.m_110463_(), (Block[])new Block[]{(Block)this.get()});
                break;
            }
            case "cutout_mipped": {
                RenderTypeRegistry.register((RenderType)RenderType.m_110457_(), (Block[])new Block[]{(Block)this.get()});
                break;
            }
            case "translucent": {
                RenderTypeRegistry.register((RenderType)RenderType.m_110466_(), (Block[])new Block[]{(Block)this.get()});
            }
        }
        if (!this.color.isEmpty()) {
            ColorHandlerRegistry.registerBlockColors((state, level, pos, index) -> this.color.get(index), (Supplier[])new Supplier[]{this});
        }
    }

    @Override
    public void addResourcePackLocations(String path, List<ResourceLocation> list, PackType packType) {
        if (this.lootTable != null && path.equals("loot_tables")) {
            list.add(new ResourceLocation(this.id.m_135827_(), "loot_tables/blocks/" + this.id.m_135815_() + ".json"));
        }
    }

    public BlockBuilder material(MaterialJS m) {
        this.material = m;
        return this;
    }

    public BlockBuilder hardness(float h) {
        this.hardness = h;
        return this;
    }

    public BlockBuilder resistance(float r) {
        this.resistance = r;
        return this;
    }

    public BlockBuilder unbreakable() {
        this.hardness = -1.0f;
        this.resistance = Float.MAX_VALUE;
        return this;
    }

    public BlockBuilder lightLevel(float light) {
        this.lightLevel = light;
        return this;
    }

    public BlockBuilder opaque(boolean o) {
        this.opaque = o;
        return this;
    }

    public BlockBuilder fullBlock(boolean f) {
        this.fullBlock = f;
        return this;
    }

    public BlockBuilder requiresTool(boolean f) {
        this.requiresTool = f;
        return this;
    }

    public BlockBuilder renderType(String l) {
        this.renderType = l;
        return this;
    }

    public BlockBuilder color(int index, Color c) {
        this.color.put(index, c.getArgbJS());
        return this;
    }

    public BlockBuilder textureAll(String tex) {
        for (Direction direction : Direction.values()) {
            this.textureSide(direction, tex);
        }
        this.textures.addProperty("particle", tex);
        return this;
    }

    public BlockBuilder textureSide(Direction direction, String tex) {
        return this.texture(direction.m_7912_(), tex);
    }

    public BlockBuilder texture(String id, String tex) {
        this.textures.addProperty(id, tex);
        return this;
    }

    public BlockBuilder model(String m) {
        this.model = m;
        if (this.itemBuilder != null) {
            this.itemBuilder.parentModel(m);
        }
        return this;
    }

    public BlockBuilder item(@Nullable Consumer<BlockItemBuilder> i) {
        if (i == null) {
            this.itemBuilder = null;
            this.lootTable = null;
        } else {
            i.accept(this.getOrCreateItemBuilder());
        }
        return this;
    }

    @HideFromJS
    protected BlockItemBuilder getOrCreateItemBuilder() {
        return this.itemBuilder == null ? (this.itemBuilder = new BlockItemBuilder(this.id)) : this.itemBuilder;
    }

    public BlockBuilder noItem() {
        return this.item(null);
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1, boolean scale16) {
        if (scale16) {
            this.customShape.add(new AABB(x0 / 16.0, y0 / 16.0, z0 / 16.0, x1 / 16.0, y1 / 16.0, z1 / 16.0));
        } else {
            this.customShape.add(new AABB(x0, y0, z0, x1, y1, z1));
        }
        return this;
    }

    public BlockBuilder box(double x0, double y0, double z0, double x1, double y1, double z1) {
        return this.box(x0, y0, z0, x1, y1, z1, true);
    }

    public VoxelShape createShape() {
        if (this.customShape.isEmpty()) {
            return Shapes.m_83144_();
        }
        VoxelShape shape = Shapes.m_83064_((AABB)this.customShape.get(0));
        for (int i = 1; i < this.customShape.size(); ++i) {
            shape = Shapes.m_83110_((VoxelShape)shape, (VoxelShape)Shapes.m_83064_((AABB)this.customShape.get(i)));
        }
        return shape;
    }

    public BlockBuilder noCollision() {
        this.noCollision = true;
        return this;
    }

    @Deprecated
    public BlockBuilder noCollission() {
        return this.noCollision();
    }

    public BlockBuilder notSolid() {
        this.notSolid = true;
        return this;
    }

    @Deprecated(forRemoval=true)
    public BlockBuilder setWaterlogged(boolean waterlogged) {
        KubeJS.startupScriptManager.type.console.warn("\"BlockBuilder.waterlogged\" is a deprecated property! Please use \"BlockBuilder.property(BlockProperties.WATERLOGGED)\" instead.");
        if (waterlogged) {
            this.property((Property<?>)BlockStateProperties.f_61362_);
        }
        return this;
    }

    @Deprecated(forRemoval=true)
    public boolean getWaterlogged() {
        KubeJS.startupScriptManager.type.console.warn("\"BlockBuilder.waterlogged\" is a deprecated property! Please use \"BlockBuilder.property(BlockProperties.WATERLOGGED)\" instead.");
        return this.canBeWaterlogged();
    }

    public BlockBuilder waterlogged() {
        return this.property((Property<?>)BlockStateProperties.f_61362_);
    }

    public boolean canBeWaterlogged() {
        return this.blockStateProperties.contains(BlockStateProperties.f_61362_);
    }

    public BlockBuilder noDrops() {
        this.lootTable = null;
        return this;
    }

    public BlockBuilder slipperiness(float f) {
        this.slipperiness = f;
        return this;
    }

    public BlockBuilder speedFactor(float f) {
        this.speedFactor = f;
        return this;
    }

    public BlockBuilder jumpFactor(float f) {
        this.jumpFactor = f;
        return this;
    }

    public BlockBuilder randomTick(@Nullable Consumer<RandomTickCallbackJS> randomTickCallback) {
        this.randomTickCallback = randomTickCallback;
        return this;
    }

    public BlockBuilder noValidSpawns(boolean b) {
        this.noValidSpawns = b;
        return this;
    }

    public BlockBuilder suffocating(boolean b) {
        this.suffocating = b;
        return this;
    }

    public BlockBuilder viewBlocking(boolean b) {
        this.viewBlocking = b;
        return this;
    }

    public BlockBuilder redstoneConductor(boolean b) {
        this.redstoneConductor = b;
        return this;
    }

    public BlockBuilder transparent(boolean b) {
        this.transparent = b;
        return this;
    }

    public BlockBuilder defaultCutout() {
        return this.renderType("cutout").notSolid().noValidSpawns(true).suffocating(false).viewBlocking(false).redstoneConductor(false).transparent(true);
    }

    public BlockBuilder defaultTranslucent() {
        return this.defaultCutout().renderType("translucent");
    }

    public BlockBuilder tag(ResourceLocation tag) {
        return this.tagBoth(tag);
    }

    public BlockBuilder tagBoth(ResourceLocation tag) {
        this.tagBlock(tag);
        this.tagItem(tag);
        return this;
    }

    public BlockBuilder tagBlock(ResourceLocation tag) {
        this.defaultTags.add(tag);
        return this;
    }

    public BlockBuilder tagItem(ResourceLocation tag) {
        this.itemBuilder.defaultTags.add(tag);
        return this;
    }

    public BlockBuilder defaultState(Consumer<BlockStateModifyCallbackJS> callbackJS) {
        this.defaultStateModification = callbackJS;
        return this;
    }

    public BlockBuilder placementState(Consumer<BlockStateModifyPlacementCallbackJS> callbackJS) {
        this.placementStateModification = callbackJS;
        return this;
    }

    public BlockBuilder property(Property<?> property) {
        if (property.m_6908_().size() <= 1) {
            throw new IllegalArgumentException(String.format("Block \"%s\" has an illegal Blockstate Property \"%s\" which has <= 1 possible values. (%d possible values)", this.id, property.m_61708_(), property.m_6908_().size()));
        }
        this.blockStateProperties.add(property);
        return this;
    }

    public BlockBehaviour.Properties createProperties() {
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60939_((Material)this.material.getMinecraftMaterial());
        properties.m_60918_(this.material.getSound());
        if (this.resistance >= 0.0f) {
            properties.m_60913_(this.hardness, this.resistance);
        } else {
            properties.m_60978_(this.hardness);
        }
        properties.m_60953_(state -> (int)(this.lightLevel * 15.0f));
        if (this.noCollision) {
            properties.m_60910_();
        }
        if (this.notSolid) {
            properties.m_60955_();
        }
        if (this.requiresTool) {
            properties.m_60999_();
        }
        if (this.lootTable == null) {
            properties.m_60993_();
        }
        properties.m_60911_(this.slipperiness);
        properties.m_60956_(this.speedFactor);
        properties.m_60967_(this.jumpFactor);
        if (this.noValidSpawns) {
            properties.m_60922_((blockState, blockGetter, blockPos, object) -> false);
        }
        if (!this.suffocating) {
            properties.m_60960_((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.viewBlocking) {
            properties.m_60971_((blockState, blockGetter, blockPos) -> false);
        }
        if (!this.redstoneConductor) {
            properties.m_60924_((blockState, blockGetter, blockPos) -> false);
        }
        if (this.randomTickCallback != null) {
            properties.m_60977_();
        }
        return properties;
    }
}

