/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.common.fluids.IEFluidBlock;
import blusunrize.immersiveengineering.common.register.IEFluids;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidAttributes;
import net.minecraftforge.fluids.FluidStack;

public class IEFluid
extends FlowingFluid {
    private static IEFluids.FluidEntry entryStatic;
    protected final IEFluids.FluidEntry entry;
    protected final ResourceLocation stillTex;
    protected final ResourceLocation flowingTex;
    @Nullable
    protected final Consumer<FluidAttributes.Builder> buildAttributes;
    public static final DispenseItemBehavior BUCKET_DISPENSE_BEHAVIOR;

    public static IEFluid makeFluid(FluidConstructor make, IEFluids.FluidEntry entry, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        entryStatic = entry;
        IEFluid result = make.create(entry, stillTex, flowingTex, buildAttributes);
        entryStatic = null;
        return result;
    }

    public IEFluid(IEFluids.FluidEntry entry, ResourceLocation stillTex, ResourceLocation flowingTex) {
        this(entry, stillTex, flowingTex, null);
    }

    public IEFluid(IEFluids.FluidEntry entry, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
        this.entry = entry;
        this.stillTex = stillTex;
        this.flowingTex = flowingTex;
        this.buildAttributes = buildAttributes;
    }

    public void addTooltipInfo(FluidStack fluidStack, @Nullable Player player, List<Component> tooltip) {
    }

    @Nonnull
    public Item m_6859_() {
        return this.entry.getBucket();
    }

    protected boolean m_5486_(FluidState fluidState, BlockGetter blockReader, BlockPos pos, Fluid fluidIn, Direction direction) {
        return direction == Direction.DOWN && !this.m_6212_(fluidIn);
    }

    public boolean m_6212_(@Nonnull Fluid fluidIn) {
        return fluidIn == this.entry.getStill() || fluidIn == this.entry.getFlowing();
    }

    public int m_6718_(LevelReader p_205569_1_) {
        int dW = this.m_5615_().getAttributes().getViscosity() - Fluids.f_76193_.getAttributes().getViscosity();
        double v = Math.round(5.0 + (double)dW * 0.005);
        return Math.max(2, (int)v);
    }

    protected float m_6752_() {
        return 100.0f;
    }

    protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
        super.m_7180_(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).getProperties()) {
            builder.m_61104_(new Property[]{p});
        }
    }

    protected BlockState m_5804_(FluidState state) {
        BlockState result = (BlockState)this.entry.getBlock().m_49966_().m_61124_((Property)LiquidBlock.f_54688_, (Comparable)Integer.valueOf(IEFluid.m_76092_((FluidState)state)));
        for (Property<?> prop : this.entry.getProperties()) {
            result = IEFluidBlock.withCopiedValue(prop, result, state);
        }
        return result;
    }

    public boolean m_7444_(FluidState state) {
        return state.m_76152_() == this.entry.getStill();
    }

    public int m_7430_(FluidState state) {
        if (this.m_7444_(state)) {
            return 8;
        }
        return (Integer)state.m_61143_((Property)f_75948_);
    }

    @Nonnull
    protected FluidAttributes createAttributes() {
        FluidAttributes.Builder builder = FluidAttributes.builder((ResourceLocation)this.stillTex, (ResourceLocation)this.flowingTex);
        if (this.buildAttributes != null) {
            this.buildAttributes.accept(builder);
        }
        return builder.build((Fluid)this);
    }

    @Nonnull
    public Fluid m_5615_() {
        return this.entry.getFlowing();
    }

    @Nonnull
    public Fluid m_5613_() {
        return this.entry.getStill();
    }

    protected boolean m_6760_() {
        return false;
    }

    protected void m_7456_(LevelAccessor iWorld, BlockPos blockPos, BlockState blockState) {
    }

    protected int m_6719_(LevelReader iWorldReader) {
        return 4;
    }

    protected int m_6713_(LevelReader iWorldReader) {
        return 1;
    }

    public static Consumer<FluidAttributes.Builder> createBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density);
    }

    public static Consumer<FluidAttributes.Builder> createGasBuilder(int density, int viscosity) {
        return builder -> builder.viscosity(viscosity).density(density).gaseous();
    }

    static {
        BUCKET_DISPENSE_BEHAVIOR = new DefaultDispenseItemBehavior(){
            private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

            public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                BucketItem bucketitem = (BucketItem)stack.m_41720_();
                BlockPos blockpos = source.m_7961_().m_142300_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                ServerLevel world = source.m_7727_();
                if (bucketitem.m_142073_(null, (Level)world, blockpos, null)) {
                    bucketitem.m_142131_(null, (Level)world, stack, blockpos);
                    return new ItemStack((ItemLike)Items.f_42446_);
                }
                return this.defaultBehavior.m_6115_(source, stack);
            }
        };
    }

    public static interface FluidConstructor {
        public IEFluid create(IEFluids.FluidEntry var1, ResourceLocation var2, ResourceLocation var3, @Nullable Consumer<FluidAttributes.Builder> var4);
    }

    public static class EntityFluidSerializer
    implements EntityDataSerializer<FluidStack> {
        public void write(FriendlyByteBuf buf, @Nonnull FluidStack value) {
            buf.writeFluidStack(value);
        }

        @Nonnull
        public FluidStack read(FriendlyByteBuf buf) {
            return buf.readFluidStack();
        }

        @Nonnull
        public FluidStack copy(FluidStack value) {
            return value.copy();
        }
    }

    public static class Flowing
    extends IEFluid {
        public Flowing(IEFluids.FluidEntry entry, ResourceLocation stillTex, ResourceLocation flowingTex, @Nullable Consumer<FluidAttributes.Builder> buildAttributes) {
            super(entry, stillTex, flowingTex, buildAttributes);
        }

        @Override
        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.m_7180_(builder);
            builder.m_61104_(new Property[]{f_75948_});
        }
    }
}

