/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.mirror;

import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.client.models.CompositeBakedModel;
import blusunrize.immersiveengineering.client.models.mirror.MirroredModelLoader;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.IModelData;

public class CachedMirroredModel<K, T extends ICacheKeyProvider<K>>
extends CompositeBakedModel<T>
implements ICacheKeyProvider<K> {
    private final LoadingCache<K, List<BakedQuad>> cache = CacheBuilder.newBuilder().expireAfterAccess(120L, TimeUnit.SECONDS).build(CacheLoader.from(k -> MirroredModelLoader.reversedQuads(base.getQuads(k))));

    public CachedMirroredModel(T base) {
        super(base);
    }

    @Override
    public List<BakedQuad> getQuads(K key) {
        return (List)this.cache.getUnchecked(key);
    }

    @Override
    @Nullable
    public K getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return ((ICacheKeyProvider)this.base).getKey(state, side, rand, extraData);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return ICacheKeyProvider.super.getQuads(state, side, rand, extraData);
    }
}

