/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.connection;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ICacheKeyProvider;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.api.utils.QuadTransformer;
import blusunrize.immersiveengineering.api.utils.client.CombinedModelData;
import blusunrize.immersiveengineering.api.utils.client.SinglePropertyModelData;
import blusunrize.immersiveengineering.api.wires.WireApi;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.ClientUtils;
import blusunrize.immersiveengineering.client.models.BakedIEModel;
import blusunrize.immersiveengineering.client.utils.ModelUtils;
import blusunrize.immersiveengineering.common.blocks.metal.FeedthroughBlockEntity;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import blusunrize.immersiveengineering.common.util.chickenbones.Matrix4;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Transformation;
import com.mojang.math.Vector3f;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.block.model.ItemTransform;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelProperty;

public class FeedthroughModel
extends BakedIEModel
implements ICacheKeyProvider<Pair<FeedthroughCacheKey, Direction>> {
    public static final LoadingCache<FeedthroughCacheKey, SpecificFeedthroughModel> CACHE = CacheBuilder.newBuilder().expireAfterAccess(2L, TimeUnit.MINUTES).maximumSize(100L).build(CacheLoader.from(key -> new SpecificFeedthroughModel((FeedthroughCacheKey)key, s -> key.defaultColorMultipliers)));
    private static final ModelProperty<FeedthroughBlockEntity.FeedthroughData> FEEDTHROUGH = new ModelProperty();
    private static final ItemTransforms transform = new ItemTransforms(new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(75.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.375f, 0.375f, 0.375f)), new ItemTransform(new Vector3f(0.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(0.0f, 45.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.4f, 0.4f, 0.4f)), new ItemTransform(new Vector3f(), new Vector3f(), new Vector3f()), new ItemTransform(new Vector3f(30.0f, 225.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.6f, 0.6f, 0.6f)), new ItemTransform(new Vector3f(), new Vector3f(0.0f, 0.3f, 0.0f), new Vector3f(0.25f, 0.25f, 0.25f)), new ItemTransform(new Vector3f(0.0f, 180.0f, 45.0f), new Vector3f(0.0f, 0.0f, -0.1875f), new Vector3f(0.5f, 0.5f, 0.5f)));
    private static final FeedthroughItemOverride INSTANCE = new FeedthroughItemOverride();

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(Pair<FeedthroughCacheKey, Direction> key) {
        return ((SpecificFeedthroughModel)CACHE.getUnchecked((Object)((FeedthroughCacheKey)key.getFirst()))).getQuads(null, (Direction)key.getSecond(), Utils.RAND, (IModelData)EmptyModelData.INSTANCE);
    }

    @Nonnull
    public IModelData getModelData(@Nonnull BlockAndTintGetter world, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nonnull IModelData tileData) {
        ArrayList<IModelData> ret = new ArrayList<IModelData>();
        ret.add(tileData);
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof FeedthroughBlockEntity) {
            FeedthroughBlockEntity feedthrough = (FeedthroughBlockEntity)te;
            int color = Minecraft.m_91087_().m_91298_().m_92577_(feedthrough.stateForMiddle, world, pos, 0);
            FeedthroughBlockEntity.FeedthroughData d = new FeedthroughBlockEntity.FeedthroughData(feedthrough.stateForMiddle, feedthrough.reference, (Direction)state.m_61143_((Property)IEProperties.FACING_ALL), feedthrough.offset, color);
            ret.add(new SinglePropertyModelData<FeedthroughBlockEntity.FeedthroughData>(d, FEEDTHROUGH));
        }
        return CombinedModelData.combine(ret.toArray(new IModelData[0]));
    }

    public boolean m_7541_() {
        return true;
    }

    public boolean m_7539_() {
        return true;
    }

    public boolean m_7521_() {
        return false;
    }

    @Nonnull
    public TextureAtlasSprite m_6160_() {
        return ForgeModelBakery.White.instance();
    }

    @Nonnull
    public ItemTransforms m_7442_() {
        return transform;
    }

    @Nonnull
    public ItemOverrides m_7343_() {
        return INSTANCE;
    }

    @Override
    @Nullable
    public Pair<FeedthroughCacheKey, Direction> getKey(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        BlockState baseState = Blocks.f_50069_.m_49966_();
        WireType wire = WireType.COPPER;
        Direction facing = Direction.NORTH;
        int offset = 1;
        int colorMultiplier = -1;
        if (extraData.hasProperty(FEEDTHROUGH)) {
            FeedthroughBlockEntity.FeedthroughData data = (FeedthroughBlockEntity.FeedthroughData)extraData.getData(FEEDTHROUGH);
            assert (data != null);
            baseState = data.baseState();
            wire = data.wire();
            facing = data.facing();
            offset = data.offset();
            colorMultiplier = data.colorMultiplier();
        }
        return Pair.of((Object)new FeedthroughCacheKey(wire, baseState, offset, facing, MinecraftForgeClient.getRenderType(), colorMultiplier), (Object)side);
    }

    @Override
    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
        return ICacheKeyProvider.super.getQuads(state, side, rand, extraData);
    }

    public static class FeedthroughCacheKey {
        final WireType type;
        final BlockState baseState;
        final int offset;
        final Direction facing;
        final RenderType layer;
        final int defaultColorMultipliers;
        final Int2IntMap specificColorMultipliers;

        public FeedthroughCacheKey(WireType type, BlockState baseState, int offset, Direction facing, RenderType layer) {
            this(type, baseState, offset, facing, layer, -1);
        }

        public FeedthroughCacheKey(WireType type, BlockState baseState, int offset, Direction facing, RenderType layer, int colorMultiplier) {
            this.type = type;
            this.baseState = baseState;
            this.offset = offset;
            this.facing = facing;
            this.layer = layer;
            this.defaultColorMultipliers = colorMultiplier;
            this.specificColorMultipliers = new Int2IntOpenHashMap();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FeedthroughCacheKey that = (FeedthroughCacheKey)o;
            return this.offset == that.offset && this.defaultColorMultipliers == that.defaultColorMultipliers && this.type.equals(that.type) && this.baseState.equals(that.baseState) && this.facing == that.facing && Objects.equals(this.layer, that.layer);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.baseState, this.offset, this.facing, this.layer, this.defaultColorMultipliers);
        }
    }

    private static class SpecificFeedthroughModel
    extends FeedthroughModel {
        private static final float[] WHITE = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        private static final Vec3[] vertices = new Vec3[]{new Vec3(0.75, (double)0.001f, 0.75), new Vec3(0.75, (double)0.001f, 0.25), new Vec3(0.25, (double)0.001f, 0.25), new Vec3(0.25, (double)0.001f, 0.75)};
        List<List<BakedQuad>> quads = new ArrayList<List<BakedQuad>>(7);

        public SpecificFeedthroughModel(ItemStack stack) {
            WireType w = WireType.getValue(ItemNBTHelper.getString(stack, "wire"));
            BlockState state = NbtUtils.m_129241_((CompoundTag)ItemNBTHelper.getTagCompound(stack, "middle"));
            if (state.m_60734_() == Blocks.f_50016_) {
                state = Blocks.f_50078_.m_49966_();
            }
            this.init(new FeedthroughCacheKey(w, state, Integer.MAX_VALUE, Direction.NORTH, null), i -> ClientUtils.mc().getItemColors().m_92676_(stack, i));
        }

        public SpecificFeedthroughModel(FeedthroughCacheKey key, Int2IntFunction colorMultiplier) {
            this.init(key, colorMultiplier);
        }

        private void init(FeedthroughCacheKey k, Int2IntFunction colorMultiplierBasic) {
            BakedModel model = ClientUtils.mc().m_91289_().m_110907_().m_110893_(k.baseState);
            if (colorMultiplierBasic == null) {
                ItemColors colors = ClientUtils.mc().getItemColors();
                ItemStack stack = new ItemStack((ItemLike)k.baseState.m_60734_(), 1);
                colorMultiplierBasic = i -> colors.m_92676_(stack, i);
            }
            Int2IntFunction colorMultiplierFinal = colorMultiplierBasic;
            Int2IntFunction colorMultiplier = i -> {
                int ret = colorMultiplierFinal.get(i);
                k.specificColorMultipliers.put(i, ret);
                return ret;
            };
            for (int j = 0; j < 7; ++j) {
                Direction side = j < 6 ? DirectionUtils.VALUES[j] : null;
                Direction facing = k.facing;
                switch (k.offset) {
                    case 0: {
                        if (k.layer != null && !ItemBlockRenderTypes.canRenderInLayer((BlockState)k.baseState, (RenderType)k.layer)) break;
                        QuadTransformer tintTransformer = new QuadTransformer(Transformation.m_121093_(), colorMultiplier);
                        this.quads.add(model.getQuads(k.baseState, side, Utils.RAND, (IModelData)EmptyModelData.INSTANCE).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new)));
                        break;
                    }
                    case 1: {
                        facing = facing.m_122424_();
                    }
                    case -1: {
                        if (k.layer != RenderType.m_110451_()) break;
                        this.quads.add(this.getConnQuads(facing, side, k.type, new Matrix4()));
                        break;
                    }
                    case 0x7FFFFFFF: {
                        Matrix4 mat = new Matrix4();
                        mat.translate(0.0, 0.0, 1.0);
                        ArrayList<BakedQuad> all = new ArrayList<BakedQuad>(this.getConnQuads(facing, side, k.type, mat));
                        mat = new Matrix4();
                        mat.translate(0.0, 0.0, -1.0);
                        all.addAll(this.getConnQuads(facing.m_122424_(), side, k.type, mat));
                        QuadTransformer tintTransformer = new QuadTransformer(Transformation.m_121093_(), colorMultiplier);
                        all.addAll(model.m_6840_(k.baseState, side, Utils.RAND).stream().map(tintTransformer).collect(Collectors.toCollection(ArrayList::new)));
                        this.quads.add(all);
                    }
                }
                if (this.quads.size() > j) continue;
                this.quads.add((List<BakedQuad>)ImmutableList.of());
            }
        }

        private List<BakedQuad> getConnQuads(Direction facing, Direction side, WireType type, Matrix4 mat) {
            QuadTransformer transf;
            WireApi.FeedthroughModelInfo info = WireApi.INFOS.get(type);
            mat.translate(0.5, 0.5, 0.5);
            if (facing.m_122434_() == Direction.Axis.Y) {
                if (facing == Direction.UP) {
                    mat.rotate(Math.PI, 1.0, 0.0, 0.0);
                }
            } else {
                Direction rotateAround = DirectionUtils.rotateAround(facing, Direction.Axis.Y);
                mat.rotate(1.5707963267948966, rotateAround.m_122429_(), rotateAround.m_122430_(), rotateAround.m_122431_());
            }
            mat.translate(-0.5, -0.5, -0.5);
            BakedModel model = ClientUtils.mc().m_91289_().m_110907_().m_110893_((BlockState)info.connector().m_61124_((Property)IEProperties.FACING_ALL, (Comparable)Direction.DOWN));
            ArrayList<BakedQuad> conn = new ArrayList<BakedQuad>(model.getQuads(null, side, Utils.RAND, (IModelData)EmptyModelData.INSTANCE));
            if (side == facing) {
                conn.add(ModelUtils.createBakedQuad(vertices, Direction.UP, SpecificFeedthroughModel.getTexture(info), info.uvs(), WHITE, false));
            }
            if ((transf = new QuadTransformer(new Transformation(mat.toMatrix4f()), null)) != null) {
                return conn.stream().map(transf).collect(Collectors.toList());
            }
            return conn;
        }

        private static TextureAtlasSprite getTexture(WireApi.FeedthroughModelInfo info) {
            return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(info.texture());
        }

        @Override
        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            return this.quads.get(side == null ? 6 : side.m_122411_());
        }
    }

    private static class FeedthroughItemOverride
    extends ItemOverrides {
        private static final Cache<ItemStack, FeedthroughModel> ITEM_MODEL_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterAccess(60L, TimeUnit.SECONDS).build();

        private FeedthroughItemOverride() {
        }

        @Nonnull
        public BakedModel m_173464_(@Nonnull BakedModel originalModel, ItemStack stack, @Nullable ClientLevel world, @Nullable LivingEntity entity, int unused) {
            Item connItem = IEBlocks.Connectors.FEEDTHROUGH.get().m_5456_();
            if (stack.m_41720_() == connItem) {
                try {
                    return (BakedModel)ITEM_MODEL_CACHE.get((Object)stack, () -> new SpecificFeedthroughModel(stack));
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
            }
            return originalModel;
        }
    }
}

