/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.tile;

import codechicken.enderstorage.config.EnderStorageConfig;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.manager.EnderStorageManager;
import codechicken.enderstorage.storage.EnderItemStorage;
import codechicken.enderstorage.tile.TileFrequencyOwner;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.math.MathHelper;
import codechicken.lib.packet.PacketCustom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class TileEnderChest
extends TileFrequencyOwner {
    public double a_lidAngle;
    public double b_lidAngle;
    public int c_numOpen;
    public int rotation;
    private LazyOptional<IItemHandler> itemHandler = LazyOptional.empty();

    public TileEnderChest(BlockPos pos, BlockState state) {
        super((BlockEntityType)EnderStorageModContent.ENDER_CHEST_TILE.get(), pos, state);
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.f_58857_.f_46443_ || this.f_58857_.m_46467_() % 20L != 0L && this.c_numOpen == this.getStorage().getNumOpen())) {
            this.c_numOpen = this.getStorage().getNumOpen();
            this.f_58857_.m_7696_(this.m_58899_(), this.m_58900_().m_60734_(), 1, this.c_numOpen);
            this.f_58857_.m_46672_(this.f_58858_, this.m_58900_().m_60734_());
        }
        this.b_lidAngle = this.a_lidAngle;
        this.a_lidAngle = MathHelper.approachLinear((double)this.a_lidAngle, (double)(this.c_numOpen > 0 ? 1.0 : 0.0), (double)0.1);
        if (this.b_lidAngle >= 0.5 && this.a_lidAngle < 0.5) {
            this.f_58857_.m_5594_(null, this.m_58899_(), EnderStorageConfig.useVanillaEnderChestSounds ? SoundEvents.f_11888_ : SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
        } else if (this.b_lidAngle == 0.0 && this.a_lidAngle > 0.0) {
            this.f_58857_.m_5594_(null, this.m_58899_(), EnderStorageConfig.useVanillaEnderChestSounds ? SoundEvents.f_11889_ : SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
    }

    public boolean m_7531_(int id, int type) {
        if (id == 1) {
            this.c_numOpen = type;
            return true;
        }
        return false;
    }

    public double getRadianLidAngle(float frame) {
        double a = MathHelper.interpolate((double)this.b_lidAngle, (double)this.a_lidAngle, (double)frame);
        a = 1.0 - a;
        a = 1.0 - a * a * a;
        return a * 3.141593 * -0.5;
    }

    @Override
    public EnderItemStorage getStorage() {
        return EnderStorageManager.instance(this.f_58857_.f_46443_).getStorage(this.frequency, EnderItemStorage.TYPE);
    }

    @Override
    public void onFrequencySet() {
        this.itemHandler.invalidate();
        this.itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.getStorage()));
    }

    public void m_7651_() {
        super.m_7651_();
        this.itemHandler.invalidate();
    }

    @Override
    public void writeToPacket(MCDataOutput packet) {
        super.writeToPacket(packet);
        packet.writeByte(this.rotation);
    }

    @Override
    public void readFromPacket(MCDataInput packet) {
        super.readFromPacket(packet);
        this.rotation = packet.readUByte() & 3;
    }

    @Override
    public void onPlaced(LivingEntity entity) {
        this.rotation = entity != null ? (int)Math.floor((double)(entity.m_146908_() * 4.0f / 360.0f) + 2.5) & 3 : 0;
        this.onFrequencySet();
        if (!this.f_58857_.f_46443_) {
            this.sendUpdatePacket();
        }
    }

    @Override
    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128344_("rot", (byte)this.rotation);
    }

    @Override
    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.rotation = tag.m_128445_("rot") & 3;
    }

    @Override
    public boolean activate(Player player, int subHit, InteractionHand hand) {
        this.getStorage().openContainer((ServerPlayer)player, (Component)new TranslatableComponent(this.m_58900_().m_60734_().m_7705_()));
        return true;
    }

    @Override
    public boolean rotate() {
        if (!this.f_58857_.f_46443_) {
            this.rotation = (this.rotation + 1) % 4;
            PacketCustom.sendToChunk((Packet)this.m_183216_(), (Level)this.f_58857_, (int)(this.f_58858_.m_123341_() >> 4), (int)(this.f_58858_.m_123343_() >> 4));
        }
        return true;
    }

    @Override
    public int comparatorInput() {
        return this.itemHandler.map(ItemHandlerHelper::calcRedstoneFromInventory).orElse(0);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (!this.f_58859_ && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.itemHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

