/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.recipe;

import codechicken.enderstorage.api.Frequency;
import codechicken.enderstorage.init.EnderStorageModContent;
import codechicken.enderstorage.recipe.RecipeBase;
import codechicken.lib.colour.EnumColour;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class ReColourRecipe
extends RecipeBase {
    private final Ingredient ingredient;

    public ReColourRecipe(ResourceLocation id, String group, @Nonnull ItemStack result, Ingredient ingredient) {
        super(id, group, result, (NonNullList<Ingredient>)NonNullList.m_122783_((Object)Ingredient.f_43901_, (Object[])new Ingredient[]{ingredient}));
        this.ingredient = ingredient;
    }

    @Override
    public ItemStack assemble(CraftingContainer inv) {
        int foundRow = 0;
        Frequency currFreq = new Frequency();
        for (int row = 1; row < 3; ++row) {
            ItemStack stack = inv.m_8020_(1 + row * inv.m_39347_());
            if (!this.ingredient.test(stack)) continue;
            foundRow = row;
            currFreq = Frequency.readFromStack(stack);
            break;
        }
        EnumColour[] colours = new EnumColour[]{null, null, null};
        for (int col = 0; col < 3; ++col) {
            for (int row = 0; row < foundRow; ++row) {
                EnumColour colour;
                ItemStack stack = inv.m_8020_(col + row * inv.m_39347_());
                if (stack.m_41619_() || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null) continue;
                colours[col] = colours[col] == null ? colour : EnumColour.mix((EnumColour)colours[col], (EnumColour)colour);
            }
        }
        currFreq.setLeft(colours[0]);
        currFreq.setMiddle(colours[1]);
        currFreq.setRight(colours[2]);
        return currFreq.writeToStack(super.assemble(inv));
    }

    @Override
    public boolean matches(CraftingContainer inv, Level worldIn) {
        ItemStack stack;
        int row;
        int col;
        if (inv.m_7983_()) {
            return false;
        }
        boolean inputFound = false;
        int foundRow = 0;
        for (int row2 = 1; row2 < 3; ++row2) {
            ItemStack stack2 = inv.m_8020_(1 + row2 * inv.m_39347_());
            if (stack2.m_41619_() || !this.ingredient.test(stack2)) continue;
            foundRow = row2;
            inputFound = true;
            break;
        }
        if (!inputFound) {
            return false;
        }
        EnumColour[] colours = new EnumColour[]{null, null, null};
        boolean hasDye = false;
        for (col = 0; col < 3; ++col) {
            for (row = 0; row < foundRow; ++row) {
                EnumColour colour;
                stack = inv.m_8020_(col + row * inv.m_39347_());
                if (stack.m_41619_() || (colour = EnumColour.fromDyeStack((ItemStack)stack)) == null) continue;
                if (colours[col] != null) {
                    EnumColour merge = EnumColour.mix((EnumColour)colours[col], (EnumColour)colour);
                    if (merge == null || merge == colour) {
                        return false;
                    }
                    colours[col] = merge;
                    continue;
                }
                hasDye = true;
                colours[col] = colour;
            }
        }
        if (hasDye) {
            for (col = 0; col < 3; ++col) {
                for (row = 0; row < 3; ++row) {
                    stack = inv.m_8020_(col + row * inv.m_39347_());
                    if (stack.m_41619_()) continue;
                    if (row >= foundRow && EnumColour.fromDyeStack((ItemStack)stack) != null) {
                        return false;
                    }
                    if (this.ingredient.test(stack) || EnumColour.fromDyeStack((ItemStack)stack) != null) continue;
                    return false;
                }
            }
        }
        return hasDye;
    }

    public boolean m_5598_() {
        return true;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)EnderStorageModContent.RECOLOUR_RECIPE_SERIALIZER.get();
    }

    public static class Serializer
    extends ForgeRegistryEntry<RecipeSerializer<?>>
    implements RecipeSerializer<ReColourRecipe> {
        public ReColourRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            ItemStack result = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            JsonElement ing = json.get("ingredient");
            Ingredient ingredient = ing != null ? Ingredient.m_43917_((JsonElement)ing) : Ingredient.m_43927_((ItemStack[])new ItemStack[]{result});
            return new ReColourRecipe(recipeId, group, result, ingredient);
        }

        @Nullable
        public ReColourRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            Ingredient ing = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ItemStack result = buffer.m_130267_();
            return new ReColourRecipe(recipeId, s, result, ing);
        }

        public void toNetwork(FriendlyByteBuf buffer, ReColourRecipe recipe) {
            buffer.m_130070_(recipe.group);
            recipe.ingredient.m_43923_(buffer);
            buffer.m_130055_(recipe.output);
        }
    }
}

