/*
 * Decompiled with CFR 0.152.
 */
package codechicken.enderstorage.api;

import codechicken.lib.colour.EnumColour;
import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.util.Copyable;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public final class Frequency
implements Copyable<Frequency> {
    public EnumColour left;
    public EnumColour middle;
    public EnumColour right;
    public UUID owner;
    public Component ownerName;

    public Frequency() {
        this(EnumColour.WHITE, EnumColour.WHITE, EnumColour.WHITE);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right) {
        this(left, middle, right, null, null);
    }

    public Frequency(EnumColour left, EnumColour middle, EnumColour right, UUID owner, Component ownerName) {
        this.left = left;
        this.middle = middle;
        this.right = right;
        this.owner = owner;
        this.ownerName = ownerName;
    }

    public Frequency(CompoundTag tagCompound) {
        this.read_internal(tagCompound);
    }

    public static Frequency fromString(String left, String middle, String right) {
        return Frequency.fromString(left, middle, right, null, null);
    }

    public static Frequency fromString(String left, String middle, String right, UUID owner, Component ownerName) {
        EnumColour c1 = EnumColour.fromName((String)left);
        EnumColour c2 = EnumColour.fromName((String)middle);
        EnumColour c3 = EnumColour.fromName((String)right);
        if (c1 == null) {
            throw new RuntimeException(left + " is an invalid colour!");
        }
        if (c2 == null) {
            throw new RuntimeException(middle + " is an invalid colour!");
        }
        if (c3 == null) {
            throw new RuntimeException(right + " is an invalid colour!");
        }
        return new Frequency(c1, c2, c3, owner, ownerName);
    }

    public Frequency setLeft(EnumColour left) {
        if (left != null) {
            this.left = left;
        }
        return this;
    }

    public Frequency setMiddle(EnumColour middle) {
        if (middle != null) {
            this.middle = middle;
        }
        return this;
    }

    public Frequency setRight(EnumColour right) {
        if (right != null) {
            this.right = right;
        }
        return this;
    }

    public Frequency setOwner(UUID owner) {
        this.owner = owner;
        return this;
    }

    public Frequency setOwnerName(Component ownerName) {
        this.ownerName = ownerName;
        return this;
    }

    public boolean hasOwner() {
        return this.owner != null && this.ownerName != null;
    }

    public Frequency set(EnumColour[] colours) {
        this.setLeft(colours[0]);
        this.setMiddle(colours[1]);
        this.setRight(colours[2]);
        return this;
    }

    public Frequency set(Frequency frequency) {
        this.setLeft(frequency.left);
        this.setMiddle(frequency.middle);
        this.setRight(frequency.right);
        this.setOwner(frequency.owner);
        this.setOwnerName(frequency.ownerName);
        return this;
    }

    public EnumColour getLeft() {
        return this.left;
    }

    public EnumColour getMiddle() {
        return this.middle;
    }

    public EnumColour getRight() {
        return this.right;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public Component getOwnerName() {
        return this.ownerName;
    }

    public EnumColour[] toArray() {
        return new EnumColour[]{this.left, this.middle, this.right};
    }

    protected Frequency read_internal(CompoundTag tagCompound) {
        this.left = EnumColour.fromWoolMeta((int)tagCompound.m_128451_("left"));
        this.middle = EnumColour.fromWoolMeta((int)tagCompound.m_128451_("middle"));
        this.right = EnumColour.fromWoolMeta((int)tagCompound.m_128451_("right"));
        if (tagCompound.m_128403_("owner")) {
            this.owner = tagCompound.m_128342_("owner");
        }
        if (tagCompound.m_128441_("owner_name")) {
            this.ownerName = Component.Serializer.m_130701_((String)tagCompound.m_128461_("owner_name"));
        }
        return this;
    }

    protected CompoundTag write_internal(CompoundTag tagCompound) {
        tagCompound.m_128405_("left", this.left.getWoolMeta());
        tagCompound.m_128405_("middle", this.middle.getWoolMeta());
        tagCompound.m_128405_("right", this.right.getWoolMeta());
        if (this.owner != null) {
            tagCompound.m_128362_("owner", this.owner);
        }
        if (this.ownerName != null) {
            tagCompound.m_128359_("owner_name", Component.Serializer.m_130703_((Component)this.ownerName));
        }
        return tagCompound;
    }

    public CompoundTag writeToNBT(CompoundTag tagCompound) {
        this.write_internal(tagCompound);
        return tagCompound;
    }

    public void writeToPacket(MCDataOutput packet) {
        packet.writeCompoundNBT(this.write_internal(new CompoundTag()));
    }

    public static Frequency readFromPacket(MCDataInput packet) {
        return new Frequency(packet.readCompoundNBT());
    }

    public static Frequency readFromStack(ItemStack stack) {
        CompoundTag stackTag;
        if (stack.m_41782_() && (stackTag = stack.m_41783_()).m_128441_("Frequency")) {
            return new Frequency(stackTag.m_128469_("Frequency"));
        }
        return new Frequency();
    }

    public ItemStack writeToStack(ItemStack stack) {
        CompoundTag tagCompound = stack.m_41784_();
        tagCompound.m_128365_("Frequency", (Tag)this.write_internal(new CompoundTag()));
        return stack;
    }

    public String toModelLoc() {
        return "left=" + this.getLeft().m_7912_() + ",middle=" + this.getMiddle().m_7912_() + ",right=" + this.getRight().m_7912_() + ",owned=" + this.hasOwner();
    }

    public String toString() {
        Object owner = "";
        if (this.hasOwner()) {
            owner = ",owner=" + this.owner;
        }
        return "left=" + this.getLeft().m_7912_() + ",middle=" + this.getMiddle().m_7912_() + ",right=" + this.getRight().m_7912_() + (String)owner;
    }

    public Component getTooltip() {
        return new TranslatableComponent(this.getLeft().getUnlocalizedName()).m_130946_("/").m_7220_((Component)new TranslatableComponent(this.getMiddle().getUnlocalizedName())).m_130946_("/").m_7220_((Component)new TranslatableComponent(this.getRight().getUnlocalizedName()));
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public Frequency copy() {
        return new Frequency(this.left, this.middle, this.right, this.owner, this.ownerName);
    }
}

