/*
 * Decompiled with CFR 0.152.
 */
package twistedgate.immersiveposts.common;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import twistedgate.immersiveposts.ImmersivePosts;
import twistedgate.immersiveposts.api.posts.IPostMaterial;
import twistedgate.immersiveposts.common.blocks.HorizontalTrussBlock;
import twistedgate.immersiveposts.common.blocks.MetalFenceBlock;
import twistedgate.immersiveposts.common.blocks.PostBaseBlock;
import twistedgate.immersiveposts.common.blocks.PostBlock;
import twistedgate.immersiveposts.common.items.IPOItemBase;
import twistedgate.immersiveposts.common.tileentity.IPOTileTypes;
import twistedgate.immersiveposts.enums.EnumPostMaterial;

public class IPOContent {
    private static final DeferredRegister<Block> BLOCK_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"immersiveposts");
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"immersiveposts");

    public static final void addRegistersToEventBus(IEventBus eventBus) {
        BLOCK_REGISTER.register(eventBus);
        ITEM_REGISTER.register(eventBus);
        IPOTileTypes.REGISTER.register(eventBus);
    }

    protected static final <T extends Block> RegistryObject<T> registerBlock(String name, Supplier<T> constructor) {
        return BLOCK_REGISTER.register(name, constructor);
    }

    protected static final RegistryObject<PostBlock> registerPostBlock(EnumPostMaterial material) {
        return BLOCK_REGISTER.register(material.getBlockName(), () -> new PostBlock(material));
    }

    protected static final RegistryObject<HorizontalTrussBlock> registerTrussBlock(EnumPostMaterial material) {
        return BLOCK_REGISTER.register(material.getBlockName() + "_truss", () -> new HorizontalTrussBlock(material));
    }

    protected static final RegistryObject<FenceBlock> registerMetalFence(String name) {
        name = "fence_" + (String)name;
        RegistryObject block = BLOCK_REGISTER.register((String)name, MetalFenceBlock::new);
        ITEM_REGISTER.register((String)name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(ImmersivePosts.creativeTab)));
        Blocks.Fences.ALL_FENCES.add((RegistryObject<FenceBlock>)block);
        return block;
    }

    protected static final <T extends Item> RegistryObject<T> registerItem(String name, Supplier<T> constructor) {
        return ITEM_REGISTER.register(name, constructor);
    }

    public static final void populate() {
        Blocks.forceClassLoad();
        Blocks.Fences.forceClassLoad();
        Blocks.Posts.forceClassLoad();
        Blocks.HorizontalTruss.forceClassLoad();
        Items.forceClassLoad();
    }

    public static class Blocks {
        public static final RegistryObject<PostBaseBlock> POST_BASE = IPOContent.registerBlock("postbase", PostBaseBlock::new);

        private static void forceClassLoad() {
        }

        static {
            IPOContent.registerItem("postbase", () -> new PostBaseBlock.ItemPostBase((Block)POST_BASE.get()));
        }

        public static class HorizontalTruss {
            static EnumMap<EnumPostMaterial, RegistryObject<HorizontalTrussBlock>> ALL = (EnumMap)Util.m_137469_(new EnumMap(EnumPostMaterial.class), map -> {
                for (EnumPostMaterial material : EnumPostMaterial.values()) {
                    map.put(material, IPOContent.registerTrussBlock(material));
                }
            });

            public static HorizontalTrussBlock get(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return (HorizontalTrussBlock)ALL.get(material).get();
            }

            private static void forceClassLoad() {
            }
        }

        public static class Posts {
            static final EnumMap<EnumPostMaterial, RegistryObject<PostBlock>> ALL = (EnumMap)Util.m_137469_(new EnumMap(EnumPostMaterial.class), map -> {
                for (EnumPostMaterial material : EnumPostMaterial.values()) {
                    map.put(material, IPOContent.registerPostBlock(material));
                }
            });

            public static PostBlock get(@Nonnull IPostMaterial material) {
                if (!ALL.containsKey(material)) {
                    return null;
                }
                return (PostBlock)ALL.get(material).get();
            }

            private static void forceClassLoad() {
            }
        }

        public static class Fences {
            public static final List<RegistryObject<FenceBlock>> ALL_FENCES = new ArrayList<RegistryObject<FenceBlock>>();
            public static final RegistryObject<FenceBlock> IRON = IPOContent.registerMetalFence("iron");
            public static final RegistryObject<FenceBlock> GOLD = IPOContent.registerMetalFence("gold");
            public static final RegistryObject<FenceBlock> COPPER = IPOContent.registerMetalFence("copper");
            public static final RegistryObject<FenceBlock> LEAD = IPOContent.registerMetalFence("lead");
            public static final RegistryObject<FenceBlock> SILVER = IPOContent.registerMetalFence("silver");
            public static final RegistryObject<FenceBlock> NICKEL = IPOContent.registerMetalFence("nickel");
            public static final RegistryObject<FenceBlock> CONSTANTAN = IPOContent.registerMetalFence("constantan");
            public static final RegistryObject<FenceBlock> ELECTRUM = IPOContent.registerMetalFence("electrum");
            public static final RegistryObject<FenceBlock> URANIUM = IPOContent.registerMetalFence("uranium");

            private static void forceClassLoad() {
            }
        }
    }

    public static class Items {
        public static final RegistryObject<Item> ROD_GOLD = IPOContent.registerItem("stick_gold", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_COPPER = IPOContent.registerItem("stick_copper", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_LEAD = IPOContent.registerItem("stick_lead", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_SILVER = IPOContent.registerItem("stick_silver", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_NICKEL = IPOContent.registerItem("stick_nickel", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_CONSTANTAN = IPOContent.registerItem("stick_constantan", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_ELECTRUM = IPOContent.registerItem("stick_electrum", IPOItemBase::new);
        public static final RegistryObject<Item> ROD_URANIUM = IPOContent.registerItem("stick_uranium", IPOItemBase::new);

        private static void forceClassLoad() {
        }
    }
}

