/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.rechiseled.screen;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.render.RenderUtils;
import com.supermartijn642.rechiseled.screen.BlockCapture;
import com.supermartijn642.rechiseled.screen.BlockCaptureLevel;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ScreenBlockRenderer {
    private static final PoseStack POSE_STACK = new PoseStack();
    private static BlockCaptureLevel fakeLevel;

    public static void drawBlock(BlockCapture capture, double x, double y, double scale, float yaw, float pitch, boolean doShading) {
        AABB bounds = capture.getBounds();
        double span = Math.sqrt(bounds.m_82362_() * bounds.m_82362_() + bounds.m_82376_() * bounds.m_82376_() + bounds.m_82385_() * bounds.m_82385_());
        scale /= span;
        if (fakeLevel == null) {
            fakeLevel = new BlockCaptureLevel();
        }
        fakeLevel.setCapture(capture);
        RenderSystem.m_157191_().m_85836_();
        RenderSystem.m_157191_().m_85841_(1.0f, -1.0f, 1.0f);
        RenderSystem.m_157182_();
        POSE_STACK.m_85836_();
        POSE_STACK.m_85837_(x, -y, 350.0);
        POSE_STACK.m_85841_((float)scale, (float)scale, (float)scale);
        POSE_STACK.m_85845_(new Quaternion(pitch, yaw, 0.0f, true));
        if (doShading) {
            Lighting.m_84931_();
        }
        MultiBufferSource.BufferSource renderTypeBuffer = RenderUtils.getMainBufferSource();
        for (Map.Entry<BlockPos, BlockState> entry : capture.getBlocks()) {
            ScreenBlockRenderer.renderBlock(entry.getKey(), entry.getValue(), POSE_STACK, (MultiBufferSource)renderTypeBuffer);
        }
        renderTypeBuffer.m_109911_();
        RenderSystem.m_69482_();
        if (doShading) {
            Lighting.m_84930_();
        }
        POSE_STACK.m_85849_();
        RenderSystem.m_157191_().m_85849_();
        RenderSystem.m_157182_();
        fakeLevel.setCapture(null);
    }

    private static void renderBlock(BlockPos pos, BlockState state, PoseStack matrixStack, MultiBufferSource renderTypeBuffer) {
        matrixStack.m_85836_();
        matrixStack.m_85837_((double)pos.m_123341_() - 0.5, (double)pos.m_123342_() - 0.5, (double)pos.m_123343_() - 0.5);
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        IModelData modelData = model.getModelData((BlockAndTintGetter)fakeLevel, pos, state, (IModelData)EmptyModelData.INSTANCE);
        RenderType renderType = ItemBlockRenderTypes.m_109284_((BlockState)state, (boolean)true);
        ScreenBlockRenderer.renderModel(model, state, matrixStack, renderTypeBuffer.m_6299_(renderType), modelData);
        matrixStack.m_85849_();
    }

    private static void renderModel(BakedModel modelIn, BlockState state, PoseStack matrixStackIn, VertexConsumer bufferIn, IModelData modelData) {
        Random random = new Random();
        for (Direction direction : Direction.values()) {
            random.setSeed(42L);
            ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, direction, random, modelData));
        }
        random.setSeed(42L);
        ScreenBlockRenderer.renderQuads(matrixStackIn, bufferIn, modelIn.getQuads(state, null, random, modelData));
    }

    private static void renderQuads(PoseStack matrixStackIn, VertexConsumer bufferIn, List<BakedQuad> quadsIn) {
        PoseStack.Pose matrix = matrixStackIn.m_85850_();
        for (BakedQuad bakedquad : quadsIn) {
            bufferIn.putBulkData(matrix, bakedquad, 1.0f, 1.0f, 1.0f, 1.0f, 0xF000F0, OverlayTexture.f_118083_, false);
        }
    }
}

