/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.util.registry;

import com.google.common.collect.Maps;
import dev.architectury.registry.registries.DeferredRegister;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.level.block.Block;
import org.apache.commons.lang3.tuple.Pair;
import party.lemons.biomemakeover.util.registry.BlockWithItem;

public final class RegistryHelper {
    private static HashMap<Registry, DeferredRegister> DEFERRED_REGISTRIES = Maps.newHashMap();

    @SafeVarargs
    public static <T> void register(String modid, Registry<T> registry, Class typeClass, Class from, RegistryCallback<T> ... callbacks) {
        ResourceKey key = registry.m_123023_();
        DeferredRegister register = DeferredRegister.create((String)modid, (ResourceKey)key);
        try {
            Field[] fields;
            for (Field field : fields = from.getDeclaredFields()) {
                if (!typeClass.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                Object value = field.get(from);
                String regName = field.getName().toLowerCase(Locale.ENGLISH);
                ResourceLocation id = new ResourceLocation(modid, regName);
                register.register(id, () -> value);
                for (RegistryCallback<Object> registryCallback : callbacks) {
                    registryCallback.callback(registry, value, id);
                }
            }
            register.register();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> void registerObject(Registry<T> registry, ResourceLocation id, T object) {
    }

    public static <T> void gatherFields(String modid, Class<T> typeClass, Class<?> from, List<Pair<ResourceLocation, T>> list) {
        try {
            Field[] fields;
            for (Field field : fields = from.getDeclaredFields()) {
                if (!typeClass.isAssignableFrom(field.getType()) || !Modifier.isStatic(field.getModifiers()) || !Modifier.isFinal(field.getModifiers())) continue;
                Object value = field.get(from);
                String regName = field.getName().toLowerCase(Locale.ENGLISH);
                ResourceLocation id = new ResourceLocation(modid, regName);
                list.add(Pair.of((Object)id, (Object)value));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private RegistryHelper() {
    }

    public static interface RegistryCallback<T> {
        public void callback(Registry<T> var1, T var2, ResourceLocation var3);
    }

    public static class BlockWithItemCallback
    implements RegistryCallback<Block> {
        private final CreativeModeTab group;

        public BlockWithItemCallback(CreativeModeTab group) {
            this.group = group;
        }

        @Override
        public void callback(Registry<Block> registry, Block bl, ResourceLocation id) {
            if (!(bl instanceof BlockWithItem)) {
                return;
            }
            BlockWithItem info = (BlockWithItem)bl;
            if (!info.hasItem()) {
                return;
            }
            info.registerItem(id, this.group);
        }
    }
}

