/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin.enchantment;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import party.lemons.biomemakeover.init.BMEnchantments;

@Mixin(value={Entity.class})
public abstract class EntityMixin {
    @Shadow
    private int f_19831_;

    @Shadow
    public abstract void m_20282_(boolean var1);

    @Shadow
    public abstract int m_20146_();

    @Shadow
    public abstract void m_20301_(int var1);

    @Inject(at={@At(value="HEAD")}, method={"setRemainingFireTicks"}, cancellable=true)
    public void onSetFire(int ticks, CallbackInfo cbi) {
        Entity entity;
        if (ticks > this.f_19831_ && (entity = (Entity)this) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            float level = EnchantmentHelper.m_44836_((Enchantment)BMEnchantments.FLAMMABILITY_CURSE.get(), (LivingEntity)living);
            if (level > 0.0f) {
                this.f_19831_ = ticks = (int)((float)ticks + (float)ticks * (level / 2.0f));
                cbi.cancel();
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"updateSwimming"}, cancellable=true)
    public void updateSwimming(CallbackInfo cbi) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            if (EnchantmentHelper.m_44836_((Enchantment)BMEnchantments.DEPTH_CURSE.get(), (LivingEntity)living) > 0) {
                this.m_20282_(false);
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"getMaxAirSupply"}, cancellable=true)
    public void getMaxAir(CallbackInfoReturnable<Integer> cbi) {
        Entity entity = (Entity)this;
        if (entity instanceof LivingEntity) {
            float level;
            LivingEntity living = (LivingEntity)entity;
            if (((Entity)this).f_19797_ > 20 && (level = (float)EnchantmentHelper.m_44836_((Enchantment)BMEnchantments.SUFFOCATION_CURSE.get(), (LivingEntity)living)) > 0.0f) {
                int maxAir = (int)(300.0f / (level * 1.5f));
                if (this.m_20146_() > maxAir) {
                    this.m_20301_(maxAir);
                }
                cbi.setReturnValue((Object)maxAir);
            }
        }
    }
}

