/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.mixin.badlands;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.monster.PatrollingMonster;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import party.lemons.biomemakeover.util.extension.HorseHat;

@Mixin(value={Horse.class})
public class HorseMixin
extends AbstractHorse
implements HorseHat {
    private static final EntityDataAccessor<Boolean> HAS_HAT = SynchedEntityData.m_135353_(Horse.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private boolean cowboySpawned = false;

    protected HorseMixin(EntityType<? extends AbstractHorse> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(at={@At(value="TAIL")}, method={"defineSynchedData"})
    private void initDataTacker(CallbackInfo cbi) {
        this.m_20088_().m_135372_(HAS_HAT, (Object)false);
    }

    @Inject(at={@At(value="RETURN")}, method={"addAdditionalSaveData"})
    private void writeData(CompoundTag tag, CallbackInfo cbi) {
        tag.m_128379_("Hat", this.hasHat());
        tag.m_128379_("CowboySpawned", this.cowboySpawned);
    }

    @Inject(at={@At(value="RETURN")}, method={"readAdditionalSaveData"})
    private void readData(CompoundTag tag, CallbackInfo cbi) {
        if (tag.m_128441_("Hat")) {
            this.m_20088_().m_135381_(HAS_HAT, (Object)tag.m_128471_("Hat"));
        }
        if (tag.m_128441_("CowboySpawned")) {
            this.cowboySpawned = tag.m_128471_("CowboySpawned");
        }
    }

    public boolean m_6785_(double distanceSquared) {
        if (this.m_6688_() == null) {
            if (this.m_6254_() || this.m_7481_() || this.m_21523_()) {
                this.cowboySpawned = false;
                return false;
            }
            return this.cowboySpawned;
        }
        Entity entity = this.m_6688_();
        if (entity instanceof PatrollingMonster) {
            PatrollingMonster pm = (PatrollingMonster)entity;
            return pm.m_6785_(distanceSquared);
        }
        return this.cowboySpawned;
    }

    @Override
    public boolean hasHat() {
        return (Boolean)this.m_20088_().m_135370_(HAS_HAT);
    }

    @Override
    public void setHat() {
        this.m_20088_().m_135381_(HAS_HAT, (Object)true);
    }

    @Override
    public void setCowboySpawned() {
        this.cowboySpawned = true;
    }
}

