/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion.room;

import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;
import party.lemons.biomemakeover.level.feature.mansion.RoomType;
import party.lemons.biomemakeover.level.feature.mansion.room.MansionRoom;
import party.lemons.biomemakeover.util.Grid;

public class BigMansionRoom
extends MansionRoom {
    private boolean isDummy;
    private Direction partnerDirection;
    private BlockPos partnerPos;

    public BigMansionRoom(BlockPos position, Direction partnerDirection, boolean isDummy) {
        super(position, isDummy ? RoomType.ROOM_BIG_DUMMY : RoomType.ROOM_BIG);
        this.isDummy = isDummy;
        this.partnerDirection = partnerDirection;
        this.partnerPos = position.m_142300_(partnerDirection);
    }

    @Override
    public Rotation getRotation(Random random) {
        if (this.isDummy()) {
            return Rotation.NONE;
        }
        switch (this.partnerDirection) {
            case NORTH: {
                return Rotation.COUNTERCLOCKWISE_90;
            }
            case SOUTH: {
                return Rotation.CLOCKWISE_90;
            }
            case WEST: {
                return Rotation.CLOCKWISE_180;
            }
            case EAST: {
                return Rotation.NONE;
            }
        }
        return Rotation.NONE;
    }

    @Override
    public ResourceLocation getTemplate(Random random) {
        if (this.isDummy()) {
            return MansionFeature.EMPTY;
        }
        return MansionFeature.ROOM_BIG.get(random.nextInt(MansionFeature.ROOM_BIG.size()));
    }

    public boolean isDummy() {
        return this.isDummy;
    }

    @Override
    public void addWalls(Random random, BlockPos wallPos, StructureManager manager, Grid<MansionRoom> roomGrid, StructurePiecesBuilder children) {
        boolean ground;
        boolean bl = ground = this.getPosition().m_123342_() == 0;
        if (this.getRoomType().hasWalls()) {
            BlockPos cornerPos1;
            if (this.isConnected(Direction.NORTH)) {
                this.addWall(Direction.NORTH, manager, children, this.getInnerWall(random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground);
            } else if (!roomGrid.contains(this.getPosition().m_142127_()) || !roomGrid.get(this.getPosition().m_142127_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.NORTH, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11), Rotation.CLOCKWISE_180, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_142127_())) {
                this.addWall(Direction.NORTH, manager, children, this.getFlatWall(random), wallPos.m_5484_(Direction.NORTH, 2), Rotation.NONE, ground);
            }
            if (this.isConnected(Direction.WEST)) {
                this.addWall(Direction.WEST, manager, children, this.getInnerWall(random), wallPos, Rotation.CLOCKWISE_90, ground);
            } else if (!roomGrid.contains(this.getPosition().m_142125_()) || !roomGrid.get(this.getPosition().m_142125_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.WEST, roomGrid, random), wallPos.m_142127_(), Rotation.CLOCKWISE_90, ground, true));
            } else if (roomGrid.contains(this.getPosition().m_142125_())) {
                this.addWall(Direction.WEST, manager, children, this.getFlatWall(random), wallPos, Rotation.CLOCKWISE_90, ground);
            }
            if (!roomGrid.contains(this.getPosition().m_142126_()) || !roomGrid.get(this.getPosition().m_142126_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.EAST, roomGrid, random), wallPos.m_5484_(Direction.EAST, 11).m_142125_().m_142383_(11), Rotation.COUNTERCLOCKWISE_90, ground, true));
            }
            if (!roomGrid.contains(this.getPosition().m_142128_()) || !roomGrid.get(this.getPosition().m_142128_()).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, this.getOuterWall(Direction.SOUTH, roomGrid, random), wallPos.m_5484_(Direction.SOUTH, 10).m_142125_(), Rotation.NONE, ground, true));
            }
            if (roomGrid.contains(cornerPos1 = this.getPosition().m_142300_(Direction.NORTH).m_142300_(Direction.WEST)) && roomGrid.get(cornerPos1).getRoomType().hasWalls()) {
                children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, MansionFeature.CORNER_FILLER.toString(), wallPos.m_142300_(Direction.WEST).m_142300_(Direction.NORTH).m_142082_(0, 0, 0), Rotation.NONE, ground, false));
            }
        }
    }

    private void addWall(Direction direction, StructureManager manager, StructurePiecesBuilder children, String wall, BlockPos pos, Rotation rotation, boolean ground) {
        if (direction == this.partnerDirection) {
            return;
        }
        children.m_142679_((StructurePiece)new MansionFeature.Piece(manager, wall, pos, rotation, ground, false));
    }
}

