/*
 * Decompiled with CFR 0.152.
 */
package party.lemons.biomemakeover.level.feature.mansion;

import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import party.lemons.biomemakeover.level.feature.mansion.MansionFeature;

public enum RoomType {
    CORRIDOR(true, true, true, false, null),
    ROOM(false, true, true, false, MansionFeature.ROOMS),
    ROOM_BIG(false, false, true, false, MansionFeature.ROOMS),
    ROOM_BIG_DUMMY(false, false, true, false, MansionFeature.ROOMS),
    STAIRS_UP(false, false, true, true, MansionFeature.STAIR_UP),
    STAIRS_DOWN(false, false, true, true, MansionFeature.STAIR_DOWN),
    ROOF(false, false, false, false, null),
    GARDEN(true, true, true, false, MansionFeature.GARDEN),
    TOWER_BASE(false, false, true, true, MansionFeature.TOWER_BASE),
    TOWER_MID(false, false, false, true, MansionFeature.TOWER_MID),
    TOWER_TOP(false, false, false, true, MansionFeature.TOWER_TOP),
    DUNGEON_STAIRS_TOP(false, false, true, true, MansionFeature.DUNGEON_STAIR_TOP),
    DUNGEON_STAIRS_MID(false, false, false, true, MansionFeature.DUNGEON_STAIR_MID),
    DUNGEON_STAIRS_BOTTOM(false, false, true, true, MansionFeature.DUNGEON_STAIR_BOTTOM),
    DUNGEON_ROOM(false, true, true, true, MansionFeature.DUNGEON_ROOM),
    BOSS(true, false, false, false, MansionFeature.BOSS_ROOM),
    ENTRANCE(true, false, true, false, MansionFeature.ENTRANCE);

    public final boolean doorRequired;
    private final boolean isReplaceable;
    private final boolean hasWalls;
    private final boolean columnRotation;
    private final List<ResourceLocation> templates;

    private RoomType(boolean doorRequired, boolean isReplaceable, boolean hasWalls, boolean columnRotation, List<ResourceLocation> templates) {
        this.doorRequired = doorRequired;
        this.isReplaceable = isReplaceable;
        this.hasWalls = hasWalls;
        this.columnRotation = columnRotation;
        this.templates = templates;
    }

    public ResourceLocation getRandomTemplate(BlockPos pos, Random random) {
        if (this.columnRotation) {
            int index = Math.abs((pos.m_123341_() + pos.m_123343_()) % this.templates.size());
            return this.templates.get(index);
        }
        return this.templates.get(random.nextInt(this.templates.size()));
    }

    public boolean isReplaceable() {
        return this.isReplaceable;
    }

    public boolean hasWalls() {
        return this.hasWalls;
    }

    public boolean hasWindows() {
        return this == ROOM || this == ROOM_BIG || this == ROOM_BIG_DUMMY || this == STAIRS_DOWN || this == STAIRS_UP;
    }

    public boolean hasColumnRotation() {
        return this.columnRotation;
    }

    public boolean isDungeon() {
        return this == DUNGEON_ROOM || this == DUNGEON_STAIRS_MID || this == DUNGEON_STAIRS_BOTTOM;
    }
}

